/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.idpool;

import bsc.sdk.api.application.idpool.IdPoolSettings;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class IdPool {
    private GENERATOR_TYPE type;
    private Map<String, Long> assignedIds = new HashMap<String, Long>();
    private String poolId;
    private long timeToLive = 0L;
    private int maxTries = 1000000;
    private String prefix = "";
    private String suffix = "";
    private SecureRandom random = null;
    private int baseLength = 25;
    private String insert = "-";
    private int insertPeriod = 5;
    private long counter = 0L;

    public IdPool(IdPoolSettings settings) {
        this.poolId = Objects.requireNonNull(settings, "settings must not be null!").getId();
        this.type = settings.getType();
        this.timeToLive = settings.getTimeToLive();
        this.prefix = settings.getPrefix();
        this.suffix = settings.getSuffix();
        this.baseLength = settings.getBaseLength();
        this.insert = settings.getInsert();
        this.insertPeriod = settings.getInsertPeriod();
    }

    public IdPool(GENERATOR_TYPE type, String poolId) {
        this.poolId = Objects.requireNonNull(poolId, "poolId must not be null!");
        this.type = Objects.requireNonNull(type, "IdPool generator type must not be null!");
    }

    public synchronized String getId() {
        boolean alreadyExists;
        int count = 0;
        String result = null;
        do {
            String id;
            if (alreadyExists = this.assignedIds.containsKey(id = this.generateId())) continue;
            result = id;
        } while (alreadyExists && ++count < this.maxTries);
        if (result != null) {
            this.assignedIds.put(result, System.currentTimeMillis());
        }
        return Objects.requireNonNull(result, "No assignable ID found inside pool: " + this.poolId);
    }

    public static String insertIntoString(String text, String insert, int period) {
        if (period == 0 || insert == null || insert.length() == 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder(text.length() + insert.length() * (text.length() / period) + 1);
        String prefix = "";
        for (int index = 0; index < text.length(); index += period) {
            builder.append(prefix);
            prefix = insert;
            builder.append(text.substring(index, Math.min(index + period, text.length())));
        }
        return builder.toString();
    }

    private String generateId() {
        String result = "";
        switch (this.type) {
            case RANDOM: {
                result = IdPool.insertIntoString(new BigInteger(5 * this.baseLength, this.getRandom()).toString(32), this.insert, this.insertPeriod);
                break;
            }
            case SEQUENCE_LONG: {
                if (this.counter == Long.MAX_VALUE) {
                    this.counter = 0L;
                }
                ++this.counter;
                result = String.valueOf(this.counter);
                break;
            }
            case SEQUENCE_INT: {
                if (this.counter == Integer.MAX_VALUE) {
                    this.counter = 0L;
                }
                ++this.counter;
                result = String.valueOf(this.counter);
                break;
            }
            case RANDOM_GUID: {
                result = UUID.randomUUID().toString();
                break;
            }
            default: {
                return null;
            }
        }
        return this.prefix + result + this.suffix;
    }

    public synchronized void cleanPool() {
        if (this.timeToLive <= 0L) {
            return;
        }
        long expireTime = System.currentTimeMillis() - this.timeToLive;
        Iterator<Map.Entry<String, Long>> itr = this.assignedIds.entrySet().iterator();
        while (itr.hasNext()) {
            if (itr.next().getValue() > expireTime) continue;
            itr.remove();
        }
    }

    protected SecureRandom getRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    public synchronized void freeID(String id) {
        if (id != null) {
            this.assignedIds.remove(id);
        }
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public void setMaxTries(int maxTries) {
        this.maxTries = maxTries;
    }

    public String getInsert() {
        return this.insert;
    }

    public void setInsert(String insert) {
        this.insert = insert;
    }

    public int getInsertPeriod() {
        return this.insertPeriod;
    }

    public void setInsertPeriod(int insertPeriod) {
        this.insertPeriod = insertPeriod;
    }

    public int getBaseLength() {
        return this.baseLength;
    }

    public void setBaseLength(int baseLength) {
        this.baseLength = baseLength;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public synchronized void importAssignedIds(Collection<String> ids) {
        for (String id : ids) {
            this.assignedIds.put(id, System.currentTimeMillis());
        }
    }

    public synchronized void importAssignedIds(Map<String, Long> ids) {
        this.assignedIds.putAll(ids);
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public static enum GENERATOR_TYPE {
        SEQUENCE_LONG,
        SEQUENCE_INT,
        RANDOM,
        RANDOM_GUID;

    }
}

