/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.identifier;

import bsc.api.IIdentifiable;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.environment.EnvironmentRegistry;
import bsc.sdk.api.application.identifier.IIdentifier;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AIdentifier<T extends IIdentifiable>
implements IIdentifier<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final URI uri;
    protected final Class<T> objectClass;
    protected final String identifierScheme;
    protected final Environment environment;
    private static final String PATH_SEPERATOR = "/";

    public AIdentifier(URI uri) throws URISyntaxException {
        this.uri = Objects.requireNonNull(uri, "uri must not be null!");
        this.environment = EnvironmentRegistry.getEnvironment(uri.getUserInfo());
        if (this.environment == null) {
            throw new URISyntaxException(uri.toString(), "Invalid URI, could not get enviroment for authority!");
        }
        this.objectClass = this.getObjectClass();
        this.identifierScheme = this.objectClass.getSimpleName();
        if (!uri.getScheme().equals(this.getScheme())) {
            throw new URISyntaxException(uri.toString(), "Scheme did not match!");
        }
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getFullQualifiedIdentifiableString() {
        try {
            return URLDecoder.decode(this.uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.getFullQualifiedIdentifiableString();
    }

    private Class<T> getObjectClass() {
        ParameterizedType type = this.searchForSuperParameterizedType(this.getClass());
        Type arg = type.getActualTypeArguments()[0];
        return (Class)arg;
    }

    private ParameterizedType searchForSuperParameterizedType(Class<?> clazz) {
        Type genericSuperclass = clazz.getGenericSuperclass();
        while (!(genericSuperclass instanceof ParameterizedType) || ((ParameterizedType)genericSuperclass).getRawType() != AIdentifier.class) {
            if (genericSuperclass instanceof ParameterizedType) {
                genericSuperclass = ((Class)((ParameterizedType)genericSuperclass).getRawType()).getGenericSuperclass();
                continue;
            }
            genericSuperclass = ((Class)genericSuperclass).getGenericSuperclass();
        }
        return (ParameterizedType)genericSuperclass;
    }

    protected String[] getPathParts() {
        return AIdentifier.getPathParts(this.uri);
    }

    protected String getPathPart(int part) {
        return AIdentifier.getPathPart(part, this.uri);
    }

    public static String getPathPart(int part, URI uri) {
        String[] parts = AIdentifier.getPathParts(uri);
        if (parts.length >= part + 1) {
            return parts[part];
        }
        return null;
    }

    public static String[] getPathParts(URI uri) {
        String path = uri.getPath();
        if (path.startsWith(PATH_SEPERATOR)) {
            path = path.replaceFirst(PATH_SEPERATOR, "");
        }
        String[] result = path.split(PATH_SEPERATOR);
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = URLDecoder.decode(result[i], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String getScheme() {
        return this.identifierScheme;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean objectExists() {
        return this.getObjectInstance() != null;
    }

    public int hashCode() {
        if (this.uri != null) {
            return this.uri.toString().hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        boolean equal = obj instanceof AIdentifier;
        if (equal) {
            AIdentifier identifier = (AIdentifier)obj;
            equal &= this.uri != null ? this.uri.toString().equals(identifier.uri.toString()) : identifier.uri == null;
        }
        return equal;
    }
}

