/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.transport.result;

import bsc.api.Enumerations;
import bsc.api.transport.result.FailResult;

public class ExceptionResult
extends FailResult {
    private static boolean hideExceptionDetails = true;
    private static final long serialVersionUID = -7798037090244974842L;
    private StackTraceElement[] stackTrace = null;

    protected ExceptionResult() {
        super(Enumerations.ErrorType.EXCEPTION);
        this.errorMessage = "An internal server error occurs. Please contact you system administrator for detailed analyse.";
    }

    public ExceptionResult(Throwable throwable) {
        super(Enumerations.ErrorType.EXCEPTION);
        if (!hideExceptionDetails) {
            this.errorMessage = throwable.getMessage();
            this.stackTrace = throwable.getStackTrace();
        } else {
            this.errorMessage = "An internal server error occurs. Please contact you system administrator for detailed analyse.";
        }
        throwable.printStackTrace();
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public static boolean isHideExceptionDetails() {
        return hideExceptionDetails;
    }

    public static void setHideExceptionDetails(boolean hideExceptionDetails) {
        ExceptionResult.hideExceptionDetails = hideExceptionDetails;
    }
}

