/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.tf.model;

import bsc.api.modules.tf.model.IModelTF;
import bsc.api.modules.tf.model.TapSignal;
import java.util.List;

public class TapSequence
implements IModelTF {
    private static final long serialVersionUID = 8729816602014133502L;
    protected String id;
    protected String name;
    protected List<TapSignal> signalSequence;
    protected int order = 0;

    public TapSequence() {
    }

    public TapSequence(String id, String name, List<TapSignal> signalSequence, int order) {
        this.id = id;
        this.name = name;
        this.signalSequence = signalSequence;
        this.order = order;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TapSignal> getSignalSequence() {
        return this.signalSequence;
    }

    public void setSignalSequence(List<TapSignal> signalSequence) {
        this.signalSequence = signalSequence;
    }

    public boolean isSameSequence(TapSequence sequence) {
        return sequence != null && this.isSameSequence(sequence.getSignalSequence());
    }

    public boolean isSameSequence(List<TapSignal> sequence) {
        return TapSequence.checkIfSequenceContainsSameSignals(this.signalSequence, sequence, true);
    }

    public boolean isPossibleSameSequence(TapSequence sequence) {
        return sequence != null && this.isPossibleSameSequence(sequence.getSignalSequence());
    }

    public boolean isPossibleSameSequence(List<TapSignal> sequence) {
        return TapSequence.checkIfSequenceContainsSameSignals(sequence, this.signalSequence, false);
    }

    public static boolean checkIfSequenceContainsSameSignals(List<TapSignal> masterSequence, List<TapSignal> sequenceToCheck, boolean validateSize) {
        if (!(sequenceToCheck == null || masterSequence == null || validateSize && sequenceToCheck.size() != masterSequence.size())) {
            for (TapSignal extSignal : sequenceToCheck) {
                TapSignal ownSignal = masterSequence.get(extSignal.index);
                if (ownSignal.isSameSignal(extSignal)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

