/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.teachin.referenceid;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum BSC implements IReferenceID
{
    THERMOSTAT("enocean.bsc.thermostat", null, Arrays.asList("default"), null, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature),
    DIMMER_RELATIVE("enocean.bsc.dimmer-relative", null, Arrays.asList("default"), null, Enumerations.SensorName.Dimmer),
    DIMMER_ABSOLUTE("enocean.bsc.dimmer-absolute", null, Arrays.asList("default"), null, Enumerations.SensorName.Dimmer),
    DIRECTION_TOGGLE_LEFT("enocean.bsc.toggle-left", null, Arrays.asList("default"), null, Enumerations.SensorName.On),
    DIRECTION_TOGGLE_RIGHT("enocean.bsc.toggle-right", null, Arrays.asList("default"), null, Enumerations.SensorName.On),
    COMFORT_MULTIFUNCTION_HEATING_V_0_1("enocean.bsc.comfort-multifunction-heating-v-0-1", null, Arrays.asList("default"), null),
    COMFORT_MULTIFUNCTION_DIMMMING_V_0_1("enocean.bsc.comfort-multifunction-dimming-v-0-1", null, Arrays.asList("default"), null),
    COMFORT_MULTIFUNCTION_SHADING_V_0_1("enocean.bsc.comfort-multifunction-shading-v-0-1", null, Arrays.asList("default"), null),
    AMR_WATER("enocean.bsc.amr-water", null, Arrays.asList("default"), null, Enumerations.SensorName.Consumption, Enumerations.SensorName.LowChargeCounter, Enumerations.SensorName.HighChargeCounter, Enumerations.SensorName.Relay),
    AMR_GENERIC("enocean.bsc.amr-generic", null, Arrays.asList("default"), null, Enumerations.SensorName.Consumption, Enumerations.SensorName.LowChargeCounter, Enumerations.SensorName.HighChargeCounter, Enumerations.SensorName.Relay),
    AMR_THERMAL("enocean.bsc.amr-thermal", null, Arrays.asList("default"), null, Enumerations.SensorName.Consumption, Enumerations.SensorName.LowChargeCounter, Enumerations.SensorName.HighChargeCounter, Enumerations.SensorName.Relay),
    AMR_GAS("enocean.bsc.amr-gas", null, Arrays.asList("default"), null, Enumerations.SensorName.Consumption, Enumerations.SensorName.LowChargeCounter, Enumerations.SensorName.HighChargeCounter, Enumerations.SensorName.Relay),
    AMR_ELECTRICITY("enocean.bsc.amr-electricity", null, Arrays.asList("default"), null, Enumerations.SensorName.Consumption, Enumerations.SensorName.LowChargeCounter, Enumerations.SensorName.HighChargeCounter, Enumerations.SensorName.Relay),
    AMR_COLLECTION("enocean.bsc.amr-collection", null, Arrays.asList("default"), null, Enumerations.SensorName.Consumption, Enumerations.SensorName.LowChargeCounter, Enumerations.SensorName.HighChargeCounter, Enumerations.SensorName.Relay),
    SYNOLOGY_CAMERA("enocean.bsc.synology-camera", null, Arrays.asList("default"), null, Enumerations.SensorName.Recording, Enumerations.SensorName.Detection),
    BURG_LOCK("enocean.bsc.burg-lock", null, Arrays.asList("default"), null, Enumerations.SensorName.Open, Enumerations.SensorName.Enabled, Enumerations.SensorName.Battery),
    USB_FUS_S2("enocean.bsc.usb-fus-s2", null, Arrays.asList("default"), null, Enumerations.SensorName.Detection),
    WEATHER_STATION_ELSNER("enocean.bsc.weather-station-elsner", null, Arrays.asList("default"), null, Enumerations.SensorName.Temperature, Enumerations.SensorName.Brightness, Enumerations.SensorName.WindSpeed, Enumerations.SensorName.RainDetection, Enumerations.SensorName.DayNight, Enumerations.SensorName.SunIntensity, Enumerations.SensorName.DateTime, Enumerations.SensorName.GeoDirection, Enumerations.SensorName.GeoPosition),
    iRoom_Dock("ip.iroom.dock", null, null, null, Enumerations.SensorName.Detection1),
    VirtualTrigger("bsc.virtual.trigger", null, null, null, Enumerations.SensorName.Trigger, Enumerations.SensorName.On),
    VirtualMonitoring("bsc.virtual.monitoring", null, null, VirtualTrigger, Enumerations.SensorName.Trigger, Enumerations.SensorName.On),
    ON_OFF_ROCKER_A("enocean.bsc.on-off_rocker_a", null, Arrays.asList("default"), null, Enumerations.SensorName.On),
    ON_OFF_ROCKER_B("enocean.bsc.on-off_rocker_b", null, Arrays.asList("default"), null, Enumerations.SensorName.On),
    ON_OFF_BELL_ROCKER_A("enocean.bsc.on-off_bell_rocker_a", null, Arrays.asList("default"), null, Enumerations.SensorName.On),
    ON_OFF_BELL_ROCKER_B("enocean.bsc.on-off_bell_rocker_b", null, Arrays.asList("default"), null, Enumerations.SensorName.On);

    private final String id;
    private final ArrayList<ReferenceIDs.SensorEntry> sensorIndex = new ArrayList();
    private final List<String> teachInNames;
    private final List<String> acknowledgeNames;
    private final IReferenceID superType;
    private final Set<IReferenceID> subTypes = new HashSet<IReferenceID>();

    private BSC(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType, Enumerations.SensorName ... sensorNames) {
        this(id, teachInNames, acknowledgeNames, superType);
        if (sensorNames != null) {
            for (Enumerations.SensorName sensorName : sensorNames) {
                this.sensorIndex.add(new ReferenceIDs.SensorEntry(sensorName));
            }
        }
    }

    private BSC(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType) {
        this.id = id;
        this.superType = superType;
        if (this.superType != null) {
            this.superType.registerSubType(this);
        }
        this.teachInNames = teachInNames;
        this.acknowledgeNames = acknowledgeNames;
    }

    public String toString() {
        return this.id;
    }

    public static BSC getByReferenceId(String referenceId) {
        for (BSC value : BSC.values()) {
            if (!value.getReferenceId().equalsIgnoreCase(referenceId)) continue;
            return value;
        }
        return null;
    }

    @Override
    public void registerSubType(IReferenceID subType) {
        if (subType != null) {
            this.subTypes.add(subType);
        }
    }

    @Override
    public Set<IReferenceID> getSubTypes() {
        return Collections.unmodifiableSet(this.subTypes);
    }

    @Override
    public ISensor getMainSensor(ADevice device) {
        return device.getSensorByName(this.getSensorName(0));
    }

    @Override
    public String getSensorName(int index) {
        if (index >= this.sensorIndex.size()) {
            return null;
        }
        ReferenceIDs.SensorEntry entry = this.sensorIndex.get(index);
        return entry == null ? null : entry.getName();
    }

    @Override
    public ArrayList<ReferenceIDs.SensorEntry> getSensorIndex() {
        ArrayList<ReferenceIDs.SensorEntry> result = new ArrayList<ReferenceIDs.SensorEntry>();
        result.addAll(this.sensorIndex);
        return result;
    }

    @Override
    public String getReferenceId() {
        return this.id;
    }

    @Override
    public List<String> getTeachInNames() {
        List<String> result = null;
        if (this.teachInNames != null) {
            result = Collections.unmodifiableList(this.teachInNames);
        }
        return result;
    }

    @Override
    public List<String> getAcknowledgeNames() {
        List<String> result = null;
        if (this.acknowledgeNames != null) {
            result = Collections.unmodifiableList(this.acknowledgeNames);
        }
        return result;
    }

    @Override
    public IReferenceID getSuperType() {
        return this.superType;
    }
}

