/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.teachin.referenceid;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum AFRISO implements IReferenceID
{
    ASD("enocean.afriso.asd", null, Arrays.asList("default"), null, Enumerations.SensorName.Detection, Enumerations.SensorName.Temperature),
    ASD10("enocean.afriso.asd10", null, Arrays.asList("default"), null, Enumerations.SensorName.Detection1, Enumerations.SensorName.Temperature),
    FTM_UNIVERSAL("enocean.afriso.ftm-universal", null, Arrays.asList("default"), null, Enumerations.SensorName.Detection, Enumerations.SensorName.Temperature),
    FTM_T("enocean.afriso.ftm-t", null, Arrays.asList("default"), null, Enumerations.SensorName.Temperature),
    FTM_TF("enocean.afriso.ftm-ft", null, Arrays.asList("default"), null, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity),
    FT("enocean.afriso.ft", null, Arrays.asList("default"), null, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature),
    FTF("enocean.afriso.ftf", null, Arrays.asList("default"), null, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity),
    RFT("enocean.afriso.rft", null, Arrays.asList("default"), null, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature),
    RFTF("enocean.afriso.rftf", null, Arrays.asList("default"), null, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity),
    WATERCONTROL("enocean.afriso.watercontrol", Arrays.asList("default"), Arrays.asList("default"), null, Enumerations.SensorName.Open),
    WATERCONTROL_SENSOR("enocean.afriso.watercontrol_sensor", Arrays.asList("default"), Arrays.asList("default"), null, Enumerations.SensorName.Open),
    WATERSENSOR("enocean.afriso.watersensor", null, Arrays.asList("default"), null, Enumerations.SensorName.Detection1),
    WATERSENSOR_ECO("enocean.afriso.watersensor.eco", null, Arrays.asList("default"), null, Enumerations.SensorName.Detection1),
    WATERSENSOR_ECO_US("enocean.afriso.watersensor.eco.us", null, Arrays.asList("default"), null, Enumerations.SensorName.Detection1);

    private final String id;
    private final ArrayList<ReferenceIDs.SensorEntry> sensorIndex = new ArrayList();
    private final List<String> teachInNames;
    private final List<String> acknowledgeNames;
    private final IReferenceID superType;
    private final Set<IReferenceID> subTypes = new HashSet<IReferenceID>();

    private AFRISO(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType, Enumerations.SensorName ... sensorNames) {
        this(id, teachInNames, acknowledgeNames, superType);
        if (sensorNames != null) {
            for (Enumerations.SensorName sensorName : sensorNames) {
                this.sensorIndex.add(new ReferenceIDs.SensorEntry(sensorName));
            }
        }
    }

    private AFRISO(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType) {
        this.id = id;
        this.superType = superType;
        if (this.superType != null) {
            this.superType.registerSubType(this);
        }
        this.teachInNames = teachInNames;
        this.acknowledgeNames = acknowledgeNames;
    }

    public String toString() {
        return this.id;
    }

    public static AFRISO getByReferenceId(String referenceId) {
        for (AFRISO value : AFRISO.values()) {
            if (!value.getReferenceId().equalsIgnoreCase(referenceId)) continue;
            return value;
        }
        return null;
    }

    @Override
    public void registerSubType(IReferenceID subType) {
        if (subType != null) {
            this.subTypes.add(subType);
        }
    }

    @Override
    public Set<IReferenceID> getSubTypes() {
        return Collections.unmodifiableSet(this.subTypes);
    }

    @Override
    public ISensor getMainSensor(ADevice device) {
        return device.getSensorByName(this.getSensorName(0));
    }

    @Override
    public String getSensorName(int index) {
        if (index >= this.sensorIndex.size()) {
            return null;
        }
        ReferenceIDs.SensorEntry entry = this.sensorIndex.get(index);
        return entry == null ? null : entry.getName();
    }

    @Override
    public ArrayList<ReferenceIDs.SensorEntry> getSensorIndex() {
        ArrayList<ReferenceIDs.SensorEntry> result = new ArrayList<ReferenceIDs.SensorEntry>();
        result.addAll(this.sensorIndex);
        return result;
    }

    @Override
    public String getReferenceId() {
        return this.id;
    }

    @Override
    public List<String> getTeachInNames() {
        List<String> result = null;
        if (this.teachInNames != null) {
            result = Collections.unmodifiableList(this.teachInNames);
        }
        return result;
    }

    @Override
    public List<String> getAcknowledgeNames() {
        List<String> result = null;
        if (this.acknowledgeNames != null) {
            result = Collections.unmodifiableList(this.acknowledgeNames);
        }
        return result;
    }

    @Override
    public IReferenceID getSuperType() {
        return this.superType;
    }
}

