/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.core.model.sensor.state.on;

import bsc.api.IUpdateableObject;
import bsc.api.modules.core.model.sensor.state.OnSensor;
import java.text.MessageFormat;

public class SwitchOn
extends OnSensor {
    private static final long serialVersionUID = 441179272236390530L;
    private SwitchType switchType = SwitchType.LIGHT;

    public SwitchOn(String deviceID) {
        super(deviceID);
    }

    public SwitchOn(SwitchOn switchOn) {
        super(switchOn);
    }

    public SwitchType getSwitchType() {
        return this.switchType;
    }

    public void setSwitchType(SwitchType switchType) {
        this.switchType = switchType;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        boolean equal = objectInstance instanceof SwitchOn;
        if (equal) {
            SwitchOn sensor = (SwitchOn)objectInstance;
            boolean bl = sensor.switchType == null ? this.switchType == null : sensor.switchType.equals((Object)this.switchType);
            if (equal &= bl) {
                equal &= super.dataEquals(objectInstance);
            }
        }
        return equal;
    }

    @Override
    public boolean updateObject(IUpdateableObject objectInstance) {
        if (objectInstance instanceof SwitchOn) {
            SwitchOn sensor = (SwitchOn)objectInstance;
            this.switchType = sensor.switchType;
            return super.updateObject(objectInstance);
        }
        return false;
    }

    @Override
    public String toString() {
        return MessageFormat.format("{0}, switchType = {1}", new Object[]{super.toString(), this.switchType});
    }

    @Override
    public void setDefaultState() {
        this.setState(OnSensor.State.UNKNOWN);
        this.setSwitchType(SwitchType.LIGHT);
    }

    public static enum SwitchType {
        SOCKET,
        ACTOR,
        ROOM,
        PRINTER,
        TV,
        RADIO,
        BINARY,
        BELL,
        LIGHT,
        TIMER;

    }
}

