/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.camera.commands.offer;

import bsc.api.Enumerations;
import bsc.api.IUpdateableObject;
import bsc.api.modules.camera.commands.StartStreamCommand;
import bsc.api.modules.camera.commands.offer.ACameraOffer;
import java.util.ArrayList;
import java.util.List;

public class StartStreamOffer
extends ACameraOffer<StartStreamCommand> {
    private static final long serialVersionUID = 2966538824428696749L;
    private boolean videoSupported = false;
    private List<Enumerations.VideoEncoding> videoEncodings;
    private boolean audioSupported = false;
    private List<Enumerations.AudioEncoding> audioEncodings;

    public boolean isVideoSupported() {
        return this.videoSupported;
    }

    public void setVideoSupported(boolean videoSupported) {
        this.videoSupported = videoSupported;
    }

    public List<Enumerations.VideoEncoding> getVideoEncodings() {
        if (this.videoEncodings == null) {
            this.videoEncodings = new ArrayList<Enumerations.VideoEncoding>();
        }
        return this.videoEncodings;
    }

    public void setVideoEncodings(List<Enumerations.VideoEncoding> videoEncodings) {
        this.videoEncodings = videoEncodings;
    }

    public boolean isAudioSupported() {
        return this.audioSupported;
    }

    public void setAudioSupported(boolean audioSupported) {
        this.audioSupported = audioSupported;
    }

    public List<Enumerations.AudioEncoding> getAudioEncodings() {
        if (this.audioEncodings == null) {
            this.audioEncodings = new ArrayList<Enumerations.AudioEncoding>();
        }
        return this.audioEncodings;
    }

    public void setAudioEncodings(List<Enumerations.AudioEncoding> audioEncodings) {
        this.audioEncodings = audioEncodings;
    }

    @Override
    public boolean updateObject(IUpdateableObject objectInstance) {
        if (objectInstance instanceof StartStreamOffer) {
            StartStreamOffer offer = (StartStreamOffer)objectInstance;
            this.videoSupported = offer.videoSupported;
            this.getVideoEncodings().clear();
            this.getVideoEncodings().addAll(offer.getVideoEncodings());
            this.audioSupported = offer.audioSupported;
            this.getAudioEncodings().clear();
            this.getAudioEncodings().addAll(offer.getAudioEncodings());
            return super.updateObject(objectInstance);
        }
        return false;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        boolean equal = super.dataEquals(objectInstance);
        if (equal) {
            StartStreamOffer offer = (StartStreamOffer)objectInstance;
            equal &= this.videoSupported == offer.videoSupported;
            equal &= this.audioSupported == offer.audioSupported;
            equal &= this.getVideoEncodings().size() == offer.getVideoEncodings().size();
            if (equal &= this.getAudioEncodings().size() == offer.getAudioEncodings().size()) {
                equal &= this.getVideoEncodings().containsAll(offer.getVideoEncodings());
            }
            if (equal) {
                equal &= this.getAudioEncodings().containsAll(offer.getAudioEncodings());
            }
        }
        return equal;
    }
}

