/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.basic.model;

import bsc.api.ApiObjectIdentifier;
import bsc.api.IUpdateableObject;
import bsc.api.basic.AMetaInformation;
import bsc.api.basic.commands.offer.AOffer;
import bsc.api.basic.model.IExtendedEquals;
import bsc.api.basic.model.ISensor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ASensor
extends AMetaInformation
implements ISensor,
IExtendedEquals {
    private static final long serialVersionUID = -6339978483683328725L;
    private String deviceID;
    private String sensorID;
    private String name;
    private List<AOffer<?>> commandOffers;

    protected ASensor() {
    }

    public ASensor(ASensor sensor) {
        this.updateObject(sensor);
    }

    public ASensor(String deviceID) {
        this.deviceID = deviceID;
    }

    @Override
    public String getDeviceID() {
        if (this.deviceID == null) {
            this.deviceID = "";
        }
        return this.deviceID;
    }

    @Override
    public String getSensorID() {
        if (this.sensorID == null) {
            this.sensorID = "";
        }
        return this.sensorID;
    }

    @Override
    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    @Override
    public void setSensorID(String sensorID) {
        this.sensorID = sensorID;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<AOffer<?>> getCommandOffers() {
        if (this.commandOffers == null) {
            this.commandOffers = new ArrayList();
        }
        return this.commandOffers;
    }

    @Override
    public void addCommandOffer(AOffer<?> commandOffer) {
        this.getCommandOffers().add(commandOffer);
    }

    @Override
    public void setCommandOffers(List<AOffer<?>> commandOffers) {
        this.commandOffers = commandOffers;
    }

    public String toString() {
        return "ASensor [deviceID=" + this.deviceID + ", sensorID=" + this.sensorID + ", name=" + this.name + ", commandOffers=" + this.commandOffers + ", toString()=" + super.toString() + "]";
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return ApiObjectIdentifier.getSensorURI(this.deviceID, this.sensorID, applicationID, host);
    }

    public void clearCommandOffers() {
        if (this.commandOffers != null) {
            this.commandOffers.clear();
        } else {
            this.commandOffers = new ArrayList();
        }
    }

    @Override
    public synchronized boolean updateObject(IUpdateableObject objectInstance) {
        if (objectInstance != null) {
            ASensor sensor = (ASensor)objectInstance;
            this.deviceID = sensor.deviceID;
            this.sensorID = sensor.sensorID;
            this.name = sensor.name;
            this.commandOffers = sensor.commandOffers;
            this.metaInformation = sensor.getAllMetaInformations();
            return true;
        }
        return false;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        boolean equal = objectInstance instanceof ASensor;
        if (equal && (equal &= super.dataEquals(objectInstance))) {
            ASensor sensor = (ASensor)objectInstance;
            equal &= sensor.deviceID == null ? this.deviceID == null : sensor.deviceID.equals(this.deviceID);
            equal &= sensor.sensorID == null ? this.sensorID == null : sensor.sensorID.equals(this.sensorID);
            equal &= sensor.name == null ? this.name == null : sensor.name.equals(this.name);
        }
        return equal;
    }

    @Override
    public boolean dataEqual(IUpdateableObject objectInstance, boolean ignoreCommandOffers) {
        return this.dataEqual(objectInstance, ignoreCommandOffers, false);
    }

    public boolean dataEqual(IUpdateableObject objectInstance, boolean ignoreCommandOffers, boolean ignoreSuperTypeCheck) {
        boolean equal = objectInstance instanceof ASensor;
        if (equal) {
            if (!ignoreSuperTypeCheck) {
                equal &= super.dataEquals(objectInstance);
            }
            if (equal) {
                ASensor sensor = (ASensor)objectInstance;
                equal &= sensor.deviceID == null ? this.deviceID == null : sensor.deviceID.equals(this.deviceID);
                equal &= sensor.sensorID == null ? this.sensorID == null : sensor.sensorID.equals(this.sensorID);
                equal &= sensor.name == null ? this.name == null : sensor.name.equals(this.name);
                if ((equal &= sensor.getCommandOffers().size() == this.getCommandOffers().size()) && !ignoreCommandOffers) {
                    ArrayList extOffers = new ArrayList(sensor.getCommandOffers());
                    Collections.sort(extOffers);
                    ArrayList myOffers = new ArrayList(this.getCommandOffers());
                    Collections.sort(myOffers);
                    for (AOffer aOffer : myOffers) {
                        Iterator extItr = extOffers.iterator();
                        boolean offerMatch = false;
                        while (extItr.hasNext()) {
                            AOffer extO = (AOffer)extItr.next();
                            offerMatch = aOffer.dataEquals(extO);
                            if (!offerMatch) continue;
                            extItr.remove();
                            break;
                        }
                        if (equal &= offerMatch) continue;
                        break;
                    }
                }
            }
        }
        return equal;
    }

    public int hashCode() {
        String id = this.getDeviceID() + this.getSensorID();
        return id.hashCode();
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    @Override
    public boolean equals(Object obj, boolean checkOnlyID) {
        if (checkOnlyID) {
            boolean equal = obj instanceof ISensor;
            if (equal) {
                ISensor sensor = (ISensor)obj;
                String id = this.getDeviceID() + this.getSensorID();
                String idExt = sensor.getDeviceID() + sensor.getSensorID();
                equal = id.equals(idExt);
            }
            return equal;
        }
        return super.equals(obj);
    }
}

