/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.basic.model;

import bsc.api.ApiObjectIdentifier;
import bsc.api.Enumerations;
import bsc.api.IIdentifiableApiObject;
import bsc.api.IUpdateableObject;
import bsc.api.basic.AMetaInformation;
import bsc.api.basic.commands.offer.AOffer;
import bsc.api.basic.model.IExtendedEquals;
import bsc.api.basic.model.ISensor;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ADevice
extends AMetaInformation
implements IIdentifiableApiObject,
IExtendedEquals {
    private static final long serialVersionUID = 4802721764163661832L;
    protected String deviceID;
    protected DeviceState state;
    protected List<ISensor> sensors;
    @Deprecated
    protected Enumerations.DeviceType deviceType = Enumerations.DeviceType.UNKNOWN;
    protected List<Integer> grpIDs;
    protected List<AOffer<?>> commandOffers;
    protected String name;
    @Deprecated
    protected boolean actuator;

    public ADevice() {
        this(Enumerations.DeviceType.UNKNOWN);
    }

    public ADevice(Enumerations.DeviceType deviceType) {
        if (deviceType != null) {
            this.deviceType = deviceType;
        }
    }

    public ADevice(ADevice device) {
        this.updateObject(device);
    }

    public String getDeviceID() {
        if (this.deviceID == null) {
            this.deviceID = "";
        }
        return this.deviceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceID(String objectID) {
        if (objectID != null) {
            this.deviceID = objectID;
            if (this.sensors != null) {
                List<ISensor> sensList;
                List<ISensor> list = sensList = this.getSensors();
                synchronized (list) {
                    for (ISensor sensor : sensList) {
                        sensor.setDeviceID(this.deviceID);
                    }
                }
            }
        }
    }

    public DeviceState getState() {
        return this.state;
    }

    public void setState(DeviceState state) {
        this.state = state;
    }

    public List<Integer> getGrpIDs() {
        if (this.grpIDs == null) {
            this.grpIDs = new ArrayList<Integer>();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(this.grpIDs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGrpIDs(List<Integer> grpIDs) {
        List<Integer> list;
        if (this.grpIDs != null) {
            list = this.grpIDs;
            synchronized (list) {
                this.grpIDs.clear();
            }
        } else {
            this.grpIDs = new ArrayList<Integer>();
        }
        if (grpIDs != null) {
            list = this.grpIDs;
            synchronized (list) {
                this.grpIDs.addAll(grpIDs);
            }
        }
    }

    public List<ISensor> getSensors() {
        if (this.sensors == null) {
            this.sensors = new ArrayList<ISensor>();
        }
        return this.sensors;
    }

    public void clearCommandOffers() {
        if (this.commandOffers != null) {
            this.commandOffers.clear();
        }
    }

    public ISensor getSensorByName(Enumerations.SensorName name) {
        if (name == null) {
            return null;
        }
        return this.getSensorByName(name.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISensor getSensorByName(String name) {
        List<ISensor> sensList;
        List<ISensor> list = sensList = this.getSensors();
        synchronized (list) {
            for (ISensor sensor : sensList) {
                if (!sensor.getName().equals(name)) continue;
                return sensor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISensor getSensorByID(String sensorID) {
        List<ISensor> sensList;
        List<ISensor> list = sensList = this.getSensors();
        synchronized (list) {
            for (ISensor sensor : sensList) {
                if (!sensor.getSensorID().equals(sensorID)) continue;
                return sensor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSensor(ISensor sensor) {
        if (sensor != null) {
            List<ISensor> sensList;
            List<ISensor> list = sensList = this.getSensors();
            synchronized (list) {
                sensList.add(sensor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSensor(ISensor sensor) {
        if (sensor != null) {
            List<ISensor> sensList;
            List<ISensor> list = sensList = this.getSensors();
            synchronized (list) {
                sensList.remove(sensor);
            }
        }
    }

    public Enumerations.DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(Enumerations.DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public boolean isActuator() {
        return this.actuator;
    }

    public void setActuator(boolean actuator) {
        this.actuator = actuator;
    }

    public List<AOffer<?>> getCommandOffers() {
        if (this.commandOffers == null) {
            this.commandOffers = new ArrayList();
        }
        return this.commandOffers;
    }

    public void addCommandOffer(AOffer<?> commandOffer) {
        this.getCommandOffers().add(commandOffer);
    }

    public void setCommandOffers(List<AOffer<?>> commandOffers) {
        if (commandOffers != null) {
            this.getCommandOffers().clear();
            this.getCommandOffers().addAll(commandOffers);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        String className = this.getClass().getSimpleName();
        return MessageFormat.format("{0}: deviceType = {1}, deviceID = {2}, grpID = {3}, state = {4}", new Object[]{className, this.deviceType, this.deviceID, this.getGrpIDs(), this.state});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromGroup(int groupID) {
        if (groupID < 0) {
            return;
        }
        if (this.getGrpIDs().contains(groupID)) {
            List<Integer> list = this.grpIDs;
            synchronized (list) {
                this.grpIDs.remove((Object)groupID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGroup(int groupID) {
        if (groupID < 0) {
            return;
        }
        if (!this.getGrpIDs().contains(groupID)) {
            List<Integer> list = this.grpIDs;
            synchronized (list) {
                this.grpIDs.add(groupID);
            }
        }
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return ApiObjectIdentifier.getDeviceURI(this.deviceID, applicationID, host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updateObject(IUpdateableObject objectInstance) {
        boolean result = super.updateObject(objectInstance);
        if (result && objectInstance instanceof ADevice) {
            List<ISensor> sensList;
            ADevice device = (ADevice)objectInstance;
            this.deviceType = device.deviceType;
            this.deviceID = device.deviceID;
            this.state = device.state;
            this.name = device.name;
            this.actuator = device.actuator;
            this.setCommandOffers(device.getCommandOffers());
            List<ISensor> list = sensList = this.getSensors();
            synchronized (list) {
                sensList.clear();
                sensList.addAll(device.getSensors());
            }
            this.setGrpIDs(device.getGrpIDs());
            result = true;
        }
        return result;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        return this.dataEqual(objectInstance, false, false);
    }

    public boolean dataEqual(IUpdateableObject objectInstance, boolean ignoreSensors, boolean ignoreCommandOffers) {
        return this.dataEqual(objectInstance, ignoreSensors, ignoreCommandOffers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dataEqual(IUpdateableObject objectInstance, boolean ignoreSensors, boolean ignoreCommandOffers, boolean ignoreSuperTypeCheck) {
        boolean equal = objectInstance instanceof ADevice;
        if (equal) {
            if (!ignoreSuperTypeCheck) {
                equal &= super.dataEquals(objectInstance);
            }
            if (equal) {
                List<ISensor> sensList;
                ADevice device = (ADevice)objectInstance;
                equal &= device.actuator == this.actuator;
                equal &= device.deviceID == null ? this.deviceID == null : device.deviceID.equals(this.deviceID);
                equal &= device.name == null ? this.name == null : device.name.equals(this.name);
                equal &= device.state == this.state;
                equal &= device.deviceType.equals((Object)this.deviceType);
                List<Integer> ownGroupIDs = this.getGrpIDs();
                List<Integer> extGroupIDs = device.getGrpIDs();
                if (equal &= ownGroupIDs.size() == extGroupIDs.size()) {
                    Collections.sort(ownGroupIDs);
                    Collections.sort(extGroupIDs);
                    equal &= ownGroupIDs.equals(extGroupIDs);
                }
                List<ISensor> list = sensList = this.getSensors();
                synchronized (list) {
                    if (equal &= sensList.size() == device.getSensors().size()) {
                        for (ISensor sensor : sensList) {
                            ISensor iSensor = device.getSensorByName(sensor.getName());
                            if ((equal &= iSensor != null) && !ignoreSensors) {
                                equal &= sensor.dataEquals(iSensor);
                            }
                            if (equal) continue;
                            break;
                        }
                    }
                }
                if (equal && !ignoreCommandOffers) {
                    ArrayList extOffers = new ArrayList(device.getCommandOffers());
                    Collections.sort(extOffers);
                    ArrayList myOffers = new ArrayList(this.getCommandOffers());
                    Collections.sort(myOffers);
                    for (AOffer aOffer : myOffers) {
                        Iterator extItr = extOffers.iterator();
                        boolean offerMatch = false;
                        while (extItr.hasNext()) {
                            AOffer extO = (AOffer)extItr.next();
                            offerMatch = aOffer.dataEquals(extO);
                            if (!offerMatch) continue;
                            extItr.remove();
                            break;
                        }
                        if (equal &= offerMatch) continue;
                        break;
                    }
                }
            }
        }
        return equal;
    }

    public int hashCode() {
        return this.getDeviceID().hashCode();
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    @Override
    public boolean equals(Object obj, boolean checkOnlyID) {
        if (checkOnlyID) {
            boolean equal = obj instanceof ADevice;
            if (equal) {
                ADevice device = (ADevice)obj;
                equal = this.getDeviceID().equals(device.getDeviceID());
            }
            return equal;
        }
        return super.equals(obj);
    }

    public static enum DeviceState {
        SAFE,
        UNSAFE,
        PENDING,
        UNKNOWN;

    }
}

