/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.basic.container;

import bsc.api.basic.container.AContainer;
import bsc.api.basic.container.TYPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AGenericObjectContainer<T>
extends AContainer {
    private static final long serialVersionUID = -8501397766343570448L;
    protected List<T> objects;

    public AGenericObjectContainer() {
        this(TYPE.FULL, new ArrayList());
    }

    public AGenericObjectContainer(Collection<T> objects) {
        this(TYPE.FULL, objects);
    }

    public AGenericObjectContainer(TYPE type) {
        this(type, new ArrayList());
    }

    public AGenericObjectContainer(TYPE type, Collection<T> objects) {
        this.setType(type);
        this.setObjects(objects);
    }

    public void addObject(T object) {
        this.getObjects().add(object);
    }

    public void deleteObject(T object) {
        this.getObjects().remove(object);
    }

    public List<T> getObjects() {
        if (this.objects == null) {
            this.objects = new ArrayList<T>();
        }
        return this.objects;
    }

    public void setObjects(Collection<T> objects) {
        this.getObjects().clear();
        this.getObjects().addAll(objects);
    }

    public String toString() {
        return "AGenericContainer [objects=" + this.objects + ", type=" + (Object)((Object)this.type) + ", sequenceId=" + this.sequenceId + ", sequenceLength=" + this.sequenceLength + ", sequenceCount=" + this.sequenceCount + "]";
    }
}

