/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.basic.commands.offer;

import bsc.api.IApiObject;
import bsc.api.IUpdateableObject;
import bsc.api.basic.commands.Command;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;

public abstract class AOffer<T extends Command>
implements IApiObject,
IUpdateableObject,
Comparable<AOffer<?>> {
    private static final long serialVersionUID = -1709682243807899837L;
    protected String commandName = this.getCommandClassName();

    public String getCommandName() {
        if (this.commandName == null) {
            this.commandName = "";
        }
        return this.commandName;
    }

    private String getCommandClassName() {
        Class<?> clazz = this.getClass();
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return ((Class)((ParameterizedType)type).getActualTypeArguments()[0]).getName();
        }
        return "Unknown";
    }

    public String toString() {
        String className = this.getClass().getSimpleName();
        return MessageFormat.format("{0}: commandName = {1}", className, this.commandName);
    }

    @Override
    public boolean updateObject(IUpdateableObject objectInstance) {
        return true;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        boolean equal = objectInstance instanceof AOffer;
        if (equal) {
            try {
                AOffer offer = (AOffer)objectInstance;
                equal &= this.commandName == null && offer.commandName == null || this.commandName != null && this.commandName.equals(offer.getCommandName());
            }
            catch (ClassCastException e) {
                equal &= false;
            }
        }
        return equal;
    }

    @Override
    public int compareTo(AOffer<?> o) {
        if (o == null) {
            return -1;
        }
        return this.getCommandName().compareTo(o.getCommandName());
    }

    public int hashCode() {
        return this.getCommandName().hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof AOffer;
        if (result) {
            AOffer offer = (AOffer)obj;
            result = this.getCommandName().equals(offer.getCommandName());
        }
        return result;
    }
}

