/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.basic;

import bsc.api.IApiObject;
import bsc.api.IMetaInformation;
import bsc.api.IUpdateableObject;
import java.util.HashMap;
import java.util.Map;

public abstract class AMetaInformation
implements IMetaInformation,
IApiObject,
IUpdateableObject {
    protected Map<String, String> metaInformation = new HashMap<String, String>();
    public static final String SEPERATOR = "->";

    @Override
    public String getMetaInformation(String rawKey) {
        if (rawKey == null) {
            return null;
        }
        return this.metaInformation.get(rawKey);
    }

    @Override
    public String getMetaInformation(String extensionID, String key) {
        return this.metaInformation.get(AMetaInformation.buildExtensionKey(extensionID, key));
    }

    @Override
    public void addMetaInformation(String rawKey, String value) {
        this.metaInformation.put(rawKey, value);
    }

    @Override
    public void addMetaInformation(String extensionId, String key, String value) {
        if (extensionId != null && key != null && value != null) {
            this.addMetaInformation(extensionId + SEPERATOR + key, value);
        }
    }

    @Override
    public Map<String, String> getAllMetaInformations() {
        return new HashMap<String, String>(this.metaInformation);
    }

    public static String buildExtensionKey(String extensionID, String key) {
        if (extensionID == null || key == null) {
            return null;
        }
        return extensionID + SEPERATOR + key;
    }

    @Override
    public void clearMetaInformations() {
        if (this.metaInformation != null) {
            this.metaInformation.clear();
        } else {
            this.metaInformation = new HashMap<String, String>();
        }
    }

    @Override
    public void removeMetaInformation(String key) {
        this.metaInformation.remove(key);
    }

    @Override
    public void addMetaInformation(String extensionId, Map<String, String> metaInformations) {
        if (extensionId != null && metaInformations != null) {
            for (Map.Entry<String, String> entry : metaInformations.entrySet()) {
                this.addMetaInformation(extensionId, entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public boolean updateObject(IUpdateableObject objectInstance) {
        if (objectInstance instanceof IMetaInformation) {
            IMetaInformation metaInformationObject = (IMetaInformation)((Object)objectInstance);
            Map<String, String> tmpMap = metaInformationObject.getAllMetaInformations();
            this.metaInformation.clear();
            this.metaInformation.putAll(tmpMap);
            return true;
        }
        return false;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        if (objectInstance != null && objectInstance instanceof IMetaInformation) {
            return AMetaInformation.isMetaInformationEqual(this, (IMetaInformation)((Object)objectInstance));
        }
        return false;
    }

    public static boolean isMetaInformationEqual(IMetaInformation object1, IMetaInformation object2) {
        boolean result;
        boolean bl = result = object1 != null && object2 != null;
        if (result) {
            Map<String, String> mi1 = object1.getAllMetaInformations();
            Map<String, String> mi2 = object2.getAllMetaInformations();
            boolean bl2 = result = mi1 != null && mi2 != null && mi1.size() == mi2.size();
            if (result) {
                for (Map.Entry<String, String> entry : mi1.entrySet()) {
                    boolean bl3 = result = entry.getKey() != null;
                    if (result) {
                        String myValue = mi2.get(entry.getKey());
                        boolean bl4 = result = myValue != null && myValue.equals(entry.getValue());
                    }
                    if (result) continue;
                    break;
                }
            }
        }
        return result;
    }

    public static Map<String, String> getMetaInformationDifference(IMetaInformation org, IMetaInformation toCompare) {
        HashMap<String, String> difference = new HashMap<String, String>();
        if (org != null && toCompare != null) {
            Map<String, String> mi1 = org.getAllMetaInformations();
            Map<String, String> mi2 = toCompare.getAllMetaInformations();
            if (mi1 != null && mi2 != null) {
                for (Map.Entry<String, String> entry : mi2.entrySet()) {
                    String toCompareValue;
                    if (entry.getKey() == null || (toCompareValue = mi1.get(entry.getKey())) != null && toCompareValue.equals(entry.getValue())) continue;
                    difference.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return difference;
    }
}

