/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.m2m.tunnelclient.services;

import de.m2mgate.comp.InternalSerializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class GenericObjectTransportContainer
implements InternalSerializable {
    private String serializationProtocol = null;
    private String objectClass = null;
    private int objectVersion = -1;
    private byte[] objectSerialization = null;

    public GenericObjectTransportContainer() {
    }

    public GenericObjectTransportContainer(Serializable object) {
        this.storeJavaObject(object);
    }

    public GenericObjectTransportContainer(Enum<?> serializationProtocol) {
        this(serializationProtocol.name());
    }

    public GenericObjectTransportContainer(String serializationProtocol) {
        this(serializationProtocol, null, null, -1);
    }

    public GenericObjectTransportContainer(String serializationProtocol, String objectClass, byte[] objectSerialization) {
        this(serializationProtocol, objectClass, objectSerialization, -1);
    }

    public GenericObjectTransportContainer(String serializationProtocol, String objectClass, byte[] objectSerialization, int objectVersion) {
        this.serializationProtocol = serializationProtocol;
        this.objectClass = objectClass;
        this.objectVersion = objectVersion;
        this.objectSerialization = objectSerialization;
    }

    protected void storeJavaObject(Serializable object) {
        if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                ObjectOutputStream so = new ObjectOutputStream(bo);
                so.writeObject(object);
                so.flush();
                this.objectClass = object.getClass().getName();
                this.objectSerialization = bo.toByteArray();
                this.setSerializationProtocol(SERIALIZATION_PROTOCOL.JAVA.name());
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    protected <T extends Serializable> T restoreJavaObject(Class<T> objectClass) {
        Serializable result = null;
        if (this.objectSerialization != null && objectClass != null && this.serializationProtocol.equals(SERIALIZATION_PROTOCOL.JAVA.name())) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.objectSerialization);
                ObjectInputStream ois = new ObjectInputStream(bis);
                result = (Serializable)ois.readObject();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return (T)result;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public int getObjectVersion() {
        return this.objectVersion;
    }

    public void setObjectVersion(int objectVersion) {
        this.objectVersion = objectVersion;
    }

    public String getSerializationProtocol() {
        return this.serializationProtocol;
    }

    public void setSerializationProtocol(String serializationProtocol) {
        if (serializationProtocol != null) {
            this.serializationProtocol = serializationProtocol;
        }
    }

    public byte[] getObjectSerialization() {
        return this.objectSerialization;
    }

    public void setObjectSerialization(byte[] objectSerialization) {
        this.objectSerialization = objectSerialization;
    }

    public void reconstruct(DataInput in) throws IOException {
        this.setSerializationProtocol(in.readUTF());
        this.setObjectClass(in.readUTF());
        this.setObjectVersion(in.readInt());
        byte[] serialized = new byte[in.readInt()];
        in.readFully(serialized);
        this.setObjectSerialization(serialized);
    }

    public void serialize(DataOutput out) throws IOException {
        if (this.getObjectClass() == null || this.getObjectSerialization() == null) {
            throw new NullPointerException("Object Class and Serialisation must be set.");
        }
        out.writeUTF(this.serializationProtocol);
        out.writeUTF(this.getObjectClass());
        out.writeInt(this.getObjectVersion());
        out.writeInt(this.getObjectSerialization().length);
        out.write(this.getObjectSerialization());
    }

    public static enum SERIALIZATION_PROTOCOL {
        JAVA,
        JSON_BSC;

    }
}

