/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.cc.vid;

import de.bscgmbh.sn.cc.vid.IVIDScheme;
import de.bscgmbh.sn.cc.vid.VIDSchemeFactory;
import java.util.Objects;

public class VID {
    public static final String SEPERATOR = "#";
    public static final char SEPERATOR_CHAR = "#".charAt(0);
    public static final String PREFIX_REGEX = ".{1}#.{1}#";
    private final IVIDScheme scheme;

    public VID(IVIDScheme scheme) {
        this.scheme = Objects.requireNonNull(scheme, "scheme must not be null!");
    }

    public VID(String vID) {
        this.scheme = VIDSchemeFactory.createVIDScheme(Objects.requireNonNull(vID, "vID must not be null!"));
        if (this.scheme == null) {
            throw new IllegalArgumentException("VID scheme could not be created!");
        }
    }

    public static int parseSchemeID(String vID) {
        String[] data;
        int result = -1;
        if (vID != null && (data = vID.split(SEPERATOR, 2)).length == 2) {
            try {
                result = Integer.parseInt(data[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public String toString() {
        return this.scheme.toString();
    }

    public IVIDScheme getScheme() {
        return this.scheme;
    }
}

