/*
 * Decompiled with CFR 0.152.
 */
package application.gui;

import database.CameraObject;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import response.syno.surveillancestation.camera.answer.Camera_List_Object;

public class CameraTable {
    private CameraObject cameraObject;
    private SimpleStringProperty kameraInfo;
    private SimpleBooleanProperty swAktiv;
    private SimpleBooleanProperty apiAktiv;
    private SimpleStringProperty ipAdresse;
    private SimpleStringProperty pointMotionDetection;
    private SimpleStringProperty mal;
    private SimpleStringProperty intervallInSekunden;

    public CameraTable(CameraObject cameraObject) {
        this.cameraObject = cameraObject;
        if (cameraObject.getKameraid_software() != Long.MIN_VALUE) {
            System.out.println("sezte bei if " + cameraObject.getKameraid_software());
            this.kameraInfo = new SimpleStringProperty("Info bei " + cameraObject.getKameraid_software());
            this.swAktiv = new SimpleBooleanProperty(true);
        } else {
            System.out.println("sezte bei elseZweig " + cameraObject.getKameraid().getRawCameraId());
            this.kameraInfo = new SimpleStringProperty("Info bei " + cameraObject.getKameraid().getRawCameraId());
            this.swAktiv = new SimpleBooleanProperty(false);
        }
        this.apiAktiv = cameraObject.getKameraid() != null ? new SimpleBooleanProperty(true) : new SimpleBooleanProperty(false);
        this.ipAdresse = new SimpleStringProperty(cameraObject.getIpAdresse());
        this.pointMotionDetection = new SimpleStringProperty(cameraObject.getEntryPointMotionDetection());
        this.mal = new SimpleStringProperty("" + cameraObject.getMal());
        this.intervallInSekunden = new SimpleStringProperty("" + cameraObject.getIntervallInSekunden());
    }

    public CameraTable(Camera_List_Object camera_List_Object) {
        this.cameraObject = new CameraObject();
        this.cameraObject.setKameraid(camera_List_Object.getCameraId());
        this.cameraObject.setIpAdresse(camera_List_Object.getIP());
        this.kameraInfo = new SimpleStringProperty("Info bei " + this.cameraObject.getKameraid().getRawCameraId());
        this.swAktiv = new SimpleBooleanProperty(false);
        this.apiAktiv = new SimpleBooleanProperty(true);
        this.ipAdresse = new SimpleStringProperty(this.cameraObject.getIpAdresse());
        this.pointMotionDetection = new SimpleStringProperty(this.cameraObject.getEntryPointMotionDetection());
        this.mal = new SimpleStringProperty("" + this.cameraObject.getMal());
        this.intervallInSekunden = new SimpleStringProperty("" + this.cameraObject.getIntervallInSekunden());
    }

    public String getKameraInfo() {
        return this.kameraInfo.get();
    }

    public void setKameraInfo(String info) {
        this.kameraInfo.set(info);
    }

    public boolean getSwAktiv() {
        return this.swAktiv.get();
    }

    public void setSwAktiv(boolean newValue) {
        this.swAktiv.set(newValue);
    }

    public boolean getApiAktiv() {
        return this.apiAktiv.get();
    }

    public void setApiAktiv(boolean newValue) {
        this.apiAktiv.set(newValue);
    }

    public String getIpAdresse() {
        return this.ipAdresse.get();
    }

    public void setIpAdresse(String newValue) {
        this.ipAdresse.set(newValue);
    }

    public CameraObject getCameraObject() {
        return this.cameraObject;
    }

    public String getPointMotionDetection() {
        return this.pointMotionDetection.get();
    }

    public void setPointMotionDetection(String newValue) {
        this.getCameraObject().setEntryPointMotionDetection(newValue);
        this.pointMotionDetection.set(newValue);
    }

    public String getMal() {
        return this.mal.get();
    }

    public void setMal(String malString) {
        try {
            int intValue = Integer.parseInt(malString);
            if (intValue > 0) {
                this.getCameraObject().setMal(intValue);
                this.mal.set(malString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIntervallInSekunden() {
        return this.intervallInSekunden.get();
    }

    public void setIntervallInSekunden(String intervallInSekundenString) {
        try {
            long longValue = Long.parseLong(intervallInSekundenString);
            if (longValue > 0L) {
                this.getCameraObject().setIntervallInSekunden(longValue);
                this.intervallInSekunden.set(intervallInSekundenString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

