/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.sn.core;

import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.module.cc.smartport.remote.EditWhitelist;
import bsc.sdk.kernel.bus.messages.module.cc.smartport.remote.EnableWhitelist;
import bsc.sdk.kernel.bus.messages.module.cc.smartport.remote.GetAssignedSmartPorts;
import bsc.sdk.kernel.bus.messages.module.cc.smartport.remote.GetWhitelist;
import bsc.sdk.kernel.bus.messages.module.cc.smartport.remote.SmartPortRemoved;
import bsc.sdk.kernel.bus.messages.module.cc.smartport.remote.SmartPortUpdate;
import de.bscgmbh.sn.m2m.tunnelclient.services.smartport.ISmartPortListener;
import de.bscgmbh.sn.m2m.tunnelclient.services.smartport.SmartPort;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.engio.mbassy.listener.Handler;

public class SmartPortManagerDelegator
extends AApplicationKernel.KernelModule {
    protected Set<ISmartPortListener> updateListener = new HashSet<ISmartPortListener>();

    public SmartPortManagerDelegator(AApplicationKernel kernel) {
        super(kernel);
    }

    public void unload() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUpdateListener(ISmartPortListener listener) {
        Set<ISmartPortListener> set = this.updateListener;
        synchronized (set) {
            this.updateListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterUpdateListener(ISmartPortListener listener) {
        Set<ISmartPortListener> set = this.updateListener;
        synchronized (set) {
            this.updateListener.remove(listener);
        }
    }

    public Collection<SmartPort> getAssignedRemoteSmartPorts() {
        HashSet<SmartPort> result = new HashSet<SmartPort>();
        GetAssignedSmartPorts msg = new GetAssignedSmartPorts();
        this.postKernelMessage(msg).now();
        if (msg.getSmartPorts() != null) {
            result.addAll(msg.getSmartPorts());
        }
        return result;
    }

    public void clearWhitelist(String smartPortID) {
        if (smartPortID != null) {
            this.postKernelMessage(new EditWhitelist(smartPortID, EditWhitelist.ACTION.CLEAR, new String[0])).now();
        }
    }

    public void addIdsToWhitelist(String smartPortID, String ... ids) {
        if (smartPortID != null) {
            this.postKernelMessage(new EditWhitelist(smartPortID, EditWhitelist.ACTION.ADD, ids)).now();
        }
    }

    public void removeIdsFromWhitelist(String smartPortID, String ... ids) {
        if (smartPortID != null) {
            this.postKernelMessage(new EditWhitelist(smartPortID, EditWhitelist.ACTION.REMOVE, ids)).now();
        }
    }

    public void setWhitelistEnabled(String smartPortID, boolean enabled) {
        if (smartPortID != null) {
            this.postKernelMessage(new EnableWhitelist(smartPortID, enabled)).now();
        }
    }

    public Set<String> getSmartPortWhitelist(String smartPortID) {
        if (smartPortID != null) {
            GetWhitelist msg = new GetWhitelist(smartPortID);
            this.postKernelMessage(msg).now();
            return msg.getWhitelist();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    protected void smartPortRemoved(SmartPortRemoved msg) {
        Set<ISmartPortListener> set = this.updateListener;
        synchronized (set) {
            this.logger.debug("SmartPort removed: " + msg.getSmartPortID());
            for (ISmartPortListener listener : this.updateListener) {
                listener.smartPortRemoved(msg.getSmartPortID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    protected void smartPortUpdate(SmartPortUpdate msg) {
        Set<ISmartPortListener> set = this.updateListener;
        synchronized (set) {
            this.logger.debug("SmartPort updated: " + msg);
            for (ISmartPortListener listener : this.updateListener) {
                listener.smartPortUpdate(msg.getSmartPort());
            }
        }
    }
}

