/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.sn.core;

import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.kernel.ipc.RemoteExecutionRequest;
import bsc.sdk.kernel.bus.messages.module.sn.core.KernelSettingsUpdate;
import bsc.sdk.kernel.bus.messages.module.sn.core.SubscribeForKernelSettings;
import bsc.sdk.kernel.impl.ISmartNodeIpcStateListener;
import bsc.sdk.kernel.impl.SmartNodeIpcClientKernel;
import bsc.sdk.kernel.modules.IKernelModule;
import bsc.sdk.kernel.modules.ipc.AIPCSocketClient;
import bsc.sdk.kernel.modules.ipc.IPCObject;
import bsc.sdk.kernel.modules.sn.core.CoreIpcCommandRedirector;
import bsc.sdk.kernel.modules.sn.core.SMART_NODE_KERNEL_SETTING;
import java.util.ArrayList;
import java.util.Map;
import net.engio.mbassy.listener.Handler;

@IKernelModule.ModuleSettings(loadingPriority=100, dependencies={CoreIpcCommandRedirector.class})
public class KernelSettingsSyncClient
extends AApplicationKernel.KernelModule
implements ISmartNodeIpcStateListener {
    protected SmartNodeIpcClientKernel clientKernel;

    public KernelSettingsSyncClient(AApplicationKernel kernel) {
        super(kernel);
        this.clientKernel = (SmartNodeIpcClientKernel)kernel;
    }

    public void unload() {
        this.unsubscribeMessageListener(IPCObject.class, this);
        this.clientKernel.unregisterStateListener(this);
    }

    public void init() {
        this.subscribeMessageListener(IPCObject.class, this);
        this.clientKernel.registerStateListener(this);
    }

    @Handler
    protected void updateKernelSettings(KernelSettingsUpdate msg) {
        if (msg == null) {
            return;
        }
        boolean somethingChanged = false;
        Map settings = this.getKernelSettings();
        if (settings != null && msg.getSettings() != null) {
            for (Map.Entry entry : msg.getSettings().entrySet()) {
                if (!settings.containsKey(entry.getKey())) continue;
                this.putKernelSetting((String)entry.getKey(), (String)entry.getValue());
                somethingChanged = true;
            }
        }
        if (somethingChanged) {
            this.exportKernelSettings();
        }
    }

    public void subscribeForSmartNodeDefaultKernelSettings() {
        SMART_NODE_KERNEL_SETTING[] settings = SMART_NODE_KERNEL_SETTING.values();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < settings.length; ++i) {
            if (SMART_NODE_KERNEL_SETTING.KERNEL_VERSION.equals((Object)settings[i])) continue;
            args.add(settings[i].name());
        }
        this.subscribeForKernelSettings(args.toArray(new String[args.size()]));
    }

    public void subscribeForKernelSettings(String ... keys) {
        boolean somethingChanged = false;
        Map settings = this.getKernelSettings();
        if (keys != null && settings != null) {
            for (String key : keys) {
                if (settings.containsKey(key)) continue;
                this.putKernelSetting(key, "");
                somethingChanged = true;
            }
        }
        if (somethingChanged) {
            this.exportKernelSettings();
        }
        this.postKernelMessage(new RemoteExecutionRequest((IPCObject)new SubscribeForKernelSettings(this.getKernelSettings()), true)).now();
    }

    @Override
    public void ipcState(AIPCSocketClient.IPC_STATE currentIPCStatus) {
        System.out.println("IPC: " + currentIPCStatus);
        if (AIPCSocketClient.IPC_STATE.CONNECTED.equals((Object)currentIPCStatus)) {
            this.subscribeForSmartNodeDefaultKernelSettings();
        }
    }

    @Override
    public void cloudClientState(boolean cloudClientStarted, boolean cloudClientConnected) {
    }

    @Override
    public void shutdown() {
    }
}

