/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.ipc;

import bsc.sdk.kernel.modules.idpool.IdPool;
import bsc.sdk.kernel.modules.ipc.IPCObject;
import bsc.sdk.kernel.modules.ipc.RemoteExecutionContainer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.Socket;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPCSocketTransceiver
implements Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Socket socket;
    protected final ObjectMapper objectMapper;
    protected boolean running = true;
    protected final String id;
    protected final IdPool idPool;
    protected ByteArrayOutputStream baos;
    private Set<IPCSocketObjectListener> listener;

    public IPCSocketTransceiver(IdPool remoteExecutionIdPool, Socket socket, IPCSocketObjectListener ... listeners) {
        this(remoteExecutionIdPool.getId(), remoteExecutionIdPool, socket, listeners);
    }

    public IPCSocketTransceiver(String id, IdPool remoteExecutionIdPool, Socket socket, IPCSocketObjectListener ... listeners) throws InvalidParameterException {
        if (socket == null) {
            throw new InvalidParameterException("socket must not be null!");
        }
        this.socket = socket;
        this.idPool = remoteExecutionIdPool;
        this.id = id;
        this.listener = Collections.newSetFromMap(new ConcurrentHashMap());
        if (listeners != null) {
            for (IPCSocketObjectListener ipcSocketObjectListener : listeners) {
                this.listener.add(ipcSocketObjectListener);
            }
        }
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false).enableDefaultTyping();
        this.logger.trace("IPCSocketTransceiver created with id: " + this.id);
        this.baos = new ByteArrayOutputStream();
    }

    public void registerObjectListener(IPCSocketObjectListener listener) {
        this.logger.trace("Register listener: " + listener.getClass().getName());
        this.listener.add(Objects.requireNonNull(listener, "listener must not be null!"));
    }

    public void unregisterObjectListener(IPCSocketObjectListener listener) {
        this.logger.trace("Unregister listener: " + listener.getClass().getName());
        this.listener.remove(Objects.requireNonNull(listener, "listener must not be null!"));
    }

    @Override
    public void run() {
        if (this.running) {
            if (this.socket.isClosed()) {
                this.shutdown();
                return;
            }
            try {
                SequenceInputStream in = new SequenceInputStream(new ByteArrayInputStream(this.baos.toByteArray()), this.socket.getInputStream());
                JsonParser parser = this.objectMapper.getFactory().createParser((InputStream)in);
                RemoteExecutionContainer remoteExecutionContainer = (RemoteExecutionContainer)this.objectMapper.readValue(parser, RemoteExecutionContainer.class);
                this.logger.trace(this.id + " | recceived: " + remoteExecutionContainer);
                for (IPCSocketObjectListener l : this.listener) {
                    l.objectRecceived(this, remoteExecutionContainer);
                }
                this.baos.reset();
                parser.releaseBuffered((OutputStream)this.baos);
            }
            catch (IOException e) {
                this.logger.trace(e.getMessage(), (Throwable)e);
                this.logger.error(e.getMessage());
                this.shutdown();
                return;
            }
        }
    }

    public <T> RemoteExecutionContainer<T> sendObject(IPCObject<T> object) {
        return this.writeObject(object, false);
    }

    public void sendExecutionResult(RemoteExecutionContainer<?> container) {
        this.writeObject(container, true);
    }

    private <T> RemoteExecutionContainer<T> writeObject(IPCObject<T> object, boolean executionResult) {
        RemoteExecutionContainer remoteExecutionContainer = null;
        if (this.socket.isClosed()) {
            this.shutdown();
        } else {
            RemoteExecutionContainer remoteExecutionContainer2 = remoteExecutionContainer = object instanceof RemoteExecutionContainer ? (RemoteExecutionContainer)object : new RemoteExecutionContainer<T>(object, this.idPool.getId());
            if (!executionResult) {
                remoteExecutionContainer.executionFinished = false;
                this.registerObjectListener(remoteExecutionContainer);
            }
            try {
                this.logger.trace(this.id + " | send: " + remoteExecutionContainer);
                this.objectMapper.writeValue(this.socket.getOutputStream(), (Object)remoteExecutionContainer);
            }
            catch (IOException e) {
                this.logger.trace(e.getMessage(), (Throwable)e);
                this.logger.error(e.getMessage());
            }
        }
        return remoteExecutionContainer;
    }

    protected void shutdown() {
        this.logger.trace("Shutdown transceiver!");
        this.running = false;
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.logger.error("Dead socket detected! " + this.id);
        }
        for (IPCSocketObjectListener l : this.listener) {
            l.socketClosed(this);
        }
        if (this.idPool != null) {
            this.idPool.freeID(this.id);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public String getId() {
        return this.id;
    }

    public static interface IPCSocketObjectListener {
        public void objectRecceived(IPCSocketTransceiver var1, RemoteExecutionContainer<?> var2);

        public void socketClosed(IPCSocketTransceiver var1);
    }
}

