/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.sdk.controller;

import de.bscgmbh.iroom.IIRoomDataListener;
import de.bscgmbh.iroom.IRoomClient;
import de.bscgmbh.iroom.api.IIRoomReceiveCommand;
import de.bscgmbh.iroom.api.IIRoomSendCommand;
import de.bscgmbh.iroom.api.data.types.RequestEnum;
import de.bscgmbh.iroom.api.factory.RequestFactory;
import de.bscgmbh.iroom.sdk.IRoomController;
import de.bscgmbh.iroom.sdk.IRoomDeviceProperties;
import de.bscgmbh.iroom.sdk.controller.DefaultUpdateHandler;
import de.bscgmbh.iroom.sdk.controller.DeviceDiscoveryUpdateHandler;
import de.bscgmbh.iroom.sdk.controller.IRoomConnector;
import de.bscgmbh.iroom.sdk.controller.IUpdateHandler;
import de.bscgmbh.iroom.sdk.msg.AIRoomConnectionObject;
import de.bscgmbh.iroom.sdk.msg.controller.IRoomConnectionState;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRoomConnection
implements IIRoomDataListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String id = null;
    protected String host = null;
    protected int port = 0;
    protected boolean running = true;
    protected IRoomClient client = null;
    protected IRoomController controller;
    protected IUpdateHandler updateHandler = null;
    protected boolean reconnectInProgress = false;
    private boolean lastConnectionState = false;

    public IRoomConnection(IRoomController controller, String host, int port) {
        this.controller = controller;
        this.host = Objects.requireNonNull(host, "host must not be null!");
        this.port = Objects.requireNonNull(Integer.valueOf(port), "port must not be null!");
        this.id = IRoomConnection.generateConnectionID(host, port);
        this.resetUpdateHandler();
    }

    @Override
    public void connectionClosed() {
        this.client = null;
        this.logger.info("Connection closed to iRoom server " + this.host + ":" + this.port);
        if (this.lastConnectionState) {
            this.postMsg(new IRoomConnectionState(this.id, false), false);
            this.lastConnectionState = false;
            this.logger.trace("Connection lost, schedule reconnect in 5 seconds...");
            this.controller.executeInBackground(new IRoomConnector(this, TimeUnit.SECONDS.toMillis(5L), true));
        }
    }

    @Override
    public void connectionEstablished() {
        this.logger.info("Connection established to iRoom server " + this.host + ":" + this.port);
        if (!this.lastConnectionState) {
            this.postMsg(new IRoomConnectionState(this.id, true), false);
            this.lastConnectionState = true;
            this.sendDiscoverCommands();
        }
    }

    @Override
    public void connectionAborted(Throwable error) {
        this.disconnect(error);
    }

    @Override
    public void connectionRefused(Throwable error) {
        this.disconnect(error);
    }

    public void disconnect() {
        this.disconnect(null);
    }

    public void disconnect(Throwable error) {
        if (this.client != null) {
            this.client.disconnect();
        }
        if (error != null) {
            this.logger.error(error.getMessage(), error);
        }
    }

    protected void postMsg(AIRoomConnectionObject msg, boolean asynchron) {
        if (msg != null && this.isReady()) {
            this.controller.publishIRoomObject(msg, asynchron);
        }
    }

    @Override
    public void update(IIRoomReceiveCommand iRoomReceiveCommand) {
        if (this.updateHandler != null) {
            this.updateHandler.update(iRoomReceiveCommand, this);
        } else {
            this.logger.error("Failed to execute iRoom object update! No update handler available.");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isConnected() {
        return this.client != null ? this.client.isConnected() : false;
    }

    public boolean isReady() {
        return this.running && this.controller != null && this.updateHandler != null;
    }

    public void shutdown() {
        this.running = false;
        if (this.client != null) {
            this.client.disconnect();
        }
        this.client = null;
        this.controller = null;
    }

    public IRoomConnection connect() {
        this.client = new IRoomClient(this.host, this.port, this);
        this.client.connect();
        return this;
    }

    public void reconnect() {
        if (!this.reconnectInProgress) {
            this.reconnectInProgress = true;
            this.disconnect();
            this.connect();
            this.reconnectInProgress = false;
        }
    }

    public static String generateConnectionID(String host, int port) {
        if (host != null && port > 0) {
            return IRoomConnection.class.getSimpleName() + "://" + host + ":" + String.valueOf(port);
        }
        return null;
    }

    protected void resetUpdateHandler() {
        this.updateHandler = DefaultUpdateHandler.getInstance();
    }

    public IRoomDeviceProperties discoverProperties(int secondsToDiscover) {
        IRoomDeviceProperties result = null;
        if (this.isReady() && this.isConnected()) {
            DeviceDiscoveryUpdateHandler discoveryHandler = new DeviceDiscoveryUpdateHandler();
            this.updateHandler = discoveryHandler;
            this.sendDiscoverCommands();
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(secondsToDiscover));
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.resetUpdateHandler();
            IRoomDeviceProperties discoverResult = discoveryHandler.getProperties();
            if (this.validateProperties(discoverResult)) {
                result = discoverResult;
            }
        }
        return result;
    }

    protected boolean validateProperties(IRoomDeviceProperties properties) {
        return properties != null && properties.isDockingState();
    }

    protected void sendDiscoverCommands() {
        this.sendCommand(RequestFactory.getRequest(RequestEnum.INF_UPDATE));
        this.sendCommand(RequestFactory.getRequest(RequestEnum.VOLUME));
    }

    public void forceDeviceDataRefresh() {
        if (this.isReady() && this.isConnected()) {
            this.sendDiscoverCommands();
        }
    }

    public void sendCommand(IIRoomSendCommand sendCommand) {
        if (this.isReady() && this.isConnected()) {
            this.client.send(sendCommand);
        }
    }
}

