/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom.api.data.types;

import de.bscgmbh.iroom.api.data.DefaultIRoomParameterVOCreator;
import de.bscgmbh.iroom.api.data.IIRoomComandType;
import de.bscgmbh.iroom.api.data.parameter.IIRoomParameterVO;
import de.bscgmbh.iroom.api.data.parameter.IRoomParameterString;
import de.bscgmbh.iroom.api.data.types.StateValueEnum;
import de.bscgmbh.iroom.utils.range.CurrentValueWithRangeLimitation;
import de.bscgmbh.iroom.utils.range.StringLengthLimitation;
import de.bscgmbh.iroom.utils.range.UnitEnum;
import java.util.Objects;

public enum ExtendedInformationEnum implements IIRoomComandType
{
    PLUGDRIVE("plugdrive", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.UNDOCKED, StateValueEnum.DOCKING, StateValueEnum.UNDOCKING, StateValueEnum.DOCKED, StateValueEnum.UNDOCKED)),
    CLACKDRIVE("clackdrive", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.OPENEND, StateValueEnum.OPENING, StateValueEnum.CLOSING, StateValueEnum.OPENEND, StateValueEnum.CLOSED)),
    DOCKING_STATE("dockingstate", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.UNDOCKED, StateValueEnum.DOCKING, StateValueEnum.UNDOCKING, StateValueEnum.DOCKED, StateValueEnum.UNDOCKED)),
    RELAY_0("relay0", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.OPENEND, StateValueEnum.OPENEND, StateValueEnum.CLOSED)),
    BEEP("beep", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 1)),
    LED_0("led0", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_1("led1", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_2("led2", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_3("led3", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_4("led4", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_5("led5", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_6("led6", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_7("led7", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    LED_8("led8", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    DIGITAL_0("digital0", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    DIGITAL_1("digital1", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    DIGITAL_2("digital2", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    DIGITAL_3("digital3", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    DIGITAL_4("digital4", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    DIGITAL_5("digital5", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    DIGITAL_6("digital6", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    DIGITAL_7("digital7", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    DIGITAL_8("digital8", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.CLOSED, StateValueEnum.CLOSED, StateValueEnum.OPENEND)),
    IR_LEVEL("irlevel", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 255)),
    ALIVE("alive", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(1, 1, 1)),
    IDOCK_TOUCHCODE("ibezelmode", DefaultIRoomParameterVOCreator.createIRoomParameterStateValueEnum(StateValueEnum.TOUCHCODE, StateValueEnum.TOUCHCODE, StateValueEnum.IBEZEL)),
    VOLUME("volume", DefaultIRoomParameterVOCreator.createIRoomParameterInteger(0, 0, 100, UnitEnum.PERCENT)),
    DOCK_FIRMWARE("dock_fw", new IRoomParameterString(new CurrentValueWithRangeLimitation<String>("", new StringLengthLimitation()))),
    BOOT_FIRMWARE("boot_fw", new IRoomParameterString(new CurrentValueWithRangeLimitation<String>("", new StringLengthLimitation()))),
    TOUCH_BEZEL_FIRMWARE("bezel_fw", new IRoomParameterString(new CurrentValueWithRangeLimitation<String>("", new StringLengthLimitation()))),
    MODEL("model", new IRoomParameterString(new CurrentValueWithRangeLimitation<String>("", new StringLengthLimitation())));

    private final String apiShortcutDescription;
    private final IIRoomParameterVO iRoomParameterVO;

    private ExtendedInformationEnum(String apiShortcutDescription, IIRoomParameterVO iRoomParameterVO) {
        this.apiShortcutDescription = apiShortcutDescription;
        this.iRoomParameterVO = iRoomParameterVO;
    }

    @Override
    public String getApiShortcutDescription() {
        return this.apiShortcutDescription;
    }

    public static ExtendedInformationEnum fromApiShortcutDescription(String apiShortcutDescription) {
        Objects.requireNonNull(apiShortcutDescription, "apiShortcutDescription must not be null");
        for (ExtendedInformationEnum extendedInformationEnum : ExtendedInformationEnum.values()) {
            if (!extendedInformationEnum.getApiShortcutDescription().equals(apiShortcutDescription)) continue;
            return extendedInformationEnum;
        }
        return null;
    }

    @Override
    public IIRoomParameterVO<?> getIIRoomParameterVO() {
        return this.iRoomParameterVO;
    }
}

