/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IRoomRawCommand {
    private static final String TYPE = "type";
    private static final String COMMAND = "command";
    private static final String PARAMETER = "parameter";
    private final String type;
    private final String command;
    private final String parameter;

    public IRoomRawCommand(String type, String command, String parameter) {
        this.type = type;
        this.command = command;
        this.parameter = parameter;
    }

    public String getType() {
        return this.type;
    }

    public String getCommand() {
        return this.command;
    }

    public String getParameter() {
        return this.parameter;
    }

    public static IRoomRawCommand parseRawCommand(String rawCommand) {
        Pattern pattern = Pattern.compile("(?<type>\\w+):(?<command>\\w+)(;|:(?<parameter>[a-zA-Z_0-9\\.]+);)");
        Matcher m = pattern.matcher(rawCommand);
        if (m.matches()) {
            return new IRoomRawCommand(m.group(TYPE), m.group(COMMAND), m.group(PARAMETER));
        }
        return null;
    }

    public String toString() {
        return "IRoomRawCommand [type=" + this.type + ", command=" + this.command + ", parameter=" + this.parameter + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.parameter == null ? 0 : this.parameter.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IRoomRawCommand other = (IRoomRawCommand)obj;
        if (this.command == null ? other.command != null : !this.command.equals(other.command)) {
            return false;
        }
        if (this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

