/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.iroom;

import de.bscgmbh.iroom.IIRoomClient;
import de.bscgmbh.iroom.IIRoomDataListener;
import de.bscgmbh.iroom.IRoomRawCommand;
import de.bscgmbh.iroom.api.IIRoomReceiveCommand;
import de.bscgmbh.iroom.api.IIRoomSendCommand;
import de.bscgmbh.iroom.api.factory.IRoomReceiveCommandFactory;
import de.bscgmbh.iroom.api.request.RequestAliveState;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRoomClient
implements IIRoomClient {
    private int SOCKET_TIMEOUT_MS = (int)TimeUnit.MINUTES.toMillis(3L);
    private int KEEP_ALIVE_TIMEOUT_SEC = 140;
    private Logger logger = LoggerFactory.getLogger(IRoomClient.class);
    private String host;
    private int port;
    private Socket socket;
    private BlockingQueue<String> sendQueue;
    private Future<?> receiveFuture;
    private Future<?> sendFuture;
    private Future<?> periodicKeepAliveFuture;
    private EventListenerSupport<IIRoomDataListener> iRoomUpdateListenerSupport = EventListenerSupport.create(IIRoomDataListener.class);

    public IRoomClient(String host, int port, IIRoomDataListener iRoomDataListener) {
        this.host = host;
        this.port = port;
        this.sendQueue = new LinkedBlockingQueue<String>();
        if (iRoomDataListener != null) {
            this.iRoomUpdateListenerSupport.addListener((Object)iRoomDataListener, false);
        }
    }

    public IRoomClient(String host, int port) {
        this(host, port, null);
    }

    @Override
    public boolean connect() {
        if (this.isConnected()) {
            return this.isConnected();
        }
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(this.SOCKET_TIMEOUT_MS);
        }
        catch (IOException e) {
            ((IIRoomDataListener)this.iRoomUpdateListenerSupport.fire()).connectionRefused(e);
            return false;
        }
        ExecutorService executor = Executors.newFixedThreadPool(3);
        this.receiveFuture = executor.submit(new Runnable(){

            @Override
            public void run() {
                try (BufferedInputStream is = new BufferedInputStream(IRoomClient.this.socket.getInputStream());){
                    byte[] tmp = new byte[4096];
                    int bytesRead = 0;
                    while ((bytesRead = is.read(tmp, 0, tmp.length)) >= 0) {
                        String[] test;
                        String rawCommand = new String(tmp, 0, bytesRead);
                        IRoomClient.this.logger.trace("RAW IN: " + rawCommand);
                        if (rawCommand == null) continue;
                        for (String singleCommand : test = rawCommand.split(";")) {
                            IRoomRawCommand roomRawCommand = IRoomRawCommand.parseRawCommand(singleCommand = singleCommand + ";");
                            if (roomRawCommand != null) {
                                IIRoomReceiveCommand iRoomReceiveCommand = IRoomReceiveCommandFactory.getIRoomReceiveCommand(roomRawCommand);
                                if (iRoomReceiveCommand == null) continue;
                                ((IIRoomDataListener)IRoomClient.this.iRoomUpdateListenerSupport.fire()).update(iRoomReceiveCommand);
                                continue;
                            }
                            IRoomClient.this.logger.error("EEROR could not parse: '" + singleCommand + "'");
                        }
                    }
                }
                catch (IOException e) {
                    IRoomClient.this.disconnect();
                    ((IIRoomDataListener)IRoomClient.this.iRoomUpdateListenerSupport.fire()).connectionAborted(e);
                }
                IRoomClient.this.logger.trace("end reading Thread");
            }
        });
        this.sendFuture = executor.submit(new Runnable(){

            @Override
            public void run() {
                try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(IRoomClient.this.socket.getOutputStream()));){
                    while (!Thread.currentThread().isInterrupted()) {
                        String message = (String)IRoomClient.this.sendQueue.take();
                        IRoomClient.this.logger.trace("RAW out: " + message);
                        if (message == null) continue;
                        out.write(message);
                        out.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    IRoomClient.this.disconnect();
                    ((IIRoomDataListener)IRoomClient.this.iRoomUpdateListenerSupport.fire()).connectionAborted(e);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                IRoomClient.this.logger.trace("end writing Thread");
            }
        });
        this.periodicKeepAliveFuture = executor.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        TimeUnit.SECONDS.sleep(IRoomClient.this.KEEP_ALIVE_TIMEOUT_SEC);
                        IRoomClient.this.send(new RequestAliveState());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                IRoomClient.this.logger.trace("end keepAlive Thread");
            }
        });
        ((IIRoomDataListener)this.iRoomUpdateListenerSupport.fire()).connectionEstablished();
        executor.shutdown();
        this.logger.trace("Connected to " + this.socket.getRemoteSocketAddress());
        return true;
    }

    @Override
    public void disconnect() {
        if (this.periodicKeepAliveFuture != null) {
            this.periodicKeepAliveFuture.cancel(true);
        }
        if (this.receiveFuture != null) {
            this.receiveFuture.cancel(true);
        }
        if (this.sendFuture != null) {
            this.sendFuture.cancel(true);
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ((IIRoomDataListener)this.iRoomUpdateListenerSupport.fire()).connectionClosed();
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    private void send(String message) {
        Objects.requireNonNull(message, "message must not be null");
        if (this.sendQueue != null && this.isConnected()) {
            this.sendQueue.offer(message);
        }
    }

    @Override
    public boolean send(IIRoomSendCommand sendCommand) {
        Objects.requireNonNull(sendCommand, "sendCommand must not be null");
        if (this.sendQueue != null && this.isConnected()) {
            return this.sendQueue.offer(sendCommand.buildStringRepresentation());
        }
        return false;
    }

    @Override
    public void addListener(IIRoomDataListener listener) {
        Objects.requireNonNull(listener, "listener must not be null");
        this.iRoomUpdateListenerSupport.addListener((Object)listener, false);
    }

    @Override
    public void removeListener(IIRoomDataListener listener) {
        Objects.requireNonNull(listener, "listener must not be null");
        this.iRoomUpdateListenerSupport.removeListener((Object)listener);
    }

    @Override
    public List<IIRoomDataListener> getListeners() {
        return Arrays.asList(this.iRoomUpdateListenerSupport.getListeners());
    }

    public static void main(String[] args) {
        IRoomClient client = new IRoomClient("192.168.150.123", 13601, new IIRoomDataListener(){

            @Override
            public void connectionRefused(Throwable error) {
                System.out.println("ConenctionRefused: " + error);
            }

            @Override
            public void connectionEstablished() {
                System.out.println("connectionEstablished");
            }

            @Override
            public void connectionClosed() {
                System.out.println("connectionClosed");
            }

            @Override
            public void connectionAborted(Throwable error) {
                System.out.println("connectionAborted: " + error);
            }

            @Override
            public void update(IIRoomReceiveCommand iRoomReceiveCommand) {
                System.out.println("update: " + iRoomReceiveCommand);
            }
        });
        client.connect();
    }
}

