/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.bierconfig;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.components.JWizardHeader;
import de.bsc.bapfinder.components.ProgressDialog;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.bierconfig.BierConfigurator;
import de.bsc.bapfinder.plugins.bierconfig.bier.BAPMessage;
import de.bsc.bapfinder.plugins.bierconfig.bier.RoutingObject;
import de.bsc.bapfinder.plugins.bierconfig.bier.TCMPacket;
import de.bsc.bapfinder.plugins.bierconfig.localization.Messages;
import de.bsc.bapfinder.tools.RandomArrayStream;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BierConfiguratorDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -2239357000915086216L;
    public static final int COMMAND_CHANGE_ID = 2;
    public static final int COMMAND_CONFIG_MODE = 3;
    public static final int COMMAND_REBOOT = 4;
    public static final int MESSAGE_COMMAND = 1;
    public static final int MESSAGE_REQUEST = 3;
    public static final int MESSAGE_REQUEST_ANSWER = 5;
    public static final int MESSAGE_COMMAND_ANSWER = 6;
    public static final int MESSAGE_ROUTING_LIST = 11;
    public static final int MESSAGE_TYPE_TCM = 2;
    public static final int REQUEST_ROUTINGOBJECTS = 4;
    public static final int TYPE_SWITCH = 1;
    public static final int TYPE_HANDLE = 2;
    public static final int TYPE_REED = 3;
    public static final int TYPE_SENSOR = 4;
    private static File lastDirectory = new File(".");
    private Frame owner;
    private BierConfigurator plugin;
    private IBAPFinder api;
    private IBAPFinder.IBAP bap;
    private boolean configMode = false;
    private List<RoutingObject> routingObjects;
    private MessageListener messageListener;
    private TableModelReceived tableModelReceived;
    private TableCellRendererReceived tableRendererReceived;
    private TableModelAssigned tableModelAssigned;
    private TableCellRendererAssigned tableRendererAssigned;
    private TableCellEditorAssigned tableEditorAssigned;
    private boolean routingChanged = false;
    private JPanel jContentPane;
    private JWizardHeader wizardHeader = null;
    private JPanel panelSettings = null;
    private JPanel panelButtons = null;
    private JButton buttonExit = null;
    private JScrollPane scrollPaneAssigned = null;
    private JTable tableAssigned = null;
    private JPanel panelAssignButtons = null;
    private JScrollPane scrollPaneReceived = null;
    private JTable tableReceived = null;
    private JButton buttonAssign = null;
    private JButton buttonRemove = null;
    private JButton buttonAssignManual = null;
    private JButton buttonDelete = null;
    private Timer timer = null;
    private JButton buttonSend = null;
    private JButton buttonExport = null;
    private JButton buttonImport = null;
    private JComboBox comboBoxFilterAssigned = null;
    private JPanel panelFilterAssigned = null;
    private JPanel panelFilterReceived = null;
    private JComboBox comboBoxFilterRecevied = null;
    private TableRowSorter<TableModel> tableSorterAssigned;
    private TableRowSorter<TableModel> tableSorterReceived;

    public BierConfiguratorDialog(BierConfigurator plugin) {
        super(plugin.api.getFrame());
        this.plugin = plugin;
        this.api = plugin.api;
        this.bap = this.api.getSelectedBAP();
        this.owner = this.api.getFrame();
        this.setTitle(this.owner == null ? "" : this.owner.getTitle());
        this.routingObjects = new ArrayList<RoutingObject>();
        this.initialize();
        this.setLocationRelativeTo(this.owner);
        this.setModal(true);
        this.timer = new Timer(1000, this);
        this.timer.setRepeats(true);
        this.timer.setActionCommand("timer");
        this.timer.start();
    }

    private void initialize() {
        this.setSize(762, 667);
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                BierConfiguratorDialog.this.quit();
            }
        });
        this.setConfigMode(true);
    }

    private Container getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = -1;
            gridBagConstraints14.gridy = -1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getWizardHeader(), gridBagConstraints);
            this.jContentPane.add((Component)this.getPanelSettings(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getPanelButtons(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("timer")) {
            this.tableAssigned.repaint();
            this.tableReceived.repaint();
        } else if (command.equals("assign_manual")) {
            long newID = this.getNewID();
            if (newID == -1L) {
                JOptionPane.showMessageDialog(this, Messages.getString("BierConfiguratorDialog.5"));
                return;
            }
            RoutingObject routingObject = new RoutingObject();
            routingObject.setForeignID(newID);
            routingObject.setLocked(false);
            this.tableModelAssigned.addRow(routingObject);
            this.routingChanged = true;
        } else if (command.equals("assign")) {
            int[] rows = this.tableReceived.getSelectedRows();
            int index = 0;
            while (index < rows.length) {
                int row = this.tableReceived.convertRowIndexToModel(rows[index]);
                RoutingObject routingObject = this.tableModelReceived.getRoutingObject(row);
                if (routingObject == null) {
                    return;
                }
                long id = this.getNewID();
                if (id == -1L) {
                    JOptionPane.showMessageDialog(this, Messages.getString("BierConfiguratorDialog.5"), Messages.getString("BierConfiguratorDialog.6"), 0);
                    break;
                }
                routingObject.setForeignID(id);
                this.tableModelAssigned.addRow(routingObject);
                ++index;
            }
            int[] rowsToDelete = new int[index];
            System.arraycopy(rows, 0, rowsToDelete, 0, index);
            Arrays.sort(rowsToDelete);
            int i = 0;
            while (i < rows.length) {
                this.tableModelReceived.removeRow(this.tableReceived.convertRowIndexToModel(rowsToDelete[i] - i));
                ++i;
            }
            if (rows.length > 0) {
                this.routingChanged = true;
            }
        } else if (command.equals("remove")) {
            int[] rows = this.tableAssigned.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            int index = 0;
            while (index < rows.length) {
                int row = this.tableAssigned.convertRowIndexToModel(rows[index]);
                RoutingObject routingObject = this.tableModelAssigned.getRoutingObject(row);
                if (routingObject != null) {
                    routingObject.setForeignID(0L);
                    this.tableModelReceived.addRow(routingObject);
                }
                ++index;
            }
            this.tableEditorAssigned.stopCellEditing();
            Arrays.sort(rows);
            int i = 0;
            while (i < rows.length) {
                this.tableModelAssigned.removeRow(this.tableAssigned.convertRowIndexToModel(rows[i] - i));
                ++i;
            }
            if (rows.length > 0) {
                this.routingChanged = true;
            }
        } else if (command.equals("delete")) {
            int[] rows = this.tableAssigned.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            String text = null;
            text = rows.length == 1 ? Messages.getString("BierConfiguratorDialog.8") : Messages.getString("BierConfiguratorDialog.9");
            int result = JOptionPane.showConfirmDialog(this, text, Messages.getString("BierConfiguratorDialog.10"), 0);
            if (result != 0) {
                return;
            }
            this.tableEditorAssigned.stopCellEditing();
            Arrays.sort(rows);
            int i = 0;
            while (i < rows.length) {
                this.tableModelAssigned.removeRow(this.tableAssigned.convertRowIndexToModel(rows[i] - i));
                ++i;
            }
            if (rows.length > 0) {
                this.routingChanged = true;
            }
        } else if (command.equals("exit")) {
            this.quit();
        } else if (command.equals("send")) {
            this.sendRoutingTable(false);
        } else if (command.equals("export")) {
            Object[] options = new Object[]{"Text", Messages.getString("BierConfiguratorDialog.15")};
            int result = JOptionPane.showOptionDialog(this, Messages.getString("BierConfiguratorDialog.16"), Messages.getString("BierConfiguratorDialog.17"), -1, 3, null, options, options[0]);
            if (result == -1) {
                return;
            }
            if (result == 0) {
                result = this.exportText();
            } else if (result == 1) {
                result = this.exportBin();
            }
            switch (result) {
                case 0: {
                    JOptionPane.showMessageDialog(this, Messages.getString("BierConfiguratorDialog.18"), Messages.getString("BierConfiguratorDialog.17"), 1);
                    break;
                }
                case -1: {
                    break;
                }
                case -2: {
                    JOptionPane.showMessageDialog(this, Messages.getString("BierConfiguratorDialog.20"), Messages.getString("BierConfiguratorDialog.17"), 0);
                }
            }
        } else if (command.equals("import")) {
            int result = this.importBin();
            switch (result) {
                case 0: {
                    this.routingChanged = true;
                    break;
                }
                case -1: {
                    break;
                }
                case -2: {
                    JOptionPane.showMessageDialog(this, Messages.getString("BierConfiguratorDialog.25"), Messages.getString("BierConfiguratorDialog.24"), 0);
                }
            }
        } else if (command.equals("filter_assigned")) {
            int filterType = (Integer)this.comboBoxFilterAssigned.getSelectedItem();
            if (filterType == -1) {
                this.tableSorterAssigned.setRowFilter(null);
            } else {
                this.tableSorterAssigned.setRowFilter(RowFilter.numberFilter(RowFilter.ComparisonType.EQUAL, filterType, 0));
            }
        } else if (command.equals("filter_received")) {
            int filterType = (Integer)this.comboBoxFilterRecevied.getSelectedItem();
            if (filterType == -1) {
                this.tableSorterReceived.setRowFilter(null);
            } else {
                this.tableSorterReceived.setRowFilter(RowFilter.numberFilter(RowFilter.ComparisonType.EQUAL, filterType, 0));
            }
        }
    }

    private void quit() {
        int result = 1;
        if (this.routingChanged) {
            result = JOptionPane.showConfirmDialog(this, Messages.getString("BierConfiguratorDialog.4"), Messages.getString("BierConfiguratorDialog.2"), 1, 3);
        }
        if (result == 2 || result == -1) {
            return;
        }
        if (result == 0) {
            this.sendRoutingTable(true);
        } else {
            this.setConfigMode(false);
            this.timer.stop();
            this.dispose();
        }
    }

    private File getFile(String title, boolean open, FileNameExtensionFilter filter) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(lastDirectory);
        chooser.setDialogTitle(title);
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        }
        chooser.setMultiSelectionEnabled(false);
        int state = 1;
        state = open ? chooser.showOpenDialog(this) : chooser.showSaveDialog(this);
        if (state == 1) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (filter != null && chooser.getFileFilter() instanceof FileNameExtensionFilter) {
            String[] extensions = ((FileNameExtensionFilter)chooser.getFileFilter()).getExtensions();
            boolean found = false;
            String path = file.getAbsolutePath();
            int index = 0;
            while (index < extensions.length && !found) {
                found |= path.endsWith(extensions[index]);
                ++index;
            }
            if (!found) {
                path = String.valueOf(path) + "." + extensions[index - 1];
                file = new File(path);
            }
        }
        lastDirectory = file.isDirectory() ? file : file.getParentFile();
        if (!open && file.exists() && JOptionPane.showConfirmDialog(this, Messages.getString("BierConfiguratorDialog.28"), title, 0, 3) == 1) {
            return null;
        }
        return file;
    }

    private int importBin() {
        File file = this.getFile(Messages.getString("BierConfiguratorDialog.24"), true, new FileNameExtensionFilter("*.bin", "bin"));
        if (file == null) {
            return -1;
        }
        FileInputStream fileInputStream = null;
        FilterInputStream dataInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                dataInputStream = new DataInputStream(fileInputStream);
                long identifier = ((DataInputStream)dataInputStream).readLong();
                if (identifier != 4776425099556245062L) {
                    throw new Exception(Messages.getString("BierConfiguratorDialog.32"));
                }
                identifier = ((DataInputStream)dataInputStream).readLong();
                if (identifier != 5280282899886919506L) {
                    throw new Exception(Messages.getString("BierConfiguratorDialog.32"));
                }
                long bapIDImport = ((DataInputStream)dataInputStream).readLong();
                boolean changeForeignIDs = false;
                boolean changeOwnIDs = false;
                if (bapIDImport != this.bap.getId()) {
                    Object[] options = new String[]{Messages.getString("BierConfiguratorDialog.24"), Messages.getString("BierConfiguratorDialog.1")};
                    int result = JOptionPane.showOptionDialog(this, Messages.getString("BierConfiguratorDialog.34"), Messages.getString("BierConfiguratorDialog.24"), -1, 3, null, options, options[0]);
                    if (result == -1) {
                        throw new Exception(Messages.getString("BierConfiguratorDialog.32"));
                    }
                    if (result == 0) {
                        changeForeignIDs = true;
                    } else {
                        changeOwnIDs = true;
                    }
                }
                ArrayList<RoutingObject> routingObjects = new ArrayList<RoutingObject>();
                int count = ((DataInputStream)dataInputStream).readInt();
                int i = 0;
                while (i < count) {
                    RoutingObject routingObject = new RoutingObject();
                    routingObject.setOwnID(((DataInputStream)dataInputStream).readLong());
                    routingObject.setForeignID(((DataInputStream)dataInputStream).readLong());
                    routingObject.setType(((DataInputStream)dataInputStream).readInt());
                    routingObject.setDescription(Tools.readString((DataInputStream)dataInputStream));
                    routingObject.setLastLearnMessage(Tools.readData((DataInputStream)dataInputStream));
                    routingObjects.add(routingObject);
                    ++i;
                }
                if (changeForeignIDs) {
                    long bapID = this.bap.getId();
                    for (RoutingObject routingObject : routingObjects) {
                        long fID = routingObject.getForeignID() - bapIDImport;
                        routingObject.setForeignID(fID += bapID);
                    }
                } else if (changeOwnIDs) {
                    int difference = 127 - routingObjects.size() - this.routingObjects.size();
                    if (difference < 0) {
                        JOptionPane.showMessageDialog(this, String.format(Messages.getString("BierConfiguratorDialog.3"), Math.abs(difference)), Messages.getString("BierConfiguratorDialog.24"), 0);
                        throw new Exception(Messages.getString("BierConfiguratorDialog.32"));
                    }
                    for (RoutingObject routingObject : routingObjects) {
                        long foreignID = this.getNewID();
                        routingObject.setOwnID(routingObject.getForeignID());
                        routingObject.setForeignID(foreignID);
                        this.tableModelAssigned.addRow(routingObject);
                    }
                }
                if (!changeOwnIDs) {
                    int rowCount = this.tableAssigned.getRowCount();
                    int i2 = 0;
                    while (i2 < rowCount) {
                        this.tableModelAssigned.removeRow(this.tableAssigned.convertRowIndexToModel(0));
                        ++i2;
                    }
                    for (RoutingObject routingObject : routingObjects) {
                        this.tableModelAssigned.addRow(routingObject);
                    }
                }
            }
            catch (Exception e) {
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -2;
            }
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        this.syncTables();
        return 0;
    }

    private void syncTables() {
        List<RoutingObject> routingObjects = this.tableModelAssigned.getRoutingObjects();
        for (RoutingObject routingObject : routingObjects) {
            this.tableModelReceived.removeRoutingObject(routingObject);
        }
    }

    private int exportBin() {
        File file = this.getFile(Messages.getString("BierConfiguratorDialog.17"), false, new FileNameExtensionFilter("*.bin", "bin"));
        if (file == null) {
            return -1;
        }
        FileOutputStream fileOutputStream = null;
        FilterOutputStream dataOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                dataOutputStream = new DataOutputStream(fileOutputStream);
                ((DataOutputStream)dataOutputStream).writeLong(4776425099556245062L);
                ((DataOutputStream)dataOutputStream).writeLong(5280282899886919506L);
                ((DataOutputStream)dataOutputStream).writeLong(this.bap.getId());
                ((DataOutputStream)dataOutputStream).writeInt(this.routingObjects.size());
                for (RoutingObject routingObject : this.routingObjects) {
                    ((DataOutputStream)dataOutputStream).writeLong(routingObject.getOwnID());
                    ((DataOutputStream)dataOutputStream).writeLong(routingObject.getForeignID());
                    ((DataOutputStream)dataOutputStream).writeInt(routingObject.getType());
                    Tools.writeString((DataOutputStream)dataOutputStream, routingObject.getDescription());
                    Tools.writeData((DataOutputStream)dataOutputStream, routingObject.getLastLearnMessage());
                }
            }
            catch (Exception e) {
                try {
                    dataOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -2;
            }
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private int exportText() {
        File file = this.getFile(Messages.getString("BierConfiguratorDialog.17"), false, new FileNameExtensionFilter("*.txt", "txt"));
        if (file == null) {
            return -1;
        }
        OutputStreamWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(file);
                SimpleDateFormat formater = new SimpleDateFormat();
                fileWriter.write(String.format(Messages.getString("BierConfiguratorDialog.43"), formater.format(new Date(System.currentTimeMillis()))));
                if (this.routingObjects == null || this.routingObjects.size() == 0) {
                    fileWriter.write(Messages.getString("BierConfiguratorDialog.44"));
                } else {
                    int i = 0;
                    while (i < this.routingObjects.size()) {
                        RoutingObject routingObject = this.routingObjects.get(i);
                        fileWriter.write(String.format(Messages.getString("BierConfiguratorDialog.45"), i));
                        fileWriter.write(String.format(Messages.getString("BierConfiguratorDialog.46"), this.getType(routingObject.getType())));
                        fileWriter.write(String.format(Messages.getString("BierConfiguratorDialog.47"), routingObject.getOwnID(), routingObject.getOwnID()));
                        fileWriter.write(String.format(Messages.getString("BierConfiguratorDialog.48"), routingObject.getForeignID(), routingObject.getForeignID()));
                        String text = routingObject.getDescription();
                        text = text == null ? "" : text;
                        fileWriter.write(String.format(Messages.getString("BierConfiguratorDialog.49"), text));
                        byte[] lastLearnMessage = routingObject.getLastLearnMessage();
                        text = lastLearnMessage == null || lastLearnMessage.length == 0 ? Messages.getString("BierConfiguratorDialog.7") : Tools.toHexString(lastLearnMessage);
                        fileWriter.write(String.format(Messages.getString("BierConfiguratorDialog.11"), text));
                        fileWriter.write(10);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                try {
                    fileWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -2;
            }
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private String getType(int type) {
        switch (type) {
            case 2: {
                return Messages.getString("BierConfiguratorDialog.50");
            }
            case 3: {
                return Messages.getString("BierConfiguratorDialog.105");
            }
            case 4: {
                return Messages.getString("BierConfiguratorDialog.107");
            }
            case 1: {
                return Messages.getString("BierConfiguratorDialog.101");
            }
        }
        return Messages.getString("BierConfiguratorDialog.54");
    }

    private void sendRoutingTable(final boolean close) {
        SwingWorker<Void, Integer> task = new SwingWorker<Void, Integer>(){

            @Override
            protected Void doInBackground() {
                RandomArrayStream stream = new RandomArrayStream();
                this.firePropertyChange("progressInfo", null, Messages.getString("BierConfiguratorDialog.56"));
                this.firePropertyChange("indeterminate", null, true);
                try {
                    stream.seek(0);
                    stream.trim();
                    stream.writeInt(BierConfiguratorDialog.this.routingObjects.size());
                    for (RoutingObject routingObject : BierConfiguratorDialog.this.routingObjects) {
                        routingObject.setLocked(true);
                        stream.writeLong(routingObject.getOwnID());
                        stream.writeLong(routingObject.getForeignID());
                        stream.writeInt(routingObject.getType());
                        stream.writeInt(routingObject.getDescription() == null ? 0 : routingObject.getDescription().length());
                        stream.writeString(routingObject.getDescription());
                        stream.writeInt(routingObject.getLastLearnMessage() == null ? 0 : routingObject.getLastLearnMessage().length);
                        stream.write(routingObject.getLastLearnMessage());
                    }
                    IBAPFinder.IMessage message = BierConfiguratorDialog.this.api.sendToConfigPort(BierConfiguratorDialog.this.api.getSelectedBAP().getIp(), 11, stream, true, 180000);
                    if (message.getMessageType() != 1) {
                        throw new PluginException(1);
                    }
                    if (message.getDataType() != 6) {
                        throw new PluginException(1);
                    }
                    stream = message.getData();
                    if (!stream.readBoolean()) {
                        throw new PluginException(1);
                    }
                    if (close) {
                        BierConfiguratorDialog.this.setConfigMode(false);
                        BierConfiguratorDialog.this.timer.stop();
                        BierConfiguratorDialog.this.dispose();
                    }
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(BierConfiguratorDialog.this, Messages.getString("BierConfiguratorDialog.58"), Messages.getString("BierConfiguratorDialog.2"), 0);
                        }
                    });
                    e.printStackTrace();
                    return null;
                }
                BierConfiguratorDialog.this.routingChanged = false;
                return null;
            }
        };
        ProgressDialog<Void, Integer> progressDialog = new ProgressDialog<Void, Integer>((Window)this.api.getFrame(), Messages.getString("BierConfiguratorDialog.2"), task, false);
        progressDialog.setImage(this.plugin.loadImage("router.png"));
        task.execute();
    }

    private void setConfigMode(final boolean configMode) {
        SwingWorker<Void, Integer> task = new SwingWorker<Void, Integer>(){

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            protected Void doInBackground() {
                RandomArrayStream stream = new RandomArrayStream();
                this.firePropertyChange("progressInfo", null, String.valueOf(Messages.getString("BierConfiguratorDialog.63")) + (configMode ? Messages.getString("BierConfiguratorDialog.64") : Messages.getString("BierConfiguratorDialog.65")) + " ...");
                this.firePropertyChange("indeterminate", null, true);
                try {
                    IBAPFinder.IMessage message;
                    if (configMode) {
                        stream.seek(0);
                        stream.trim();
                        stream.writeInt(4);
                        message = BierConfiguratorDialog.this.api.sendToConfigPort(BierConfiguratorDialog.this.api.getSelectedBAP().getIp(), 3, stream, true, 180000);
                        if (message.getMessageType() != 1) {
                            throw new PluginException(1);
                        }
                        if (message.getDataType() != 5) {
                            throw new PluginException(1);
                        }
                        stream = message.getData();
                        if (stream.readInt() != 4) {
                            throw new PluginException(1);
                        }
                        int count = stream.readInt();
                        BierConfiguratorDialog.this.tableModelAssigned.clear();
                        int i = 0;
                        while (i < count) {
                            long ownID = stream.readLong();
                            long foreignID = stream.readLong();
                            int type = stream.readInt();
                            String description = stream.readString(stream.readInt());
                            byte[] lastLearnMessage = stream.readData(stream.readInt());
                            RoutingObject routingObject = new RoutingObject(ownID, foreignID, type, description, false, System.currentTimeMillis(), lastLearnMessage);
                            BierConfiguratorDialog.this.tableModelAssigned.addRow(routingObject);
                            ++i;
                        }
                        if (BierConfiguratorDialog.this.messageListener == null) {
                            BierConfiguratorDialog.this.messageListener = new MessageListener(2000);
                        }
                        if (!BierConfiguratorDialog.this.messageListener.start()) {
                            return null;
                        }
                    } else if (BierConfiguratorDialog.this.messageListener != null) {
                        BierConfiguratorDialog.this.messageListener.stop();
                    }
                    stream.seek(0);
                    stream.trim();
                    stream.writeInt(3);
                    stream.writeBoolean(configMode);
                    message = BierConfiguratorDialog.this.api.sendToConfigPort(BierConfiguratorDialog.this.api.getSelectedBAP().getIp(), 1, stream, true, 5000);
                    if (message.getMessageType() != 1) {
                        throw new PluginException(1);
                    }
                    if (message.getDataType() != 6) {
                        throw new PluginException(1);
                    }
                    boolean result = message.getData().readBoolean();
                    if (result != configMode) {
                        throw new PluginException(2);
                    }
                    BierConfiguratorDialog.this.configMode = result;
                }
                catch (Exception e) {
                    return null;
                }
                return null;
            }
        };
        ProgressDialog<Void, Integer> progressDialog = new ProgressDialog<Void, Integer>((Window)this.api.getFrame(), Messages.getString("BierConfiguratorDialog.2"), (SwingWorker)task, false){
            private static final long serialVersionUID = 6063100063850518844L;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingWorker.StateValue value;
                super.propertyChange(evt);
                String property = evt.getPropertyName();
                if (property.equals("state") && (value = (SwingWorker.StateValue)((Object)evt.getNewValue())) == SwingWorker.StateValue.DONE) {
                    if (configMode != BierConfiguratorDialog.this.configMode) {
                        JOptionPane.showMessageDialog(BierConfiguratorDialog.this.api.getFrame(), Messages.getString("BierConfiguratorDialog.70"), Messages.getString("BierConfiguratorDialog.2"), 0);
                        if (BierConfiguratorDialog.this.messageListener != null) {
                            BierConfiguratorDialog.this.messageListener.stop();
                        }
                        return;
                    }
                    if (configMode) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BierConfiguratorDialog.this.setVisible(true);
                            }
                        });
                    }
                }
            }
        };
        progressDialog.setImage(this.plugin.loadImage("router.png"));
        task.execute();
    }

    private long getNewID() {
        long id = 0L;
        ArrayList<RoutingObject> routingObjects = new ArrayList<RoutingObject>(this.routingObjects);
        Collections.sort(routingObjects, new Comparator<RoutingObject>(){

            @Override
            public int compare(RoutingObject o1, RoutingObject o2) {
                return new Long(o1.getForeignID()).compareTo(new Long(o2.getForeignID()));
            }
        });
        for (RoutingObject routingObject : routingObjects) {
            if (routingObject.getForeignID() - 126L == this.bap.getId()) {
                return -1L;
            }
            if (routingObject.getForeignID() - this.bap.getId() != id) break;
            ++id;
        }
        return this.bap.getId() + id;
    }

    private void messageReceived(BAPMessage message) {
        if (message.getHeaderID() != 0) {
            return;
        }
        RoutingObject routingObject = this.tableModelAssigned.getRoutingObjectOwnID(message.getObjectID());
        if (routingObject != null && this.messageListener != null) {
            this.messageListener.learn(routingObject);
        } else {
            routingObject = this.tableModelReceived.getRoutingObjectOwnID(message.getObjectID());
            if (routingObject != null) {
                routingObject.setLastLearnMessage(message.getMessage());
            }
        }
        if (routingObject == null) {
            int type = this.getType(message);
            this.tableModelReceived.addRow(new RoutingObject(message.getObjectID(), 0L, type, "", true, System.currentTimeMillis(), message.getMessage()));
        } else {
            routingObject.setHighlight(true);
            routingObject.setTimestamp(System.currentTimeMillis());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BierConfiguratorDialog.this.tableAssigned.repaint();
                    BierConfiguratorDialog.this.tableReceived.repaint();
                }
            });
        }
    }

    private int getType(BAPMessage message) {
        if (message.getOrgByte() == 5) {
            int buttonsOrStatus = BAPMessage.readBits((byte)message.getByte3(), 0, 3);
            boolean type1Telegram = BAPMessage.readBits((byte)message.getStatus(), 2, 1) == 0;
            int byte3 = message.getByte3();
            if (!type1Telegram && buttonsOrStatus > 3 && byte3 != 254 && byte3 != 255) {
                return 2;
            }
            return 1;
        }
        if (message.getOrgByte() == 6) {
            return 3;
        }
        if (message.getOrgByte() == 7) {
            return 4;
        }
        return 0;
    }

    private JWizardHeader getWizardHeader() {
        if (this.wizardHeader == null) {
            this.wizardHeader = new JWizardHeader();
            this.wizardHeader.setImage(this.plugin.loadImage("router.png"));
            this.wizardHeader.setTextHeader1(Messages.getString("BierConfiguratorDialog.2"));
            this.wizardHeader.setTextHeader2(Messages.getString("BierConfiguratorDialog.76"));
        }
        return this.wizardHeader;
    }

    private JPanel getPanelSettings() {
        if (this.panelSettings == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 4;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridx = 0;
            this.panelSettings = new JPanel();
            this.panelSettings.setLayout(new GridBagLayout());
            this.panelSettings.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelSettings.add((Component)this.getPanelFilterAssigned(), gridBagConstraints7);
            this.panelSettings.add((Component)this.getScrollPaneAssigned(), gridBagConstraints4);
            this.panelSettings.add((Component)this.getPanelAssignButtons(), gridBagConstraints5);
            this.panelSettings.add((Component)this.getPanelFilterReceived(), gridBagConstraints8);
            this.panelSettings.add((Component)this.getScrollPaneReceived(), gridBagConstraints6);
        }
        return this.panelSettings;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints10.gridy = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 3;
            gridBagConstraints9.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints9.weightx = 0.0;
            gridBagConstraints9.anchor = 13;
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = 4;
            gridBagConstraints3.weightx = 0.0;
            this.panelButtons = new JPanel();
            this.panelButtons.setLayout(new GridBagLayout());
            this.panelButtons.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelButtons.add((Component)this.getButtonExit(), gridBagConstraints3);
            this.panelButtons.add((Component)this.getButtonSend(), gridBagConstraints9);
            this.panelButtons.add((Component)this.getButtonExport(), gridBagConstraints10);
            this.panelButtons.add((Component)this.getButtonImport(), gridBagConstraints11);
        }
        return this.panelButtons;
    }

    private JButton getButtonExit() {
        if (this.buttonExit == null) {
            this.buttonExit = new JButton();
            this.buttonExit.setText(Messages.getString("BierConfiguratorDialog.77"));
            this.buttonExit.setPreferredSize(new Dimension(100, 24));
            this.buttonExit.setMaximumSize(new Dimension(100, 24));
            this.buttonExit.setMinimumSize(new Dimension(100, 24));
            this.buttonExit.setActionCommand("exit");
            this.buttonExit.addActionListener(this);
        }
        return this.buttonExit;
    }

    private JButton getButtonSend() {
        if (this.buttonSend == null) {
            this.buttonSend = new JButton();
            this.buttonSend.setText(Messages.getString("BierConfiguratorDialog.79"));
            this.buttonSend.setPreferredSize(new Dimension(100, 24));
            this.buttonSend.setMaximumSize(new Dimension(100, 24));
            this.buttonSend.setMinimumSize(new Dimension(100, 24));
            this.buttonSend.setActionCommand("send");
            this.buttonSend.addActionListener(this);
        }
        return this.buttonSend;
    }

    private JButton getButtonExport() {
        if (this.buttonExport == null) {
            this.buttonExport = new JButton();
            this.buttonExport.setText(Messages.getString("BierConfiguratorDialog.17"));
            this.buttonExport.setPreferredSize(new Dimension(100, 24));
            this.buttonExport.setMaximumSize(new Dimension(100, 24));
            this.buttonExport.setMinimumSize(new Dimension(100, 24));
            this.buttonExport.setActionCommand("export");
            this.buttonExport.addActionListener(this);
        }
        return this.buttonExport;
    }

    private JButton getButtonImport() {
        if (this.buttonImport == null) {
            this.buttonImport = new JButton();
            this.buttonImport.setText(Messages.getString("BierConfiguratorDialog.24"));
            this.buttonImport.setPreferredSize(new Dimension(100, 24));
            this.buttonImport.setMaximumSize(new Dimension(100, 24));
            this.buttonImport.setMinimumSize(new Dimension(100, 24));
            this.buttonImport.setActionCommand("import");
            this.buttonImport.addActionListener(this);
        }
        return this.buttonImport;
    }

    private JScrollPane getScrollPaneAssigned() {
        if (this.scrollPaneAssigned == null) {
            this.scrollPaneAssigned = new JScrollPane();
            this.scrollPaneAssigned.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BierConfiguratorDialog.85"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.scrollPaneAssigned.setViewportView(this.getTableAssigned());
        }
        return this.scrollPaneAssigned;
    }

    private JTable getTableAssigned() {
        if (this.tableAssigned == null) {
            this.tableModelAssigned = new TableModelAssigned(this.routingObjects);
            this.tableSorterAssigned = new TableRowSorter<TableModelAssigned>(this.tableModelAssigned);
            this.tableRendererAssigned = new TableCellRendererAssigned();
            this.tableEditorAssigned = new TableCellEditorAssigned();
            this.tableAssigned = new JTable(this.tableModelAssigned){
                private static final long serialVersionUID = 5075702858945995985L;

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    return BierConfiguratorDialog.this.tableRendererAssigned;
                }

                @Override
                public TableCellEditor getCellEditor(int row, int column) {
                    return BierConfiguratorDialog.this.tableEditorAssigned;
                }
            };
            this.tableAssigned.setSelectionMode(2);
            this.tableAssigned.setRowHeight(25);
            this.tableAssigned.getTableHeader().setReorderingAllowed(false);
            this.tableAssigned.setRowSorter(this.tableSorterAssigned);
        }
        return this.tableAssigned;
    }

    private JPanel getPanelAssignButtons() {
        if (this.panelAssignButtons == null) {
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.insets = new Insets(5, 5, 5, 0);
            gridBagConstraints16.gridy = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 0);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.weightx = 0.0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 0);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 3;
            gridBagConstraints9.weightx = 0.0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(5, 5, 5, 0);
            this.panelAssignButtons = new JPanel();
            this.panelAssignButtons.setLayout(new GridBagLayout());
            this.panelAssignButtons.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder(1)));
            this.panelAssignButtons.add((Component)this.getButtonAssign(), gridBagConstraints8);
            this.panelAssignButtons.add((Component)this.getButtonRemove(), gridBagConstraints7);
            this.panelAssignButtons.add((Component)this.getButtonAssignManual(), gridBagConstraints16);
            this.panelAssignButtons.add((Component)this.getButtonDelete(), gridBagConstraints9);
        }
        return this.panelAssignButtons;
    }

    private JScrollPane getScrollPaneReceived() {
        if (this.scrollPaneReceived == null) {
            this.scrollPaneReceived = new JScrollPane();
            this.scrollPaneReceived.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BierConfiguratorDialog.87"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.scrollPaneReceived.setViewportView(this.getTableReceived());
        }
        return this.scrollPaneReceived;
    }

    private JTable getTableReceived() {
        if (this.tableReceived == null) {
            this.tableModelReceived = new TableModelReceived(new ArrayList<RoutingObject>());
            this.tableSorterReceived = new TableRowSorter<TableModelReceived>(this.tableModelReceived);
            this.tableRendererReceived = new TableCellRendererReceived();
            this.tableReceived = new JTable(this.tableModelReceived){
                private static final long serialVersionUID = -2906731298639576069L;

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    return BierConfiguratorDialog.this.tableRendererReceived;
                }
            };
            this.tableReceived.setSelectionMode(2);
            this.tableReceived.setRowHeight(25);
            this.tableReceived.getTableHeader().setReorderingAllowed(false);
            this.tableReceived.setRowSorter(this.tableSorterReceived);
        }
        return this.tableReceived;
    }

    private JButton getButtonAssign() {
        if (this.buttonAssign == null) {
            this.buttonAssign = new JButton();
            this.buttonAssign.setIcon(new ImageIcon(this.plugin.loadImage("uparrow.png")));
            this.buttonAssign.setPreferredSize(new Dimension(32, 32));
            this.buttonAssign.setActionCommand("assign");
            this.buttonAssign.addActionListener(this);
        }
        return this.buttonAssign;
    }

    private JButton getButtonAssignManual() {
        if (this.buttonAssignManual == null) {
            this.buttonAssignManual = new JButton();
            this.buttonAssignManual.setIcon(new ImageIcon(this.plugin.loadImage("uparrow_manual.png")));
            this.buttonAssignManual.setPreferredSize(new Dimension(32, 32));
            this.buttonAssignManual.setActionCommand("assign_manual");
            this.buttonAssignManual.addActionListener(this);
        }
        return this.buttonAssignManual;
    }

    private JButton getButtonDelete() {
        if (this.buttonDelete == null) {
            this.buttonDelete = new JButton();
            this.buttonDelete.setIcon(new ImageIcon(this.plugin.loadImage("trash.png")));
            this.buttonDelete.setPreferredSize(new Dimension(32, 32));
            this.buttonDelete.setActionCommand("delete");
            this.buttonDelete.addActionListener(this);
        }
        return this.buttonDelete;
    }

    private JButton getButtonRemove() {
        if (this.buttonRemove == null) {
            this.buttonRemove = new JButton();
            this.buttonRemove.setIcon(new ImageIcon(this.plugin.loadImage("downarrow.png")));
            this.buttonRemove.setPreferredSize(new Dimension(32, 32));
            this.buttonRemove.setActionCommand("remove");
            this.buttonRemove.addActionListener(this);
        }
        return this.buttonRemove;
    }

    private JComboBox getComboBoxFilterAssigned() {
        if (this.comboBoxFilterAssigned == null) {
            this.comboBoxFilterAssigned = new JComboBox();
            this.comboBoxFilterAssigned.setRenderer(new FilterCellRenderer());
            this.comboBoxFilterAssigned.setMinimumSize(new Dimension(36, 30));
            this.comboBoxFilterAssigned.setActionCommand("filter_assigned");
            int i = -1;
            while (i < 5) {
                this.comboBoxFilterAssigned.addItem(i);
                ++i;
            }
            this.comboBoxFilterAssigned.addActionListener(this);
        }
        return this.comboBoxFilterAssigned;
    }

    private JPanel getPanelFilterAssigned() {
        if (this.panelFilterAssigned == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridy = 0;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 0.0;
            gridBagConstraints12.gridx = 0;
            this.panelFilterAssigned = new JPanel();
            this.panelFilterAssigned.setLayout(new GridBagLayout());
            this.panelFilterAssigned.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BierConfiguratorDialog.0"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelFilterAssigned.add((Component)this.getComboBoxFilterAssigned(), gridBagConstraints12);
        }
        return this.panelFilterAssigned;
    }

    private JPanel getPanelFilterReceived() {
        if (this.panelFilterReceived == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.gridx = 0;
            this.panelFilterReceived = new JPanel();
            this.panelFilterReceived.setLayout(new GridBagLayout());
            this.panelFilterReceived.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BierConfiguratorDialog.0"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelFilterReceived.add((Component)this.getComboBoxFilterRecevied(), gridBagConstraints15);
        }
        return this.panelFilterReceived;
    }

    private JComboBox getComboBoxFilterRecevied() {
        if (this.comboBoxFilterRecevied == null) {
            this.comboBoxFilterRecevied = new JComboBox();
            this.comboBoxFilterRecevied.setRenderer(new FilterCellRenderer());
            this.comboBoxFilterRecevied.setMinimumSize(new Dimension(36, 30));
            this.comboBoxFilterRecevied.setActionCommand("filter_received");
            int i = -1;
            while (i < 5) {
                this.comboBoxFilterRecevied.addItem(i);
                ++i;
            }
            this.comboBoxFilterRecevied.addActionListener(this);
        }
        return this.comboBoxFilterRecevied;
    }

    static /* synthetic */ void access$1(BierConfiguratorDialog bierConfiguratorDialog, BAPMessage bAPMessage) {
        bierConfiguratorDialog.messageReceived(bAPMessage);
    }

    private class FilterCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private FilterCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Integer) {
                JLabel label = (JLabel)component;
                int filterType = (Integer)value;
                switch (filterType) {
                    case -1: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("filter_remove.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.12"));
                        break;
                    }
                    case 1: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("schakt.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.101"));
                        break;
                    }
                    case 2: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("gakt.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.103"));
                        break;
                    }
                    case 3: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("reed.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.105"));
                        break;
                    }
                    case 4: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("sensoren.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.107"));
                        break;
                    }
                    default: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("unknown.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.109"));
                    }
                }
            }
            return component;
        }
    }

    private class IconRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = -1270832269529173756L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)BierConfiguratorDialog.this.tableAssigned.getTableHeader().getDefaultRenderer();
            Component component = renderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            String path = (String)obj;
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                Icon icon = label.getIcon();
                if (icon != null) {
                    int width = icon.getIconWidth() + 16;
                    int height = Math.max(icon.getIconHeight(), 16);
                    BufferedImage imageHeader = BierConfiguratorDialog.this.plugin.loadImage(path);
                    BufferedImage image = new BufferedImage(width, height, 2);
                    Graphics2D g2 = (Graphics2D)image.getGraphics();
                    g2.drawImage((Image)imageHeader, 0, 0, null);
                    icon.paintIcon(null, g2, 16, (image.getHeight() - icon.getIconHeight()) / 2);
                    g2.dispose();
                    label.setIcon(new ImageIcon(image));
                } else {
                    label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage(path)));
                }
                label.setText(null);
            }
            return component;
        }
    }

    private class MessageListener {
        private ServerSocket serverSocket;
        private Socket socket;
        private int port;
        private Thread serverThread;
        private boolean connected = false;
        private DataInputStream dataInputStream;
        private DataOutputStream dataOutputStream;

        public MessageListener(int port) {
            this.port = port;
        }

        public boolean start() {
            if (this.connected) {
                return true;
            }
            if (this.serverThread == null || !this.serverThread.isAlive()) {
                this.serverThread = new Thread(this.getRunnable());
                this.serverThread.start();
            }
            this.connected = true;
            return true;
        }

        public void stop() {
            this.connected = false;
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void learn(RoutingObject routingObject) {
            if (BierConfiguratorDialog.this.bap.hasFeature(64L)) {
                System.err.println("learn() --> ESP3 not supported.");
                return;
            }
            long id = routingObject.getForeignID();
            byte[] data = new byte[routingObject.getLastLearnMessage().length];
            System.arraycopy(routingObject.getLastLearnMessage(), 0, data, 0, data.length);
            data[2] = 107;
            data[8] = (byte)(id >> 24);
            data[9] = (byte)(id >> 16);
            data[10] = (byte)(id >> 8);
            data[11] = (byte)id;
            data[12] = (byte)(data[12] & 0xF0);
            data[13] = Tools.getChecksumESP2(data);
            this.sendMessage(2, data);
        }

        private void sendMessage(int messageType, byte[] data) {
            try {
                this.dataOutputStream.writeInt(messageType);
                Tools.writeData(this.dataOutputStream, data);
                this.dataOutputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private Runnable getRunnable() {
            return new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        MessageListener.access$1(MessageListener.this, new ServerSocket(MessageListener.access$0(MessageListener.this)));
                        MessageListener.access$3(MessageListener.this, MessageListener.access$2(MessageListener.this).accept());
                        MessageListener.access$5(MessageListener.this, new DataInputStream(MessageListener.access$4(MessageListener.this).getInputStream()));
                        MessageListener.access$6(MessageListener.this, new DataOutputStream(MessageListener.access$4(MessageListener.this).getOutputStream()));
                        if (true) ** GOTO lbl42
                    }
                    catch (IOException e) {
                        try {
                            MessageListener.access$2(MessageListener.this).close();
                        }
                        catch (Exception var2_5) {
                            // empty catch block
                        }
                        try {
                            MessageListener.access$4(MessageListener.this).close();
                        }
                        catch (Exception var2_6) {
                            // empty catch block
                        }
                        MessageListener.access$7(MessageListener.this, false);
                        return;
                    }
                    do {
                        try {
                            messageType = MessageListener.access$9(MessageListener.this).readInt();
                            length = MessageListener.access$9(MessageListener.this).readInt();
                            data = new byte[length];
                            MessageListener.access$9(MessageListener.this).readFully(data);
                            if (messageType != 2) continue;
                            bin = new ByteArrayInputStream(data);
                            din = new DataInputStream(bin);
                            dataLength = din.readInt();
                            messageData = new byte[dataLength];
                            din.read(messageData);
                            message = new BAPMessage(TCMPacket.readTCMPacket(messageData), 0L);
                            BierConfiguratorDialog.access$1(MessageListener.access$10(MessageListener.this), message);
                        }
                        catch (Exception e) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (Exception var2_9) {
                                // empty catch block
                            }
                        }
lbl42:
                        // 5 sources

                    } while (MessageListener.access$8(MessageListener.this));
                    MessageListener.access$7(MessageListener.this, false);
                }
            };
        }

        static /* synthetic */ int access$0(MessageListener messageListener) {
            return messageListener.port;
        }

        static /* synthetic */ void access$1(MessageListener messageListener, ServerSocket serverSocket) {
            messageListener.serverSocket = serverSocket;
        }

        static /* synthetic */ ServerSocket access$2(MessageListener messageListener) {
            return messageListener.serverSocket;
        }

        static /* synthetic */ void access$3(MessageListener messageListener, Socket socket) {
            messageListener.socket = socket;
        }

        static /* synthetic */ Socket access$4(MessageListener messageListener) {
            return messageListener.socket;
        }

        static /* synthetic */ void access$5(MessageListener messageListener, DataInputStream dataInputStream) {
            messageListener.dataInputStream = dataInputStream;
        }

        static /* synthetic */ void access$6(MessageListener messageListener, DataOutputStream dataOutputStream) {
            messageListener.dataOutputStream = dataOutputStream;
        }

        static /* synthetic */ void access$7(MessageListener messageListener, boolean bl) {
            messageListener.connected = bl;
        }

        static /* synthetic */ boolean access$8(MessageListener messageListener) {
            return messageListener.connected;
        }

        static /* synthetic */ DataInputStream access$9(MessageListener messageListener) {
            return messageListener.dataInputStream;
        }

        static /* synthetic */ BierConfiguratorDialog access$10(MessageListener messageListener) {
            return messageListener.BierConfiguratorDialog.this;
        }
    }

    private class TableCellEditorAssigned
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 9155128190866685550L;
        private FilterLimit filterLimit;
        private Filter_DEC_HEX filter_DEC_HEX;
        private JTextField textField = new JTextField();
        private JCheckBox checkBoxLocked;
        private JComboBox comboBoxType;
        private JButton buttonSend;
        private Object value;
        private int currentColumn;
        private RoutingObject routingObject;

        public TableCellEditorAssigned() {
            this.textField.addActionListener(this);
            this.checkBoxLocked = new JCheckBox();
            this.checkBoxLocked.addActionListener(this);
            this.checkBoxLocked.setHorizontalAlignment(0);
            this.comboBoxType = new JComboBox();
            this.comboBoxType.setRenderer(new TypeCellRenderer());
            int i = 0;
            while (i < 5) {
                this.comboBoxType.addItem(i);
                ++i;
            }
            this.comboBoxType.addActionListener(this);
            this.buttonSend = new JButton();
            this.buttonSend.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("send.png")));
            this.buttonSend.setHorizontalAlignment(0);
            this.buttonSend.addActionListener(this);
            this.filter_DEC_HEX = new Filter_DEC_HEX(this.textField);
            this.filterLimit = new FilterLimit(32);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComponent component;
            this.value = value;
            this.currentColumn = column;
            this.routingObject = BierConfiguratorDialog.this.tableModelAssigned.getRoutingObject(table.convertRowIndexToModel(row));
            switch (column) {
                case 0: {
                    this.comboBoxType.setSelectedItem(this.routingObject.getType());
                    component = this.comboBoxType;
                    break;
                }
                case 1: {
                    this.textField.setText(null);
                    this.textField.setDocument(this.filter_DEC_HEX);
                    this.textField.setText(String.valueOf(this.routingObject.getOwnID()));
                    component = this.textField;
                    break;
                }
                case 2: {
                    this.textField.setText(null);
                    this.textField.setDocument(this.filter_DEC_HEX);
                    this.textField.setText(String.valueOf(this.routingObject.getForeignID()));
                    component = this.textField;
                    break;
                }
                case 3: {
                    this.textField.setText(null);
                    this.textField.setDocument(this.filterLimit);
                    this.textField.setText(this.routingObject.getDescription());
                    component = this.textField;
                    break;
                }
                case 4: {
                    this.checkBoxLocked.setSelected(this.routingObject.isLocked());
                    component = this.checkBoxLocked;
                    break;
                }
                case 5: {
                    byte[] lastLearnMessage = (byte[])value;
                    if (lastLearnMessage == null || lastLearnMessage.length == 0) {
                        this.buttonSend.setEnabled(false);
                    } else {
                        this.buttonSend.setEnabled(true);
                    }
                    component = this.buttonSend;
                    break;
                }
                default: {
                    return null;
                }
            }
            ((Component)component).setFont(table.getFont());
            return component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = e.getSource();
            if (object == this.textField) {
                switch (this.currentColumn) {
                    case 1: {
                        long oldOwnID = (Long)this.value;
                        try {
                            long newOwnID = this.getNewID(this.textField.getText());
                            if (newOwnID == oldOwnID) {
                                this.fireEditingCanceled();
                                return;
                            }
                            if (BierConfiguratorDialog.this.tableModelAssigned.getRoutingObjectOwnID(newOwnID) != null) {
                                throw new Exception("OwnID exists");
                            }
                            if (BierConfiguratorDialog.this.tableModelReceived.getRoutingObjectOwnID(newOwnID) != null) {
                                throw new Exception("OwnID exists");
                            }
                            this.value = newOwnID;
                            break;
                        }
                        catch (Exception e1) {
                            Tools.flash(this.textField, Color.RED, 2);
                            return;
                        }
                    }
                    case 2: {
                        long oldForeignID = (Long)this.value;
                        try {
                            long newForeignID = this.getNewID(this.textField.getText());
                            if (newForeignID == oldForeignID) {
                                this.fireEditingCanceled();
                                return;
                            }
                            if (BierConfiguratorDialog.this.tableModelAssigned.getRoutingObjectForeignID(newForeignID) != null) {
                                throw new Exception("ForeignID exists");
                            }
                            if (newForeignID > BierConfiguratorDialog.this.bap.getId() + 127L || newForeignID < BierConfiguratorDialog.this.bap.getId()) {
                                throw new Exception("ForeignID not in range");
                            }
                            this.value = newForeignID;
                            break;
                        }
                        catch (Exception e1) {
                            Tools.flash(this.textField, Color.RED, 2);
                            return;
                        }
                    }
                    case 3: {
                        this.value = this.textField.getText();
                        System.out.println("value editor: " + this.value);
                        break;
                    }
                }
            } else if (object == this.buttonSend) {
                if (BierConfiguratorDialog.this.messageListener != null) {
                    BierConfiguratorDialog.this.messageListener.learn(this.routingObject);
                }
            } else if (object == this.comboBoxType) {
                int selectedIndex = this.comboBoxType.getSelectedIndex();
                this.value = selectedIndex == -1 ? 0 : selectedIndex;
            } else if (object == this.checkBoxLocked) {
                this.value = this.checkBoxLocked.isSelected();
            }
            this.stopCellEditing();
            this.fireEditingStopped();
        }

        private long getNewID(String text) throws NumberFormatException {
            long value = 0L;
            if (text.toLowerCase().startsWith("0x") ? text.length() > 2 && (value = Long.parseLong(text.substring(2), 16)) > 0xFFFFFFFFL : (value = Long.parseLong(text, 10)) > 0xFFFFFFFFL) {
                throw new NumberFormatException();
            }
            return value;
        }

        private class FilterLimit
        extends PlainDocument {
            private static final long serialVersionUID = -6026361004931042531L;
            private int limit;

            public FilterLimit(int limit) {
                this.limit = limit;
            }

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str == null) {
                    return;
                }
                if (this.getLength() + str.length() <= this.limit) {
                    super.insertString(offset, str, attr);
                }
            }
        }

        private class Filter_DEC_HEX
        extends PlainDocument {
            private static final long serialVersionUID = -975692186695030670L;
            private JTextField textField;

            public Filter_DEC_HEX(JTextField textField) {
                this.textField = textField;
            }

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str == null) {
                    return;
                }
                String newString = str.toLowerCase();
                String text = this.textField.getText().toLowerCase();
                String newText = String.valueOf(text) + newString;
                try {
                    TableCellEditorAssigned.this.getNewID(newText);
                }
                catch (Exception e) {
                    Tools.flash(this.textField, Color.RED, 2);
                    return;
                }
                super.insertString(offset, str, attr);
            }
        }
    }

    private class TableCellRendererAssigned
    implements TableCellRenderer {
        private static final long serialVersionUID = 7573662555473998354L;
        private JLabel label = new JLabel();
        private JCheckBox checkBoxLocked;
        private JComboBox comboBoxType;
        private JButton buttonSend;

        public TableCellRendererAssigned() {
            this.label.setOpaque(true);
            this.checkBoxLocked = new JCheckBox();
            this.checkBoxLocked.setHorizontalAlignment(0);
            this.comboBoxType = new JComboBox();
            this.comboBoxType.setOpaque(false);
            this.comboBoxType.setRenderer(new TypeCellRenderer());
            int i = 0;
            while (i < 5) {
                this.comboBoxType.addItem(i);
                ++i;
            }
            this.buttonSend = new JButton();
            this.buttonSend.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("send.png")));
            this.buttonSend.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foregroundColor;
            int modelRow = table.convertRowIndexToModel(row);
            JComponent component = this.label;
            RoutingObject routingObject = BierConfiguratorDialog.this.tableModelAssigned.getRoutingObject(modelRow);
            boolean highlight = routingObject.isHighlight() && routingObject.getTimestamp() + 1000L >= System.currentTimeMillis();
            String text = "";
            ImageIcon icon = null;
            if (column == 0) {
                int type = (Integer)value;
                if (table.getModel().isCellEditable(modelRow, column)) {
                    this.comboBoxType.setSelectedItem(type);
                    component = this.comboBoxType;
                } else {
                    switch (type) {
                        case 1: {
                            icon = new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("schakt.png"));
                            text = Messages.getString("BierConfiguratorDialog.101");
                            break;
                        }
                        case 2: {
                            icon = new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("gakt.png"));
                            text = Messages.getString("BierConfiguratorDialog.103");
                            break;
                        }
                        case 3: {
                            icon = new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("reed.png"));
                            text = Messages.getString("BierConfiguratorDialog.105");
                            break;
                        }
                        case 4: {
                            icon = new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("sensoren.png"));
                            text = Messages.getString("BierConfiguratorDialog.107");
                            break;
                        }
                        default: {
                            icon = new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("unknown.png"));
                            text = Messages.getString("BierConfiguratorDialog.109");
                        }
                    }
                    component = this.label;
                }
            } else if (column == 1) {
                long ownID = (Long)value;
                icon = null;
                text = String.valueOf(String.valueOf(ownID)) + " / 0x" + Tools.toHexString((int)ownID);
                component = this.label;
            } else if (column == 2) {
                long foreignID = (Long)value;
                icon = null;
                text = String.valueOf(String.valueOf(foreignID)) + " / 0x" + Tools.toHexString((int)foreignID);
                component = this.label;
            } else if (column == 3) {
                String description = (String)value;
                icon = null;
                text = description;
                component = this.label;
            } else if (column == 4) {
                boolean locked = (Boolean)value;
                icon = null;
                this.checkBoxLocked.setSelected(locked);
                this.checkBoxLocked.setEnabled(!locked);
                component = this.checkBoxLocked;
            } else if (column == 5) {
                byte[] lastLearnMessage = (byte[])value;
                if (lastLearnMessage == null || lastLearnMessage.length == 0) {
                    this.buttonSend.setEnabled(false);
                } else {
                    this.buttonSend.setEnabled(true);
                }
                component = this.buttonSend;
            }
            if (component == this.label) {
                this.label.setText(text);
                this.label.setIcon(icon);
            }
            Color color = foregroundColor = isSelected ? table.getSelectionForeground() : table.getForeground();
            Color backgroundColor = highlight ? new Color(-14336) : (isSelected ? table.getSelectionBackground() : (table.getModel().isCellEditable(modelRow, column) ? Color.WHITE : new Color(-2039584)));
            ((Component)component).setForeground(foregroundColor);
            ((Component)component).setBackground(backgroundColor);
            ((Component)component).setFont(table.getFont());
            return component;
        }
    }

    private class TableCellRendererReceived
    implements TableCellRenderer {
        private static final long serialVersionUID = 7573662555473998354L;
        private JLabel label = new JLabel();

        public TableCellRendererReceived() {
            this.label.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foregroundColor;
            boolean highlight;
            RoutingObject routingObject = BierConfiguratorDialog.this.tableModelReceived.getRoutingObject(table.convertRowIndexToModel(row));
            boolean bl = highlight = routingObject.isHighlight() && routingObject.getTimestamp() + 1000L >= System.currentTimeMillis();
            if (column == 0) {
                switch (routingObject.getType()) {
                    case 1: {
                        this.label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("schakt.png")));
                        this.label.setText(Messages.getString("BierConfiguratorDialog.101"));
                        break;
                    }
                    case 2: {
                        this.label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("gakt.png")));
                        this.label.setText(Messages.getString("BierConfiguratorDialog.103"));
                        break;
                    }
                    case 3: {
                        this.label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("reed.png")));
                        this.label.setText(Messages.getString("BierConfiguratorDialog.105"));
                        break;
                    }
                    case 4: {
                        this.label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("sensoren.png")));
                        this.label.setText(Messages.getString("BierConfiguratorDialog.107"));
                        break;
                    }
                    default: {
                        this.label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("unknown.png")));
                        this.label.setText(Messages.getString("BierConfiguratorDialog.109"));
                        break;
                    }
                }
            } else if (column == 1) {
                this.label.setIcon(null);
                this.label.setText(String.valueOf(String.valueOf(routingObject.getOwnID())) + " / 0x" + Tools.toHexString((int)routingObject.getOwnID()));
            }
            Color color = foregroundColor = isSelected ? table.getSelectionForeground() : table.getForeground();
            Color backgroundColor = highlight ? new Color(-14336) : (isSelected ? table.getSelectionBackground() : (table.getModel().isCellEditable(table.convertRowIndexToModel(row), column) ? Color.WHITE : new Color(-2039584)));
            this.label.setForeground(foregroundColor);
            this.label.setBackground(backgroundColor);
            this.label.setFont(table.getFont());
            return this.label;
        }
    }

    private class TableModelAssigned
    extends AbstractTableModel {
        private static final long serialVersionUID = 1670799670592776964L;
        private List<RoutingObject> routingObjects;

        public TableModelAssigned(List<RoutingObject> routingObjects) {
            this.routingObjects = routingObjects;
        }

        public List<RoutingObject> getRoutingObjects() {
            return this.routingObjects;
        }

        public void clear() {
            this.routingObjects.clear();
            this.fireTableStructureChanged();
        }

        public void removeRow(int modelRow) {
            this.routingObjects.remove(modelRow);
            this.fireTableRowsDeleted(modelRow, modelRow);
            if (this.routingObjects.size() == 0) {
                this.fireTableStructureChanged();
            }
        }

        public void addRow(RoutingObject routingObject) {
            this.routingObjects.add(routingObject);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
            if (this.routingObjects.size() == 1) {
                this.fireTableStructureChanged();
                TableColumn column = BierConfiguratorDialog.this.tableAssigned.getTableHeader().getColumnModel().getColumn(4);
                column.setMaxWidth(50);
                column.setHeaderRenderer(new IconRenderer());
                column = BierConfiguratorDialog.this.tableAssigned.getTableHeader().getColumnModel().getColumn(5);
                column.setMaxWidth(50);
                column.setHeaderRenderer(new IconRenderer());
            }
        }

        @Override
        public int getColumnCount() {
            return this.routingObjects.size() == 0 ? 1 : 6;
        }

        @Override
        public int getRowCount() {
            return this.routingObjects.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            RoutingObject routingObject = this.routingObjects.get(rowIndex);
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    return !routingObject.isLocked();
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return !routingObject.isLocked();
                }
                case 5: {
                    byte[] lastLearnMessage = routingObject.getLastLearnMessage();
                    return lastLearnMessage != null && lastLearnMessage.length > 0;
                }
            }
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RoutingObject routingObject = this.routingObjects.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return routingObject.getType();
                }
                case 1: {
                    return routingObject.getOwnID();
                }
                case 2: {
                    return routingObject.getForeignID();
                }
                case 3: {
                    return routingObject.getDescription();
                }
                case 4: {
                    return routingObject.isLocked();
                }
                case 5: {
                    return routingObject.getLastLearnMessage();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    if (this.routingObjects.size() == 0) {
                        return Messages.getString("BierConfiguratorDialog.94");
                    }
                    return Messages.getString("BierConfiguratorDialog.113");
                }
                case 1: {
                    return Messages.getString("BierConfiguratorDialog.114");
                }
                case 2: {
                    return Messages.getString("BierConfiguratorDialog.97");
                }
                case 3: {
                    return Messages.getString("BierConfiguratorDialog.98");
                }
                case 4: {
                    return "lock.png";
                }
                case 5: {
                    return "send16.png";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int argCol) {
            switch (argCol) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Long.class;
                }
                case 2: {
                    return Long.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 5: {
                    return byte[].class;
                }
            }
            return null;
        }

        public RoutingObject getRoutingObjectOwnID(long id) {
            for (RoutingObject routingObject : this.routingObjects) {
                if (routingObject.getOwnID() != id) continue;
                return routingObject;
            }
            return null;
        }

        public RoutingObject getRoutingObjectForeignID(long foreignID) {
            for (RoutingObject routingObject : this.routingObjects) {
                if (routingObject.getForeignID() != foreignID) continue;
                return routingObject;
            }
            return null;
        }

        public RoutingObject getRoutingObject(int row) {
            if (row < 0 || row >= this.routingObjects.size()) {
                return null;
            }
            return this.routingObjects.get(row);
        }

        @Override
        public void setValueAt(Object argValue, int argRow, int argCol) {
            RoutingObject routingObject = this.routingObjects.get(argRow);
            if (argValue == null) {
                return;
            }
            switch (argCol) {
                case 0: {
                    routingObject.setType((Integer)argValue);
                    break;
                }
                case 1: {
                    routingObject.setOwnID((Long)argValue);
                    break;
                }
                case 2: {
                    routingObject.setForeignID((Long)argValue);
                    break;
                }
                case 3: {
                    System.out.println("==> " + (String)argValue);
                    routingObject.setDescription((String)argValue);
                    break;
                }
                case 4: {
                    routingObject.setLocked((Boolean)argValue);
                }
            }
            this.fireTableCellUpdated(argRow, argCol);
        }
    }

    private static class TableModelReceived
    extends AbstractTableModel {
        private static final long serialVersionUID = 1670799670592776964L;
        private List<RoutingObject> routingObjects;

        public TableModelReceived(List<RoutingObject> routingObjects) {
            this.routingObjects = routingObjects;
        }

        public void removeRoutingObject(RoutingObject routingObject) {
            RoutingObject thisRoutingObject = this.getRoutingObjectOwnID(routingObject.getOwnID());
            if (thisRoutingObject == null) {
                return;
            }
            int index = this.routingObjects.indexOf(thisRoutingObject);
            this.removeRow(index);
        }

        public void removeRow(int modelRow) {
            this.routingObjects.remove(modelRow);
            this.fireTableRowsDeleted(modelRow, modelRow);
            if (this.routingObjects.size() == 0) {
                this.fireTableStructureChanged();
            }
        }

        public void addRow(RoutingObject routingObject) {
            this.routingObjects.add(routingObject);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
            if (this.routingObjects.size() == 1) {
                this.fireTableStructureChanged();
            }
        }

        @Override
        public int getColumnCount() {
            return this.routingObjects.size() == 0 ? 1 : 2;
        }

        @Override
        public int getRowCount() {
            return this.routingObjects.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RoutingObject routingObject = this.routingObjects.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return routingObject.getType();
                }
                case 1: {
                    return routingObject.getOwnID();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    if (this.routingObjects.size() == 0) {
                        return Messages.getString("BierConfiguratorDialog.112");
                    }
                    return Messages.getString("BierConfiguratorDialog.113");
                }
                case 1: {
                    return Messages.getString("BierConfiguratorDialog.114");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int argCol) {
            switch (argCol) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Long.class;
                }
            }
            return null;
        }

        public RoutingObject getRoutingObjectOwnID(long ownID) {
            for (RoutingObject routingObject : this.routingObjects) {
                if (routingObject.getOwnID() != ownID) continue;
                return routingObject;
            }
            return null;
        }

        public RoutingObject getRoutingObject(int row) {
            if (row < 0 || row >= this.routingObjects.size()) {
                return null;
            }
            return this.routingObjects.get(row);
        }
    }

    private class TypeCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private TypeCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Integer) {
                JLabel label = (JLabel)component;
                int filterType = (Integer)value;
                switch (filterType) {
                    case 1: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("schakt.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.101"));
                        break;
                    }
                    case 2: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("gakt.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.103"));
                        break;
                    }
                    case 3: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("reed.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.105"));
                        break;
                    }
                    case 4: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("sensoren.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.107"));
                        break;
                    }
                    default: {
                        label.setIcon(new ImageIcon(BierConfiguratorDialog.this.plugin.loadImage("unknown.png")));
                        label.setText(Messages.getString("BierConfiguratorDialog.109"));
                    }
                }
            }
            return component;
        }
    }
}

