/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.PluginVersion;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;

public abstract class Plugin {
    private String imagePath;

    public Plugin() {
        String className = this.getClass().getName();
        String path = className.substring(0, className.lastIndexOf("." + this.getClass().getSimpleName()));
        this.imagePath = String.valueOf(path.replace('.', File.separatorChar)) + File.separator + "images" + File.separatorChar;
    }

    public BufferedImage loadImage(String name) {
        BufferedImage image = null;
        InputStream inputStream = null;
        name = String.valueOf(this.imagePath) + name;
        try {
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(name.replace('\\', '/'));
                if (inputStream == null) {
                    throw new Exception();
                }
                image = ImageIO.read(inputStream);
            }
            catch (Exception e) {
                try {
                    inputStream = new FileInputStream(new File(name));
                    image = ImageIO.read(inputStream);
                }
                catch (Exception e1) {
                    System.err.println("BAPFinder.loadImage() --> Error while loading image: " + e.getMessage());
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return image;
    }

    public abstract void initialize(IBAPFinder var1) throws PluginException;

    public abstract String getName();

    public abstract void selectedBAPChanged(IBAPFinder.IBAP var1);

    public abstract PluginVersion getVersion();

    public abstract PluginVersion neededAPIVersion();
}

