/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.localization;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class Messages {
    private static final String BUNDLE_PACKAGE = "de.bsc.bapfinder.localization";
    private static final String BUNDLE_NAME = "messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("de.bsc.bapfinder.localization.messages");

    private Messages() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static List<String> getAvailableLocales() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String bundlepackage = BUNDLE_PACKAGE;
        String bundlename = BUNDLE_NAME;
        File root = new File(loader.getResource(BUNDLE_PACKAGE.replace('.', '/')).getFile());
        File[] files = root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("^messages(_\\w{2}(_\\w{2})?)?\\.properties$");
            }
        });
        ArrayList<String> languages = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            languages.add(file.getName().replaceAll("^messages(_)?|\\.properties$", ""));
            ++n2;
        }
        return languages;
    }
}

