/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.components;

import de.bsc.bapfinder.components.JGradient;
import de.bsc.bapfinder.components.JImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JWizardHeader
extends JComponent {
    private static final long serialVersionUID = 1L;
    private JImage wizardImage = new JImage();
    private JLabel wizardLabel1 = new JLabel();
    private JLabel wizardLabel2 = new JLabel();
    private JGradient wizardGradient = new JGradient();
    private JPanel wizardPanel = new JPanel();
    private boolean center = false;

    public JWizardHeader() {
        this.wizardImage.setLocation(10, 7);
        this.wizardLabel1.setBounds(new Rectangle(59, 5, 36, 18));
        this.wizardLabel1.setHorizontalTextPosition(11);
        this.wizardLabel1.setHorizontalAlignment(2);
        this.wizardLabel1.setFont(new Font("Tahoma", 1, 11));
        this.wizardLabel1.setText("JWizardHeader");
        this.wizardLabel2.setBounds(new Rectangle(84, 25, 11, 14));
        this.wizardLabel2.setFont(new Font("Tahoma", 0, 11));
        this.wizardLabel2.setText("JWizardText");
        this.wizardGradient.setLocation(2, 44);
        this.wizardPanel.setLayout(null);
        this.wizardPanel.setBackground(Color.WHITE);
        this.wizardPanel.setPreferredSize(new Dimension(160, 54));
        this.wizardPanel.setMinimumSize(new Dimension(0, 54));
        this.wizardPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 54));
        this.wizardPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.wizardPanel.add(this.wizardImage);
        this.wizardPanel.add(this.wizardLabel1);
        this.wizardPanel.add(this.wizardLabel2);
        this.wizardPanel.add(this.wizardGradient);
        this.setPreferredSize(new Dimension(160, 54));
        this.setMinimumSize(new Dimension(0, 54));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 54));
        this.add(this.wizardPanel);
        this.validate();
        this.repaint();
    }

    public boolean isCenter() {
        return this.center;
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public Color getFromColor() {
        return this.wizardGradient.getFromColor();
    }

    public void setFromColor(Color fromColor) {
        this.wizardGradient.setFromColor(fromColor);
    }

    public Color getToColor() {
        return this.wizardGradient.getToColor();
    }

    public void setToColor(Color toColor) {
        this.wizardGradient.setToColor(toColor);
    }

    public Image getImage() {
        return this.wizardImage.getImage();
    }

    public void setImage(Image image) {
        this.wizardImage.setImage(image);
        this.setWizardLabelBounds();
    }

    public String getTextHeader1() {
        return this.wizardLabel1.getText();
    }

    private void setWizardLabelBounds() {
        int label1Width = this.wizardLabel1.getPreferredSize().width;
        int label2Width = this.wizardLabel2.getPreferredSize().width;
        int length = this.center ? label1Width : Math.max(label1Width, label2Width);
        int text1LabelX = this.getWidth() / 2 - length / 2 - (label2Width == 0 || this.center ? 0 : 25);
        text1LabelX = this.wizardImage.getImage() == null ? (text1LabelX < 5 ? 5 : text1LabelX) : (text1LabelX < 59 ? 59 : text1LabelX);
        int text2LabelX = this.getWidth() / 2 - (this.center ? label2Width : length) / 2 - (this.center ? 0 : 25);
        text2LabelX = this.wizardImage.getImage() == null ? (text2LabelX < 5 ? 5 : text2LabelX) : (text2LabelX < 59 ? 59 : text2LabelX);
        int width = label1Width >= label2Width ? text1LabelX + label1Width : text1LabelX + 35 + label2Width;
        this.wizardLabel1.setBounds(text1LabelX, 5, this.getWidth() - 64, 18);
        this.wizardLabel2.setBounds(this.center ? text2LabelX : this.wizardLabel1.getX() + 30, 25, this.getWidth() - 89, 14);
        this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
    }

    public void setTextHeader1(String text) {
        this.wizardLabel1.setText(text);
        this.setWizardLabelBounds();
    }

    public String getTextHeader2() {
        return this.wizardLabel2.getText();
    }

    public void setTextHeader2(String text) {
        this.wizardLabel2.setText(text);
        this.setWizardLabelBounds();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setWizardLabelBounds();
        this.wizardGradient.setBounds(2, this.getHeight() - 12, width - 4, 10);
        this.wizardPanel.setBounds(0, 0, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        int x = (int)r.getX();
        int y = (int)r.getY();
        int width = (int)r.getWidth();
        int height = (int)r.getHeight();
        super.setBounds(x, y, width, 54);
        this.setWizardLabelBounds();
        this.wizardGradient.setBounds(2, this.getHeight() - 12, width - 4, 10);
        this.wizardPanel.setBounds(0, 0, width, height);
    }

    @Override
    public void setSize(Dimension d) {
        int width = (int)d.getWidth();
        int height = (int)d.getHeight();
        super.setSize(width, 54);
        this.setWizardLabelBounds();
        this.wizardGradient.setBounds(2, this.getHeight() - 12, width - 4, 10);
        this.wizardPanel.setSize(width, height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setWizardLabelBounds();
        this.wizardGradient.setBounds(2, this.getHeight() - 12, width - 4, 10);
        this.wizardPanel.setSize(width, height);
    }

    @Override
    public void setBackground(Color bg) {
        this.wizardPanel.setBackground(bg);
    }

    @Override
    public Color getBackground() {
        return this.wizardPanel.getBackground();
    }

    public boolean isBorderRaised() {
        EtchedBorder border = (EtchedBorder)this.wizardPanel.getBorder();
        return border.getEtchType() == 0;
    }

    public void setBorderRaised(boolean borderRaised) {
        if (borderRaised) {
            this.wizardPanel.setBorder(BorderFactory.createEtchedBorder(0));
        } else {
            this.wizardPanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
    }
}

