/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder;

import de.bsc.bapfinder.BAP;
import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.LanguageSelection;
import de.bsc.bapfinder.components.JWizardHeader;
import de.bsc.bapfinder.localization.Messages;
import de.bsc.bapfinder.plugins.Plugin;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.tools.RandomArrayStream;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BAPFinder
extends JFrame
implements IBAPFinder,
ActionListener,
ListSelectionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int MESSAGE_CONFIGURATION = 2;
    private static final int MESSAGE_REQUEST_ANSWER = 5;
    private static final int REQUEST_CONFIGURATION = 1;
    private static final PluginVersion apiVersion = new PluginVersion(1, 0, 0, 0);
    private static NetworkInterface selectedInterface;
    private static BufferedImage image;
    private static String imagePath;
    private static Properties properties;
    private Thread broadcastThread;
    private Thread serverThreadUDP;
    private Thread serverThreadTCP;
    private boolean terminated;
    private JList listSelect;
    private IBAPFinder.IBAP selectedBap;
    private List<IBAPFinder.IBAPListener> listeners;
    private List<Plugin> plugins;
    private JTextField textFieldIP;
    private JTextField textFieldSubnet;
    private JTextField textFieldBoSeIP;
    private JTextField textFieldGateway;
    private JTextField textFieldHostname;
    private JCheckBox checkBoxDHCP;
    private JWizardHeader wizardHeader;
    private JScrollPane paneSelect;
    private JPanel panelBoSeIP;
    private JPanel panelDHCP;
    private JPanel panelIP;
    private JPanel panelSubnet;
    private JPanel panelGateway;
    private JPanel panelHostname;
    private JButton buttonCommit;
    private JPanel panelSettings;
    private JPanel jContentPane;
    private JPanel buttonPanel;
    private DefaultListModel listModel;
    private DefaultListModel sicherungsListe;
    private JSplitPane jSplitPane;
    private JPanel panelInterfaces;
    private JComboBox comboBoxInterfaces;
    private JPanel panelInterfacesInner;
    private JMenuBar menuBar = null;
    private JMenu menuFile;

    public BAPFinder() {
        imagePath = String.valueOf(this.getClass().getPackage().getName().replace('.', File.separatorChar)) + File.separator + "images" + File.separatorChar;
        image = BAPFinder.loadImage("bapkl.png");
        this.listeners = new ArrayList<IBAPFinder.IBAPListener>();
        this.plugins = new ArrayList<Plugin>();
        this.initialize();
        this.loadPlugins();
        this.initPlugins();
        this.terminated = false;
        this.broadcastThread = new Thread(this.getBroadcastThread());
        this.broadcastThread.start();
        this.serverThreadUDP = new Thread(this.getServerThreadUDP());
        this.serverThreadUDP.start();
        this.serverThreadTCP = new Thread(this.getServerThreadTCP());
        this.serverThreadTCP.start();
    }

    private void initPlugins() {
        for (Plugin plugin : this.plugins) {
            try {
                plugin.initialize(this);
                System.out.println("Plugin \"" + plugin.getName() + "\" initialized. Plugin version: " + plugin.getVersion());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadPlugins() {
        ArrayList classes = new ArrayList();
        try {
            classes.addAll(Tools.getClasses("de.bsc.bapfinder.plugins"));
            classes.addAll(Tools.getClassesFolder("plugins", "de.bsc.bapfinder.plugins"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (Class clazz : classes) {
            try {
                Class<Plugin> pluginClass = clazz.asSubclass(Plugin.class);
                Constructor<Plugin> constructor = pluginClass.getConstructor(new Class[0]);
                Plugin plugin = constructor.newInstance(new Object[0]);
                long neededAPIVersion = plugin.neededAPIVersion().getVersionWithoutBuild();
                if (neededAPIVersion > apiVersion.getVersionWithoutBuild()) continue;
                this.addPlugin(plugin);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addPlugin(Plugin plugin) {
        boolean found = false;
        int i = 0;
        while (i < this.plugins.size()) {
            Plugin storedPlugin = this.plugins.get(i);
            if (storedPlugin.getName().equals(plugin.getName())) {
                long versionGivenPlugin;
                found = true;
                long versionStoredPlugin = storedPlugin.getVersion().getVersionWithoutBuild();
                if (versionStoredPlugin != (versionGivenPlugin = plugin.getVersion().getVersionWithoutBuild())) {
                    System.err.println("Plugin \"" + plugin.getName() + "\" has a version conflict! Version stored: " + versionStoredPlugin + ", version new: " + versionGivenPlugin);
                } else {
                    System.err.println("Plugin \"" + plugin.getName() + "\" already added. The given plugin will be discarded.");
                }
                if (versionStoredPlugin < versionGivenPlugin) {
                    System.err.println("Stored plugin \"" + plugin.getName() + "\" is older and will be replaced with the new version.");
                    this.plugins.remove(i);
                    this.plugins.add(i, plugin);
                    break;
                }
                if (versionStoredPlugin <= versionGivenPlugin) break;
                System.err.println("Stored plugin \"" + plugin.getName() + "\" is newer. The given plugin will be discarded.");
                break;
            }
            ++i;
        }
        if (!found) {
            this.plugins.add(plugin);
        }
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("BAPFinder.16"));
        this.setIconImage(BAPFinder.loadImage("bapkl.png"));
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BAPFinder.this.terminated = true;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.windowClosing(e);
            }
        });
    }

    private Runnable getBroadcastThread() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress inetAddress = InetAddress.getByName("255.255.255.255");
                    byte[] buffer1 = new String("BAPREQUEST").getBytes();
                    DatagramPacket datagramPacket1 = new DatagramPacket(buffer1, buffer1.length);
                    byte[] byArray = new byte[24];
                    byArray[0] = 2;
                    byArray[1] = 3;
                    byArray[2] = 4;
                    byArray[3] = 5;
                    byArray[15] = 3;
                    byArray[19] = 4;
                    byArray[23] = 1;
                    byte[] buffer2 = byArray;
                    DatagramPacket datagramPacket2 = new DatagramPacket(buffer2, buffer2.length);
                    while (!BAPFinder.this.terminated) {
                        if (selectedInterface == null) {
                            Thread.sleep(500L);
                            continue;
                        }
                        Enumeration<InetAddress> addresses = selectedInterface.getInetAddresses();
                        if (!(selectedInterface.isLoopback() || selectedInterface.isVirtual() || selectedInterface.isPointToPoint())) {
                            while (addresses.hasMoreElements()) {
                                InetAddress adapterAddress = addresses.nextElement();
                                if (adapterAddress instanceof Inet6Address) continue;
                                DatagramSocket datagramSocket = new DatagramSocket(new InetSocketAddress(adapterAddress, 0));
                                datagramSocket.connect(inetAddress, 2006);
                                datagramSocket.send(datagramPacket1);
                                datagramSocket.send(datagramPacket2);
                                datagramSocket.close();
                            }
                        }
                        Thread.sleep(10000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BAPFinder.this.terminate();
                }
            }
        };
    }

    private static boolean broadcast(int messageType, byte[] data, long bapID) {
        if (selectedInterface == null) {
            return false;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(33752069);
            dataOutputStream.writeLong(bapID);
            dataOutputStream.writeInt(messageType);
            dataOutputStream.writeInt(data.length);
            dataOutputStream.write(data);
            data = byteArrayOutputStream.toByteArray();
            InetAddress inetAddress = InetAddress.getByName("255.255.255.255");
            DatagramPacket datagramPacket = new DatagramPacket(data, data.length, inetAddress, 2006);
            if (!selectedInterface.isLoopback() && !selectedInterface.isVirtual()) {
                Enumeration<InetAddress> addresses = selectedInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress adapterAddress = addresses.nextElement();
                    if (adapterAddress instanceof Inet6Address) continue;
                    DatagramSocket datagramSocket = new DatagramSocket(new InetSocketAddress(adapterAddress, 0));
                    datagramSocket.connect(inetAddress, 2006);
                    datagramSocket.send(datagramPacket);
                    datagramSocket.close();
                }
            }
            try {
                dataOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void terminate() {
        this.terminated = true;
    }

    private void addBAP(IBAPFinder.IBAP bap) {
        int i = 0;
        while (i < this.listModel.size()) {
            IBAPFinder.IBAP listBap = (IBAPFinder.IBAP)this.listModel.get(i);
            if (listBap.getId() == bap.getId()) {
                return;
            }
            ++i;
        }
        this.listModel.addElement(bap);
    }

    private Runnable getServerThreadTCP() {
        return new Runnable(){

            @Override
            public void run() {
                ServerSocket serverSocket = null;
                try {
                    serverSocket = new ServerSocket(2006, 1000);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    BAPFinder.this.terminate();
                }
                Socket socket = null;
                InputStream inputStream = null;
                OutputStream outputStream = null;
                while (!BAPFinder.this.terminated) {
                    try {
                        int character;
                        socket = serverSocket.accept();
                        inputStream = socket.getInputStream();
                        outputStream = socket.getOutputStream();
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((character = inputStream.read()) != -1) {
                            stringBuffer.append((char)character);
                        }
                        if (stringBuffer.indexOf("BAPANSWER") == -1) {
                            System.err.println("Received wrong answer. Received String: " + stringBuffer);
                            throw new Exception();
                        }
                        BAP bap = new BAP();
                        stringBuffer.delete(0, stringBuffer.indexOf("#") + 1);
                        if (stringBuffer.indexOf("#") == -1) {
                            bap.setId(Long.parseLong(stringBuffer.toString()));
                            bap.setMac(Messages.getString("BAPFinder.25"));
                            bap.setVersion(0L);
                        } else {
                            int breakpoints = 0;
                            int i = 0;
                            while (i < stringBuffer.length()) {
                                if (stringBuffer.charAt(i) == '#') {
                                    ++breakpoints;
                                }
                                ++i;
                            }
                            bap.setId(Long.parseLong(stringBuffer.substring(0, stringBuffer.indexOf("#"))));
                            stringBuffer.delete(0, stringBuffer.indexOf("#") + 1);
                            switch (breakpoints) {
                                case 1: {
                                    bap.setMac(stringBuffer.toString());
                                    bap.setVersion(0L);
                                    break;
                                }
                                case 2: {
                                    bap.setMac(stringBuffer.substring(0, stringBuffer.indexOf("#")));
                                    stringBuffer.delete(0, stringBuffer.indexOf("#") + 1);
                                    long version = Long.parseLong(stringBuffer.toString());
                                    if (version > 30000000L) {
                                        bap.setVersion(version - 10000000L);
                                        bap.setFeatures(bap.getFeatures() | 1L | 4L);
                                    } else {
                                        bap.setVersion(version);
                                    }
                                    if (bap.getVersion() < 20080702L) break;
                                    bap.setFeatures(bap.getFeatures() | 8L);
                                }
                            }
                        }
                        bap.setIp(socket.getInetAddress().getHostAddress());
                        BAPFinder.this.fireBAPReceived(bap);
                        outputStream.write(new String("OK").getBytes());
                        outputStream.flush();
                        outputStream.close();
                        inputStream.close();
                        socket.close();
                    }
                    catch (Exception e) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        };
    }

    private Runnable getServerThreadUDP() {
        return new Runnable(){

            @Override
            public void run() {
                DatagramSocket datagramSocket = null;
                byte[] buffer = new byte[1024];
                try {
                    datagramSocket = new DatagramSocket(2006);
                }
                catch (SocketException e2) {
                    System.exit(1);
                }
                while (!BAPFinder.this.terminated) {
                    try {
                        DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
                        datagramSocket.receive(datagramPacket);
                        byte[] receivedBytes = new byte[datagramPacket.getLength()];
                        System.arraycopy(datagramPacket.getData(), 0, receivedBytes, 0, datagramPacket.getLength());
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(receivedBytes);
                        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                        try {
                            try {
                                int sync = dataInputStream.readInt();
                                if (sync != 101124105) {
                                    throw new Exception("No BAP Message");
                                }
                                int messageType = dataInputStream.readInt();
                                if (messageType != 5) {
                                    throw new Exception("Only configurations are allowed");
                                }
                                int length = dataInputStream.readInt();
                                byte[] data = new byte[length];
                                dataInputStream.read(data);
                                try {
                                    dataInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    byteArrayInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                byteArrayInputStream = new ByteArrayInputStream(data);
                                dataInputStream = new DataInputStream(byteArrayInputStream);
                                BAP bap = new BAP();
                                messageType = dataInputStream.readInt();
                                if (messageType != 1) {
                                    throw new Exception("No answer to configuration request received");
                                }
                                bap.setIpv6(dataInputStream.readBoolean());
                                bap.setDhcp(dataInputStream.readBoolean());
                                bap.setServerIP(BAPFinder.recodeString(dataInputStream, dataInputStream.readInt()));
                                bap.setIp(BAPFinder.recodeString(dataInputStream, dataInputStream.readInt()));
                                bap.setSubnetmask(BAPFinder.recodeString(dataInputStream, dataInputStream.readInt()));
                                bap.setGateway(BAPFinder.recodeString(dataInputStream, dataInputStream.readInt()));
                                bap.setHostname(BAPFinder.recodeString(dataInputStream, dataInputStream.readInt()));
                                bap.setMac(BAPFinder.recodeString(dataInputStream, dataInputStream.readInt()));
                                bap.setId(dataInputStream.readLong());
                                bap.setFeatures(dataInputStream.readLong());
                                bap.setVersion(dataInputStream.readLong());
                                if (bap.hasFeature(4096L)) {
                                    bap.setCommands(dataInputStream.readLong());
                                }
                                bap.setUdp(true);
                                BAPFinder.this.fireBAPReceived(bap);
                            }
                            catch (Exception e) {
                                System.err.println(e.getMessage());
                                try {
                                    dataInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    byteArrayInputStream.close();
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                dataInputStream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                byteArrayInputStream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            dataInputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        };
    }

    private void fireBAPReceived(final IBAPFinder.IBAP bap) {
        for (IBAPFinder.IBAPListener listener : this.listeners) {
            listener.bapReceived(bap);
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BAPFinder.this.addBAP(bap);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.addButton(this.getButtonCommit());
        }
        return this.buttonPanel;
    }

    @Override
    public void addButton(JButton button) {
        Component[] components = this.buttonPanel.getComponents();
        int i = 0;
        while (i < components.length) {
            JButton tmpButton = (JButton)components[i];
            GridBagLayout layout = (GridBagLayout)this.buttonPanel.getLayout();
            GridBagConstraints constraints = layout.getConstraints(tmpButton);
            ++constraints.gridx;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(5, 0, 5, 5);
            layout.setConstraints(tmpButton, constraints);
            ++i;
        }
        GridBagConstraints constraintsButton = new GridBagConstraints();
        constraintsButton.gridx = 0;
        constraintsButton.insets = new Insets(5, 5, 5, 5);
        constraintsButton.weightx = 1.0;
        constraintsButton.anchor = 13;
        constraintsButton.gridy = 0;
        this.buttonPanel.add((Component)button, constraintsButton);
        this.pack();
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerLocation(215);
            this.jSplitPane.setBorder(BorderFactory.createEtchedBorder(1));
            this.jSplitPane.setLeftComponent(this.getPaneSelect());
            this.jSplitPane.setRightComponent(this.getPanelSettings());
        }
        return this.jSplitPane;
    }

    private JPanel getPanelInterfaces() {
        if (this.panelInterfaces == null) {
            GridBagConstraints constraintsPanelInterfacesInner = new GridBagConstraints();
            constraintsPanelInterfacesInner.gridx = 0;
            constraintsPanelInterfacesInner.fill = 2;
            constraintsPanelInterfacesInner.weightx = 1.0;
            constraintsPanelInterfacesInner.gridy = 0;
            this.panelInterfaces = new JPanel();
            this.panelInterfaces.setLayout(new GridBagLayout());
            this.panelInterfaces.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelInterfaces.add((Component)this.getPanelInterfacesInner(), constraintsPanelInterfacesInner);
        }
        return this.panelInterfaces;
    }

    private JComboBox getComboBoxInterfaces() {
        if (this.comboBoxInterfaces == null) {
            this.comboBoxInterfaces = new JComboBox();
            this.comboBoxInterfaces.setRenderer(new InterfacesCellRenderer());
            this.comboBoxInterfaces.setFont(new Font("Tahoma", 0, 11));
            try {
                Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                while (ifaces.hasMoreElements()) {
                    NetworkInterface networkInterface = ifaces.nextElement();
                    if (networkInterface.isLoopback() || !networkInterface.isUp() || networkInterface.isVirtual() || networkInterface.isPointToPoint()) continue;
                    this.comboBoxInterfaces.addItem(networkInterface);
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
                this.comboBoxInterfaces.setBackground(Color.RED);
            }
            if (this.comboBoxInterfaces.getSelectedIndex() != -1) {
                selectedInterface = (NetworkInterface)this.comboBoxInterfaces.getSelectedItem();
            }
            this.comboBoxInterfaces.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BAPFinder.this.comboBoxInterfaces.getSelectedIndex() != -1) {
                        selectedInterface = (NetworkInterface)BAPFinder.this.comboBoxInterfaces.getSelectedItem();
                    } else {
                        selectedInterface = null;
                    }
                }
            });
        }
        return this.comboBoxInterfaces;
    }

    private JPanel getPanelInterfacesInner() {
        if (this.panelInterfacesInner == null) {
            GridBagConstraints constraintsComboBoxInterfaces = new GridBagConstraints();
            constraintsComboBoxInterfaces.fill = 2;
            constraintsComboBoxInterfaces.weightx = 1.0;
            this.panelInterfacesInner = new JPanel();
            this.panelInterfacesInner.setLayout(new GridBagLayout());
            this.panelInterfacesInner.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.35"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelInterfacesInner.add((Component)this.getComboBoxInterfaces(), constraintsComboBoxInterfaces);
        }
        return this.panelInterfacesInner;
    }

    private JMenuBar getMenu() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.menuBar.setBorder(BorderFactory.createEtchedBorder(1));
            this.menuBar.add(this.getFileMenu());
        }
        return this.menuBar;
    }

    private JMenu getFileMenu() {
        if (this.menuFile == null) {
            this.menuFile = new JMenu("Datei");
            JMenuItem menuItem = new JMenuItem("Sprache");
            menuItem.setActionCommand("language");
            menuItem.addActionListener(this);
            this.menuFile.add(menuItem);
        }
        return this.menuFile;
    }

    public static void main(String[] args) throws Throwable {
        block19: {
            properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream("./finder.ini");
                    properties.load(fileInputStream);
                }
                catch (Exception exception) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception2) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String language = properties.getProperty("language");
        System.out.println(language);
        if (language != null && !language.equals("default")) {
            String[] variants = language.split("_");
            System.out.println(variants.length);
            Locale locale = null;
            if (variants.length == 1) {
                locale = new Locale(variants[0]);
            }
            if (variants.length == 2) {
                locale = new Locale(variants[0], variants[1].toUpperCase());
            } else if (variants.length > 2) {
                locale = new Locale(variants[0], variants[1].toUpperCase(), variants[2]);
            }
            System.out.println(locale);
            if (locale != null) {
                Locale.setDefault(locale);
                JComponent.setDefaultLocale(locale);
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BAPFinder finder = new BAPFinder();
                finder.setVisible(true);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkValues() {
        String pattern = "([0-9.]+)";
        if (!this.selectedBap.hasFeature(1L)) {
            if (!this.selectedBap.hasFeature(16384L) && (!Pattern.matches(pattern, this.textFieldBoSeIP.getText()) || BAPFinder.getAnzahlPunkte(this.textFieldBoSeIP.getText()) != 3) || !Pattern.matches(pattern, this.textFieldIP.getText()) || BAPFinder.getAnzahlPunkte(this.textFieldIP.getText()) != 3 || !Pattern.matches(pattern, this.textFieldSubnet.getText()) || BAPFinder.getAnzahlPunkte(this.textFieldSubnet.getText()) != 3 || (!Pattern.matches(pattern, this.textFieldGateway.getText()) || BAPFinder.getAnzahlPunkte(this.textFieldGateway.getText()) != 3) && this.textFieldGateway.getText().length() != 0) return false;
            if (!this.selectedBap.hasFeature(8L)) return true;
            if (this.textFieldHostname.getText().length() >= 11) return false;
            return true;
        }
        if (!Pattern.matches(pattern, this.textFieldBoSeIP.getText()) || BAPFinder.getAnzahlPunkte(this.textFieldBoSeIP.getText()) != 3 || this.textFieldHostname.getText().length() >= 11) return false;
        if (this.checkBoxDHCP.isSelected()) return true;
        if (!Pattern.matches(pattern, this.textFieldIP.getText()) || BAPFinder.getAnzahlPunkte(this.textFieldIP.getText()) != 3 || !Pattern.matches(pattern, this.textFieldSubnet.getText()) || BAPFinder.getAnzahlPunkte(this.textFieldSubnet.getText()) != 3 || (!Pattern.matches(pattern, this.textFieldGateway.getText()) || BAPFinder.getAnzahlPunkte(this.textFieldGateway.getText()) != 3) && this.textFieldGateway.getText().length() != 0) return false;
        return true;
    }

    private static int getAnzahlPunkte(String text) {
        int textLength = text.length();
        int index = 0;
        int pointCounter = 0;
        while (index < textLength) {
            if (text.substring(index, index + 1).equals(".")) {
                ++pointCounter;
            }
            ++index;
        }
        return pointCounter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("submit") && this.selectedBap != null) {
            if (!this.checkValues()) {
                JOptionPane.showMessageDialog(this, Messages.getString("BAPFinder.40"));
                return;
            }
            boolean result = false;
            result = this.selectedBap.isUdp() ? this.sendConfigUDP(this.selectedBap) : this.sendConfigTCP(this.selectedBap);
            if (!result) {
                JOptionPane.showMessageDialog(this, Messages.getString("BAPFinder.41"));
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("BAPFinder.42"));
                this.removeSettingsCopy(this.selectedBap);
                this.removeBAP(this.selectedBap.getMac(), false);
            }
        } else if (command.equals("language")) {
            new LanguageSelection((Window)this).setVisible(true);
        }
    }

    private boolean sendConfigUDP(IBAPFinder.IBAP selectedBap) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        try {
            boolean dhcp = this.checkBoxDHCP.isSelected();
            String boseIP = this.textFieldBoSeIP.getText();
            String bapIP = this.textFieldIP.getText();
            String subnetmask = this.textFieldSubnet.getText();
            String gateway = this.textFieldGateway.getText();
            String hostname = this.textFieldHostname.getText();
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(false);
            dataOutputStream.writeBoolean(dhcp);
            dataOutputStream.writeInt(boseIP.length());
            dataOutputStream.writeChars(boseIP);
            dataOutputStream.writeInt(bapIP.length());
            dataOutputStream.writeChars(bapIP);
            dataOutputStream.writeInt(subnetmask.length());
            dataOutputStream.writeChars(subnetmask);
            dataOutputStream.writeInt(gateway.length());
            dataOutputStream.writeChars(gateway);
            dataOutputStream.writeInt(hostname.length());
            dataOutputStream.writeChars(hostname);
            if (!BAPFinder.broadcast(2, byteArrayOutputStream.toByteArray(), selectedBap.getId())) {
                throw new Exception("Broadcast not sended");
            }
            try {
                dataOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean sendConfigTCP(IBAPFinder.IBAP selectedBap) {
        Socket socket = null;
        OutputStream outputStream = null;
        try {
            try {
                socket = new Socket(selectedBap.getIp(), 2010);
                outputStream = socket.getOutputStream();
                String sendString = "SETIP#";
                if (!selectedBap.hasFeature(1L)) {
                    sendString = String.valueOf(sendString) + this.textFieldIP.getText() + "#" + this.textFieldSubnet.getText() + "#" + this.textFieldBoSeIP.getText();
                    if (selectedBap.getVersion() >= 20080702L) {
                        sendString = this.textFieldGateway.getText().length() != 0 ? String.valueOf(sendString) + "#" + this.textFieldGateway.getText() : String.valueOf(sendString) + "#--";
                        sendString = this.textFieldHostname.getText().length() != 0 ? String.valueOf(sendString) + "#" + this.textFieldHostname.getText() : String.valueOf(sendString) + "#--";
                    }
                } else if (this.checkBoxDHCP.isSelected()) {
                    sendString = String.valueOf(sendString) + "true#";
                    sendString = String.valueOf(sendString) + (this.textFieldHostname.getText().length() == 0 ? "--#" : String.valueOf(this.textFieldHostname.getText()) + "#");
                    sendString = String.valueOf(sendString) + this.textFieldBoSeIP.getText();
                } else {
                    sendString = String.valueOf(sendString) + "false#";
                    sendString = String.valueOf(sendString) + this.textFieldIP.getText() + "#";
                    sendString = String.valueOf(sendString) + this.textFieldSubnet.getText() + "#";
                    sendString = String.valueOf(sendString) + (this.textFieldGateway.getText().length() == 0 ? "--#" : String.valueOf(this.textFieldGateway.getText()) + "#");
                    sendString = String.valueOf(sendString) + (this.textFieldHostname.getText().length() == 0 ? "--#" : String.valueOf(this.textFieldHostname.getText()) + "#");
                    sendString = String.valueOf(sendString) + this.textFieldBoSeIP.getText();
                }
                outputStream.write(sendString.getBytes());
                outputStream.flush();
                JOptionPane.showMessageDialog(this, Messages.getString("BAPFinder.42"));
                this.listModel.removeElement(selectedBap);
                selectedBap = null;
                this.textFieldIP.setText("");
                this.textFieldSubnet.setText("");
                this.textFieldBoSeIP.setText("");
                this.textFieldGateway.setText("");
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, Messages.getString("BAPFinder.66"));
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static String recodeString(DataInputStream dataInputStream, int length) {
        if (length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            try {
                stringBuffer.append(dataInputStream.readChar());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.listSelect.getSelectedIndex() == -1) {
            this.selectedBap = null;
            this.buttonCommit.setEnabled(false);
        } else {
            this.buttonCommit.setEnabled(true);
            this.selectedBap = (IBAPFinder.IBAP)this.listSelect.getSelectedValue();
            this.textFieldHostname.setEnabled(this.selectedBap.hasFeature(8L));
            this.checkBoxDHCP.setEnabled(this.selectedBap.hasFeature(4L));
            this.checkBoxDHCP.setSelected(this.selectedBap.isDhcp());
            if (this.selectedBap.hasFeature(16384L)) {
                this.textFieldBoSeIP.setEnabled(false);
                this.textFieldBoSeIP.setText(Messages.getString("BAPFinder.67"));
            } else {
                this.textFieldBoSeIP.setEnabled(true);
                this.textFieldBoSeIP.setText(this.selectedBap.getServerIP());
            }
            this.textFieldIP.setText(this.selectedBap.getIp());
            this.textFieldSubnet.setText(this.selectedBap.getSubnetmask());
            this.textFieldGateway.setText(this.selectedBap.getGateway());
            this.textFieldHostname.setText(this.selectedBap.getHostname());
        }
        for (Plugin plugin : this.plugins) {
            plugin.selectedBAPChanged(this.selectedBap);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.checkBoxDHCP) {
            if (this.checkBoxDHCP.isSelected()) {
                this.textFieldIP.setEnabled(false);
                this.textFieldSubnet.setEnabled(false);
                this.textFieldGateway.setEnabled(false);
            } else {
                this.textFieldIP.setEnabled(true);
                this.textFieldSubnet.setEnabled(true);
                this.textFieldGateway.setEnabled(true);
            }
        }
    }

    private JWizardHeader getWizardHeader() {
        if (this.wizardHeader == null) {
            this.wizardHeader = new JWizardHeader();
            this.wizardHeader.setTextHeader1(Messages.getString("BAPFinder.68"));
            this.wizardHeader.setTextHeader2(Messages.getString("BAPFinder.69"));
            this.wizardHeader.setImage(BAPFinder.loadImage("bap.png"));
        }
        return this.wizardHeader;
    }

    private JList getListSelect() {
        if (this.listSelect == null) {
            this.listModel = new DefaultListModel();
            this.sicherungsListe = new DefaultListModel();
            this.listSelect = new JList();
            this.listSelect.setFont(new Font("Tahoma", 0, 11));
            this.listSelect.setCellRenderer(new CellRenderer());
            this.listSelect.setSelectionMode(0);
            this.listSelect.setModel(this.listModel);
            this.listSelect.addListSelectionListener(this);
        }
        return this.listSelect;
    }

    private JScrollPane getPaneSelect() {
        if (this.paneSelect == null) {
            this.paneSelect = new JScrollPane();
            this.paneSelect.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.72"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.paneSelect.setBackground(this.getBackground());
            this.paneSelect.setViewportView(this.getListSelect());
        }
        return this.paneSelect;
    }

    private JTextField getTextFieldBoSeIP() {
        if (this.textFieldBoSeIP == null) {
            this.textFieldBoSeIP = new JTextField();
            this.textFieldBoSeIP.setEnabled(false);
        }
        return this.textFieldBoSeIP;
    }

    private JPanel getPanelBoSeIP() {
        if (this.panelBoSeIP == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridy = 0;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.gridx = 0;
            this.panelBoSeIP = new JPanel();
            this.panelBoSeIP.setLayout(new GridBagLayout());
            this.panelBoSeIP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.74"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelBoSeIP.add((Component)this.getTextFieldBoSeIP(), gridBagConstraints10);
        }
        return this.panelBoSeIP;
    }

    private JCheckBox getCheckBoxDHCP() {
        if (this.checkBoxDHCP == null) {
            this.checkBoxDHCP = new JCheckBox(Messages.getString("BAPFinder.76"));
            this.checkBoxDHCP.setFont(new Font("Tahoma", 0, 11));
            this.checkBoxDHCP.setEnabled(false);
            this.checkBoxDHCP.addChangeListener(this);
        }
        return this.checkBoxDHCP;
    }

    private JPanel getpanelDHCP() {
        if (this.panelDHCP == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridy = 0;
            this.panelDHCP = new JPanel();
            this.panelDHCP.setLayout(new GridBagLayout());
            this.panelDHCP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.78"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelDHCP.add((Component)this.getCheckBoxDHCP(), gridBagConstraints11);
        }
        return this.panelDHCP;
    }

    private JTextField getTextFieldIP() {
        if (this.textFieldIP == null) {
            this.textFieldIP = new JTextField();
        }
        return this.textFieldIP;
    }

    private JPanel getPanelIP() {
        if (this.panelIP == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridy = 0;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.gridx = 0;
            this.panelIP = new JPanel();
            this.panelIP.setLayout(new GridBagLayout());
            this.panelIP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.80"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelIP.add((Component)this.getTextFieldIP(), gridBagConstraints12);
        }
        return this.panelIP;
    }

    private JTextField getTextFieldSubnet() {
        if (this.textFieldSubnet == null) {
            this.textFieldSubnet = new JTextField();
        }
        return this.textFieldSubnet;
    }

    private JPanel getPanelSubnet() {
        if (this.panelSubnet == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.gridx = 0;
            this.panelSubnet = new JPanel();
            this.panelSubnet.setLayout(new GridBagLayout());
            this.panelSubnet.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.82"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelSubnet.add((Component)this.getTextFieldSubnet(), gridBagConstraints13);
        }
        return this.panelSubnet;
    }

    private JTextField getTextFieldGateway() {
        if (this.textFieldGateway == null) {
            this.textFieldGateway = new JTextField();
        }
        return this.textFieldGateway;
    }

    private JPanel getPanelGateway() {
        if (this.panelGateway == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.gridx = 0;
            this.panelGateway = new JPanel();
            this.panelGateway.setLayout(new GridBagLayout());
            this.panelGateway.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.84"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelGateway.add((Component)this.getTextFieldGateway(), gridBagConstraints14);
        }
        return this.panelGateway;
    }

    private JTextField getTextFieldHostname() {
        if (this.textFieldHostname == null) {
            this.textFieldHostname = new JTextField();
            this.textFieldHostname.setText(Messages.getString("BAPFinder.86"));
        }
        return this.textFieldHostname;
    }

    private JPanel getPanelHostname() {
        if (this.panelHostname == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.gridx = 0;
            this.panelHostname = new JPanel();
            this.panelHostname.setLayout(new GridBagLayout());
            this.panelHostname.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.87"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelHostname.add((Component)this.getTextFieldHostname(), gridBagConstraints15);
        }
        return this.panelHostname;
    }

    private JButton getButtonCommit() {
        if (this.buttonCommit == null) {
            this.buttonCommit = new JButton();
            this.buttonCommit.setEnabled(false);
            this.buttonCommit.setPreferredSize(new Dimension(100, 25));
            this.buttonCommit.setFont(new Font("Tahoma", 0, 11));
            this.buttonCommit.setText(Messages.getString("BAPFinder.90"));
            this.buttonCommit.setActionCommand("submit");
            this.buttonCommit.addActionListener(this);
        }
        return this.buttonCommit;
    }

    private JPanel getPanelSettings() {
        if (this.panelSettings == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.gridy = 5;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.gridy = 4;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridy = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridy = 0;
            this.panelSettings = new JPanel();
            this.panelSettings.setLayout(new GridBagLayout());
            this.panelSettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("BAPFinder.92"), 0, 0, new Font("Tahoma", 0, 11), new Color(51, 51, 51)));
            this.panelSettings.add((Component)this.getPanelBoSeIP(), gridBagConstraints3);
            this.panelSettings.add((Component)this.getpanelDHCP(), gridBagConstraints4);
            this.panelSettings.add((Component)this.getPanelIP(), gridBagConstraints5);
            this.panelSettings.add((Component)this.getPanelSubnet(), gridBagConstraints6);
            this.panelSettings.add((Component)this.getPanelGateway(), gridBagConstraints7);
            this.panelSettings.add((Component)this.getPanelHostname(), gridBagConstraints8);
            this.panelSettings.setPreferredSize(new Dimension(180, this.panelSettings.getPreferredSize().height));
        }
        return this.panelSettings;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints constraintsMenu = new GridBagConstraints();
            constraintsMenu.gridx = 0;
            constraintsMenu.gridy = 1;
            constraintsMenu.fill = 2;
            GridBagConstraints constraintsPanelInterfaces = new GridBagConstraints();
            constraintsPanelInterfaces.gridx = 0;
            constraintsPanelInterfaces.fill = 2;
            constraintsPanelInterfaces.gridy = 2;
            GridBagConstraints constraintsJSplitPane = new GridBagConstraints();
            constraintsJSplitPane.fill = 1;
            constraintsJSplitPane.gridy = 3;
            constraintsJSplitPane.weightx = 1.0;
            constraintsJSplitPane.weighty = 1.0;
            constraintsJSplitPane.gridx = 0;
            GridBagConstraints constraintsButtonPanel = new GridBagConstraints();
            constraintsButtonPanel.gridx = 0;
            constraintsButtonPanel.fill = 2;
            constraintsButtonPanel.gridy = 4;
            GridBagConstraints constraintsWizardHeader = new GridBagConstraints();
            constraintsWizardHeader.gridx = 0;
            constraintsWizardHeader.gridy = 0;
            constraintsWizardHeader.fill = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getWizardHeader(), constraintsWizardHeader);
            this.jContentPane.add((Component)this.getJSplitPane(), constraintsJSplitPane);
            this.jContentPane.add((Component)this.getButtonPanel(), constraintsButtonPanel);
            this.jContentPane.add((Component)this.getPanelInterfaces(), constraintsPanelInterfaces);
        }
        return this.jContentPane;
    }

    public static String getHexString(byte[] bs) {
        StringBuffer ret = new StringBuffer(bs.length);
        int i = 0;
        while (i < bs.length) {
            String hex = Integer.toHexString(256 + (bs[i] & 0xFF)).substring(1);
            ret.append(String.valueOf(hex.length() < 2 ? "0" : "") + hex);
            ++i;
        }
        return ret.toString();
    }

    @Override
    public IBAPFinder.IMessage sendToConfigPort(String ip, int messageType, RandomArrayStream stream) {
        return Tools.sendToConfigPort(ip, messageType, stream);
    }

    @Override
    public IBAPFinder.IMessage sendToConfigPort(String ip, int messageType, RandomArrayStream stream, boolean needAnswer, int timeout) {
        return Tools.sendToConfigPort(ip, messageType, stream, needAnswer, timeout);
    }

    @Override
    public Locale getLanguage() {
        return new Locale("de");
    }

    public static BufferedImage loadImage(String name) {
        name = String.valueOf(imagePath) + name;
        BufferedImage image = null;
        try {
            String resourceName = name.replace(File.separatorChar, '/');
            image = ImageIO.read(new Object().getClass().getResourceAsStream("/" + resourceName));
        }
        catch (Exception e) {
            try {
                image = ImageIO.read(new File(name));
            }
            catch (Exception e1) {
                System.err.println("BAPFinder.loadImage() --> Error while loading image: " + e.getMessage());
                return null;
            }
        }
        return image;
    }

    @Override
    public void removeBAP(String mac, boolean saveConfig) {
        Object[] baps = this.listModel.toArray();
        IBAPFinder.IBAP selectedBAP = null;
        Object[] objectArray = baps;
        int n = baps.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IBAPFinder.IBAP bap = (IBAPFinder.IBAP)object;
            if (bap.getMac().equals(mac)) {
                selectedBAP = bap;
                break;
            }
            ++n2;
        }
        if (selectedBAP != null) {
            if (saveConfig) {
                this.saveConfig(selectedBAP);
            }
            this.listModel.removeElement(selectedBAP);
            this.selectedBap = null;
            this.textFieldIP.setText("");
            this.textFieldSubnet.setText("");
            this.textFieldBoSeIP.setText("");
            this.textFieldGateway.setText("");
            this.textFieldHostname.setText("");
        }
    }

    private void saveConfig(IBAPFinder.IBAP bap) {
        BAP save = null;
        IBAPFinder.IBAP listBap = null;
        boolean found = false;
        int i = 0;
        while (i < this.sicherungsListe.size()) {
            listBap = (IBAPFinder.IBAP)this.sicherungsListe.get(i);
            if (listBap.getId() == bap.getId()) {
                save = (BAP)listBap;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            save = new BAP();
        }
        save.setId(bap.getId());
        save.setIp(bap.getIp());
        save.setIpv6(bap.isIpv6());
        save.setDhcp(bap.isDhcp());
        save.setUdp(bap.isUdp());
        save.setServerIP(bap.getServerIP());
        save.setSubnetmask(bap.getSubnetmask());
        save.setGateway(bap.getGateway());
        save.setHostname(bap.getHostname());
        save.setMac(bap.getMac());
        if (found) {
            this.sicherungsListe.removeElement(listBap);
        }
        this.sicherungsListe.addElement(save);
    }

    @Override
    public void addBAPListener(IBAPFinder.IBAPListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeBAPListener(IBAPFinder.IBAPListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public IBAPFinder.IBAP getSelectedBAP() {
        return this.selectedBap;
    }

    @Override
    public void addToContextMenu(JMenuItem menuItem) {
    }

    @Override
    public PluginVersion getAPIVersion() {
        return apiVersion;
    }

    @Override
    public boolean hasSettingsCopy(IBAPFinder.IBAP bap) {
        int i = 0;
        while (i < this.sicherungsListe.size()) {
            IBAPFinder.IBAP temp = (IBAPFinder.IBAP)this.sicherungsListe.get(i);
            if (temp.getId() == bap.getId()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeSettingsCopy(IBAPFinder.IBAP bap) {
        int i = 0;
        while (i < this.sicherungsListe.size()) {
            IBAPFinder.IBAP temp = (IBAPFinder.IBAP)this.sicherungsListe.get(i);
            if (temp.getId() == bap.getId()) {
                this.sicherungsListe.remove(i);
                return;
            }
            ++i;
        }
    }

    @Override
    public void useSaveSettings(IBAPFinder.IBAP selectedBAP) {
        int i = 0;
        while (i < this.sicherungsListe.size()) {
            IBAPFinder.IBAP temp = (IBAPFinder.IBAP)this.sicherungsListe.get(i);
            if (temp.getId() == selectedBAP.getId()) {
                this.textFieldHostname.setEnabled(temp.hasFeature(8L));
                this.checkBoxDHCP.setEnabled(temp.hasFeature(4L));
                this.checkBoxDHCP.setSelected(temp.isDhcp());
                if (temp.hasFeature(16384L)) {
                    this.textFieldBoSeIP.setEnabled(false);
                    this.textFieldBoSeIP.setText(Messages.getString("BAPFinder.67"));
                } else {
                    this.textFieldBoSeIP.setEnabled(true);
                    this.textFieldBoSeIP.setText(temp.getServerIP());
                }
                this.textFieldIP.setText(temp.getIp());
                this.textFieldSubnet.setText(temp.getSubnetmask());
                this.textFieldGateway.setText(temp.getGateway());
                this.textFieldHostname.setText(temp.getHostname());
                this.textFieldIP.setEnabled(true);
                this.textFieldSubnet.setEnabled(true);
                this.textFieldGateway.setEnabled(true);
                this.textFieldHostname.setEnabled(true);
                return;
            }
            ++i;
        }
    }

    private static class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component;
            if (value instanceof IBAPFinder.IBAP) {
                IBAPFinder.IBAP bap = (IBAPFinder.IBAP)value;
                String version = bap.getVersion() == 0L ? Messages.getString("BAPFinder.25") : String.valueOf(bap.getVersion());
                version = String.valueOf(version) + " - ";
                int count = 0;
                if (bap.hasFeature(1L)) {
                    version = String.valueOf(version) + "<font color=\"#FF0000\">HS</font>";
                    ++count;
                }
                if (bap.hasFeature(2L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = bap.hasFeature(16L) ? String.valueOf(version) + "<font color=\"#00A000\">SA-E</font>" : String.valueOf(version) + "<font color=\"#00A000\">SA</font>";
                    ++count;
                }
                if (bap.hasFeature(64L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#0000A0\">E3</font>";
                    ++count;
                }
                if (bap.hasFeature(512L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#FF8A00\">D</font>";
                    ++count;
                }
                if (bap.hasFeature(4096L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#3A35A2\">C</font>";
                    ++count;
                }
                if (bap.hasFeature(8192L)) {
                    if (count > 0) {
                        version = String.valueOf(version) + ", ";
                    }
                    version = String.valueOf(version) + "<font color=\"#EC13C1\">B</font>";
                    ++count;
                }
                value = bap.hasFeature(16384L) ? String.valueOf("<html>" + Messages.getString("BAPFinder.0") + " " + bap.getId() + "<br>" + Messages.getString("BAPFinder.122") + " " + bap.getMac() + "<br>" + Messages.getString("BAPFinder.125") + " " + version + "</html>") : String.valueOf("<html>" + Messages.getString("BAPFinder.129") + " " + bap.getId() + "<br>" + Messages.getString("BAPFinder.122") + " " + bap.getMac() + "<br>" + Messages.getString("BAPFinder.125") + " " + version + "</html>");
            }
            if ((component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus)) instanceof JLabel) {
                ((JLabel)component).setIcon(new ImageIcon(image));
                ((JLabel)component).setBorder(BorderFactory.createEtchedBorder(1));
            }
            return component;
        }
    }

    private static class InterfacesCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private InterfacesCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof NetworkInterface) {
                NetworkInterface iface = (NetworkInterface)value;
                value = iface.getDisplayName();
            }
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            boolean cfr_ignored_0 = component instanceof JLabel;
            return component;
        }
    }
}

