/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.Stack;

public class JsonWriter
implements Closeable,
Flushable {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private Writer out;
    private Stack<Writer> writers = new Stack();
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String indent;
    private String separator;
    private boolean lenient;
    private boolean rootNewLine;
    private boolean primeArrayNewLine;
    private boolean htmlSafe;
    private String deferredName;
    private boolean serializeNulls;

    static {
        int i = 0;
        while (i <= 31) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
            ++i;
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }

    public JsonWriter(Writer out) {
        this.push(6);
        this.separator = ":";
        this.rootNewLine = true;
        this.primeArrayNewLine = false;
        this.serializeNulls = true;
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        this.out = out;
    }

    public final void setIndent(String indent) {
        if (indent.length() == 0) {
            this.indent = null;
            this.separator = ":";
        } else {
            this.indent = indent;
            this.separator = ": ";
        }
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final void setHtmlSafe(boolean htmlSafe) {
        this.htmlSafe = htmlSafe;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public final void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        if (!this.primeArrayNewLine) {
            this.writers.push(this.out);
            this.out.flush();
            this.out = new StringWriter();
        }
        JsonWriter jsonWriter = this.open(1, "[");
        return jsonWriter;
    }

    public JsonWriter endArray() throws IOException {
        JsonWriter writer = this.close(1, 2, "]");
        if (!this.primeArrayNewLine) {
            Writer previousWriter;
            try {
                previousWriter = this.writers.pop();
            }
            catch (EmptyStackException e) {
                throw new IOException(e);
            }
            this.out.flush();
            String string = this.out.toString();
            if (!this.writers.isEmpty() && this.peek() == 2) {
                if (!string.contains("{")) {
                    int start = string.indexOf(91) + 1;
                    int end = string.indexOf(93);
                    String subString = string.substring(start, end);
                    subString = subString.replace("\n", "");
                    subString = subString.replace("\t", "");
                    string = String.valueOf(string.substring(0, start)) + subString + string.substring(end);
                }
            } else if (!string.contains("{")) {
                string = string.replace("\n", "");
                string = string.replace("\t", "");
            }
            previousWriter.write(string);
            previousWriter.flush();
            this.out = previousWriter;
        }
        return writer;
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, "{");
    }

    public JsonWriter endObject() throws IOException {
        return this.close(3, 5, "}");
    }

    private JsonWriter open(int empty, String openBracket) throws IOException {
        this.beforeValue(true);
        this.push(empty);
        this.out.write(openBracket);
        return this;
    }

    private JsonWriter close(int empty, int nonempty, String closeBracket) throws IOException {
        int context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        if (context == nonempty) {
            this.newline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            this.stack = newStack;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.deferredName = name;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.string(value);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue(false);
        this.out.write("null");
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.write(value ? "true" : "false");
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.append(Double.toString(value));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.write(Long.toString(value));
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = value.toString();
        if (!this.lenient && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.beforeValue(false);
        this.out.append(string);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private void string(String value) throws IOException {
        String[] replacements = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write("\"");
        int last = 0;
        int length = value.length();
        int i = 0;
        while (i < length) {
            block8: {
                String replacement;
                block7: {
                    char c;
                    block9: {
                        block6: {
                            c = value.charAt(i);
                            if (c >= '\u0080') break block6;
                            replacement = replacements[c];
                            if (replacement != null) break block7;
                            break block8;
                        }
                        if (c != '\u2028') break block9;
                        replacement = "\\u2028";
                        break block7;
                    }
                    if (c != '\u2029') break block8;
                    replacement = "\\u2029";
                }
                if (last < i) {
                    this.out.write(value, last, i - last);
                }
                this.out.write(replacement);
                last = i + 1;
            }
            ++i;
        }
        if (last < length) {
            this.out.write(value, last, length - last);
        }
        this.out.write("\"");
    }

    private void newline() throws IOException {
        this.newline(this.out);
    }

    private void newline(Writer out) throws IOException {
        if (this.indent == null) {
            return;
        }
        out.write("\n");
        int i = 1;
        int size = this.stackSize;
        while (i < size) {
            out.write(this.indent);
            ++i;
        }
    }

    private void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.out.write(44);
        } else if (context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue(boolean root) throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                if (!this.lenient && !root) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.out.append(',');
                this.newline();
                break;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                if (!root || !this.rootNewLine) break;
                this.newline();
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    public boolean isRootNewLine() {
        return this.rootNewLine;
    }

    public void setRootNewLine(boolean rootNewLine) {
        this.rootNewLine = rootNewLine;
    }

    public boolean isPrimeArrayNewLine() {
        return this.primeArrayNewLine;
    }

    public void setPrimeArrayNewLine(boolean primeArrayNewLine) {
        this.primeArrayNewLine = primeArrayNewLine;
    }
}

