/*
 * Decompiled with CFR 0.152.
 */
package TestUmgebung;

import java.awt.BasicStroke;
import java.awt.Color;
import javax.swing.JDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;

class StackBar {
    StackBar() {
    }

    public CategoryDataset createDataset() {
        double[][] data = new double[][]{{300.0, 300.0}, {50.0, 50.0}, {20.0, 20.0}};
        String[] achsen = new String[]{"Jahresverbrauch"};
        String[] leg = new String[]{"Tarif 1", "Tarif 2", "Tarif 3"};
        return DatasetUtilities.createCategoryDataset((Comparable[])leg, (Comparable[])achsen, (double[][])data);
    }

    public JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, null, dataset, PlotOrientation.VERTICAL, true, true, false, true);
        chart.setBackgroundPaint(new Color(249, 231, 236));
        CategoryPlot plot = chart.getCategoryPlot();
        plot.getRenderer().setSeriesPaint(0, new Color(237, 100, 202));
        plot.getRenderer().setSeriesPaint(1, new Color(1, 207, 38));
        plot.getRenderer().setSeriesPaint(2, new Color(24, 24, 24));
        plot.setDomainGridlineStroke(new BasicStroke(2.0f));
        plot.setOutlinePaint(new Color(137, 138, 140));
        return chart;
    }

    public static void main(String[] args) {
        StackBar sb = new StackBar();
        CategoryDataset dataset = sb.createDataset();
        JFreeChart chart = sb.createChart(dataset);
        Plot plot = chart.getPlot();
        chart.setBackgroundPaint(new Color(238, 238, 250));
        plot.setBackgroundPaint(new Color(238, 238, 250));
        chart.setBorderPaint(new Color(137, 138, 140));
        chart.getLegend().setPosition(RectangleEdge.RIGHT);
        chart.getLegend().setVerticalAlignment(VerticalAlignment.CENTER);
        chart.getLegend().setBackgroundPaint(new Color(238, 238, 250));
        chart.getLegend().setBorder(BlockBorder.NONE);
        ChartPanel chartPanel = new ChartPanel(chart);
        JDialog d = new JDialog();
        d.add(chartPanel);
        d.setSize(500, 500);
        d.setVisible(true);
    }
}

