/*
 * Decompiled with CFR 0.152.
 */
package TestUmgebung;

import java.awt.Color;
import java.awt.Font;
import java.util.Calendar;
import java.util.Date;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.data.category.DefaultIntervalCategoryDataset;
import org.jfree.ui.TextAnchor;

public class IntervalBarChartDemo {
    private static final String[] CATEGORIES = new String[]{"offen", "gekippt", "geschlossen"};
    private static Font labelFont = null;
    private static Font titleFont = null;
    private JFreeChart chart = null;

    static {
        labelFont = new Font("Helvetica", 0, 10);
        titleFont = new Font("Helvetica", 1, 14);
    }

    public IntervalBarChartDemo() {
        DefaultIntervalCategoryDataset data = null;
        double[][] lows = new double[][]{{-0.0315, 0.0159, 0.0306}};
        double[][] highs = new double[][]{{0.1931, 0.1457, 0.131}};
        Number[][] lowN = new Number[][]{{1, 4, 8}, {15, 17, 20}, {21, 23, 26}};
        Number[][] highN = new Number[][]{{3, 7, 15}, {16, 19, 21}, {22, 25, 28}};
        data = new DefaultIntervalCategoryDataset(lows, highs);
        data = new DefaultIntervalCategoryDataset(lowN, highN);
        data.setCategoryKeys((Comparable[])CATEGORIES);
        String title = "Strategie Sicherheit";
        String xTitle = "Zeitraum (in Jahren)";
        String yTitle = "Performance";
        CategoryAxis xAxis = new CategoryAxis("Zeitraum (in Jahren)", true);
        xAxis.setLabelFont(titleFont);
        xAxis.setTickLabelFont(labelFont);
        xAxis.setTickMarksVisible(false);
        NumberAxis yAxis = new NumberAxis("Performance", true);
        yAxis.setLabelFont(titleFont);
        yAxis.setTickLabelFont(labelFont);
        yAxis.setRange(1.0, 40.0);
        IntervalBarRenderer renderer = new IntervalBarRenderer(true);
        renderer.setSeriesPaint(0, new Color(51, 102, 153));
        renderer.setItemLabelsVisible(true);
        renderer.setItemLabelPaint(Color.white);
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        renderer.setPositiveItemLabelPosition(p);
        CategoryPlot plot = new CategoryPlot(data, xAxis, yAxis, renderer, true);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setOutlinePaint(Color.white);
        plot.setOrientation(PlotOrientation.VERTICAL);
        this.chart = new JFreeChart("Strategie Sicherheit", titleFont, plot, false);
        this.chart.setBackgroundPaint(Color.white);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public static void main(String[] args) {
        IntervalBarChartDemo sample = new IntervalBarChartDemo();
        JFreeChart chart = sample.getChart();
        ChartFrame frame = new ChartFrame("Interval Bar Chart Demo", chart);
        frame.pack();
        frame.setVisible(true);
    }

    private static Date date(int day, int month, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        Date result = calendar.getTime();
        return result;
    }
}

