/*
 * Decompiled with CFR 0.152.
 */
package TestUmgebung;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BarChart3DDemo1_1
extends ApplicationFrame
implements ChartMouseListener {
    private final ChartPanel chartPanel;
    private final JFreeChart chart;

    public BarChart3DDemo1_1(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        this.chart = this.createChart(dataset);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(this.chartPanel);
        this.chartPanel.addChartMouseListener(this);
    }

    private CategoryDataset createDataset() {
        double[][] data = new double[][]{{10.5, 0.1}, {4.5, 0.2}, {8.5, 0.0}};
        int i = 0;
        while (i < data.length) {
            int x = 0;
            while (x < data[i].length) {
                System.out.println("i: " + i + " x: " + x + " " + data[i][x]);
                ++x;
            }
            ++i;
        }
        return DatasetUtilities.createCategoryDataset("Series ", "Category ", (double[][])data);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedBarChart("3D StackBarChart Demo", "Gesamtverbrauch 2010", "kWh", dataset, PlotOrientation.VERTICAL, true, true, false, true);
        CategoryPlot plot = chart.getCategoryPlot();
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setLowerMargin(0.15);
        rangeAxis.setUpperMargin(0.15);
        BarRenderer b = (BarRenderer)plot.getRenderer();
        b.setMaximumBarWidth(0.1);
        LegendTitle lt = chart.getLegend();
        return chart;
    }

    public static void main(String[] args) {
        BarChart3DDemo1_1 demo = new BarChart3DDemo1_1("3D Bar Chart Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }

    @Override
    public void chartMouseClicked(ChartMouseEvent event) {
        if (event.getEntity() instanceof LegendItemEntity) {
            LegendItemEntity lie = (LegendItemEntity)event.getEntity();
            System.out.println("Key==> " + lie.getSeriesKey());
            Dataset dataset = lie.getDataset();
            System.out.println("==> " + dataset.toString());
            DefaultCategoryDataset ds = (DefaultCategoryDataset)dataset;
            CategoryPlot plot = this.chart.getCategoryPlot();
            plot.getRenderer().setSeriesPaint(1, new Color(55, 55, 55));
        }
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent event) {
    }
}

