/*
 * Decompiled with CFR 0.152.
 */
package bsc_main;

import bsc_main.BAPMessage;
import bsc_main.BIERKonfigurator;
import bsc_main.ObjectVectorClass;
import bsc_main.RoutingObject;
import bsc_visualisierung.RoutingTableZuweisung;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.JOptionPane;
import sun.misc.CRC16;

public class ConnectToBIER
extends Thread {
    private static boolean runner;
    private Socket socket;
    private static String ip;
    private DataInputStream din;
    private static DataOutputStream dout;
    private BufferedReader br;
    private String message;

    public ConnectToBIER(String argIP) {
        runner = true;
        ip = argIP;
        this.start();
    }

    @Override
    public void run() {
        block12: {
            try {
                BIERKonfigurator.klickbareButtons(false);
                if (InetAddress.getByName(ip).isReachable(2000)) {
                    try {
                        this.socket = new Socket(ip, 2000);
                        dout = new DataOutputStream(this.socket.getOutputStream());
                        this.din = new DataInputStream(this.socket.getInputStream());
                        this.br = new BufferedReader(new InputStreamReader(this.din));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    while (runner) {
                        try {
                            this.message = this.br.readLine();
                            if (this.message == null) {
                                runner = false;
                                continue;
                            }
                            BIERKonfigurator.setVerbindung(true);
                            BIERKonfigurator.klickbareButtons(true);
                            if (this.message.equals("ownid")) {
                                BIERKonfigurator.setOwnID(Long.parseLong(this.br.readLine(), 16));
                                continue;
                            }
                            if (this.message.equals("sendrt")) {
                                this.message = this.br.readLine();
                                while (!this.message.equals("sendrtend")) {
                                    ObjectVectorClass.addRoutingObjekt(new RoutingObject("" + Long.parseLong(this.message, 16), "" + Long.parseLong(this.br.readLine(), 16), "" + Long.parseLong(this.br.readLine(), 16)));
                                    this.message = this.br.readLine();
                                    if (!BIERKonfigurator.getZuweisungsDialog()) continue;
                                    RoutingTableZuweisung.addObjekt_TabelleAktualisierung(true);
                                }
                                continue;
                            }
                            BAPMessage bapMessage = new BAPMessage(this.message);
                            int typ = ConnectToBIER.getTyp(bapMessage);
                            if (typ == -1 || !ObjectVectorClass.addNeuesObjekt("" + bapMessage.getObjectID(), typ) || !BIERKonfigurator.getZuweisungsDialog()) continue;
                            RoutingTableZuweisung.addObjekt_TabelleAktualisierung(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.br.close();
                    this.din.close();
                    dout.close();
                    this.socket.close();
                    break block12;
                }
                JOptionPane.showMessageDialog(null, "BIER ist nicht erreichbar!\nPr\u00fcfen Sie Ihre Einstellungen.");
                BIERKonfigurator.setVerbindung(false);
                BIERKonfigurator.klickbareButtons(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void sendEndeKonfig() {
        new PrintStream(dout).println("configend");
        runner = false;
    }

    public static boolean changeBierIp(String argIp, String argSubnetzmaske, String oldIp) {
        boolean ok = false;
        try {
            Socket s = new Socket(oldIp, 2000);
            DataOutputStream dout = new DataOutputStream(s.getOutputStream());
            new PrintStream(dout).println("sendip");
            new PrintStream(dout).println(argIp);
            new PrintStream(dout).println(argSubnetzmaske);
            dout.close();
            s.close();
            ip = argIp;
            ok = true;
        }
        catch (UnknownHostException e) {
            JOptionPane.showMessageDialog(null, "IP-Adresse kann nicht aufgel\u00f6st werden.");
            ok = false;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Bier nicht erreichbar");
            ok = false;
        }
        return ok;
    }

    public static void sendRoutingTable(Vector<RoutingObject> argVec) {
        new PrintStream(dout).println("sendtable");
        int i = 0;
        while (i < argVec.size()) {
            String objektid = argVec.elementAt(i).getObjektID();
            String bierid = argVec.elementAt(i).getBierID();
            bierid = Long.toHexString(Long.parseLong(bierid));
            while (bierid.length() < 8) {
                bierid = "0" + bierid;
            }
            objektid = Long.toHexString(Long.parseLong(objektid));
            while (objektid.length() < 8) {
                objektid = "0" + objektid;
            }
            new PrintStream(dout).println(objektid);
            new PrintStream(dout).println(bierid);
            new PrintStream(dout).println(Integer.toHexString(Integer.parseInt(argVec.elementAt(i).getTyp())));
            ++i;
        }
        new PrintStream(dout).println("sendtableend");
        ObjectVectorClass.delRoutingTable();
    }

    public static void learn(long argID, int argTyp) {
        String status = "30";
        String id = Long.toHexString(argID);
        int i = id.length();
        while (i < 8) {
            id = "0" + id;
            ++i;
        }
        String typ = "";
        String command = "";
        switch (argTyp) {
            case 0: {
                typ = "05";
                status = "20";
                command = Integer.toHexString(224);
                break;
            }
            case 1: {
                typ = "05";
                command = Integer.toHexString(80);
                break;
            }
            case 2: {
                typ = "05";
                command = Integer.toHexString(16);
                break;
            }
            case 3: {
                typ = "06";
                command = "0" + Integer.toHexString(8);
                break;
            }
            case 4: {
                typ = "07";
                command = "ff";
            }
        }
        String strToSend = "a55a6b" + typ + command + "000000" + id + status;
        byte[] ba = ConnectToBIER.fromHexString(strToSend);
        byte b = 0;
        int i2 = 2;
        while (i2 < ba.length) {
            b = (byte)(b + ba[i2]);
            ++i2;
        }
        CRC16 crc = new CRC16();
        crc.update(b);
        int c = crc.value;
        strToSend = c < 16 ? String.valueOf(strToSend) + "0" + Integer.toHexString(c) : String.valueOf(strToSend) + Integer.toHexString(c);
        new PrintStream(dout).println("learn");
        new PrintStream(dout).println(String.valueOf(strToSend) + "\n");
        if (argTyp == 0) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            command = Integer.toHexString(240);
            strToSend = "a55a6b" + typ + command + "000000" + id + status;
            ba = ConnectToBIER.fromHexString(strToSend);
            b = 0;
            int i3 = 2;
            while (i3 < ba.length) {
                b = (byte)(b + ba[i3]);
                ++i3;
            }
            crc = new CRC16();
            crc.update(b);
            c = crc.value;
            strToSend = c < 16 ? String.valueOf(strToSend) + "0" + Integer.toHexString(c) : String.valueOf(strToSend) + Integer.toHexString(c);
            new PrintStream(dout).println("learn");
            new PrintStream(dout).println(String.valueOf(strToSend) + "\n");
        }
    }

    private static byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = ConnectToBIER.charToNibble(s.charAt(i));
            int low = ConnectToBIER.charToNibble(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public static int getTyp(BAPMessage message) {
        if (message.getOrgByte() == 5) {
            boolean bowPressed;
            boolean nMessage;
            boolean type1Telegram = BAPMessage.readBits((byte)message.getStatus(), 2, 1) == 0;
            boolean bl = nMessage = BAPMessage.readBits((byte)message.getStatus(), 3, 1) == 1;
            if (nMessage) {
                int byte3 = message.getByte3();
                return 1;
            }
            int buttonsOrStatus = BAPMessage.readBits((byte)message.getByte3(), 0, 3);
            boolean bl2 = bowPressed = BAPMessage.readBits((byte)message.getByte3(), 4, 1) == 1;
            if (!type1Telegram && buttonsOrStatus > 3) {
                return 0;
            }
            if (!bowPressed) {
                return 1;
            }
        } else {
            if (message.getOrgByte() == 7) {
                return 4;
            }
            if (message.getOrgByte() == 6) {
                int profile = BAPMessage.readBits((byte)message.getStatus(), 1, 3);
                switch (profile) {
                    case 0: {
                        return 3;
                    }
                }
                return -1;
            }
        }
        return -1;
    }
}

