/*
 * Decompiled with CFR 0.152.
 */
package bsc_main;

import bsc_main.ConnectToBIER;
import bsc_main.DateiZugriff;
import bsc_main.ImageLoader;
import bsc_main.MainBitmap;
import bsc_main.ObjectVectorClass;
import bsc_main.RoutingObject;
import bsc_visualisierung.KonfigMenue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import sun.misc.CRC16;

public class BIERKonfigurator
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String version = "2009.10.28";
    private static final boolean betaversion = false;
    private static String ip = "192.168.168.168";
    private static String subnetmask = "255.255.255.0";
    private static String fenstertitel;
    private static Image icon;
    private static JButton ip_config;
    private static JButton button_ende;
    private static JButton com_config;
    private static JTextField ipadr;
    private static JTextField subnet;
    private static JButton sende;
    private static int screenSizeX;
    private static int screenSizeY;
    private static ImageLoader il;
    private static long ownid;
    private static boolean zuweisungsDialog;
    private Vector<RoutingObject> routingObjectVector;
    private static boolean verbindung;
    private static boolean isTransfering;

    static {
        isTransfering = false;
    }

    public BIERKonfigurator() {
        super(fenstertitel);
        this.setLayout(null);
        this.setDefaultCloseOperation(0);
        screenSizeX = this.getToolkit().getScreenSize().width;
        screenSizeY = this.getToolkit().getScreenSize().height;
        fenstertitel = "BSC-BIER Konfigurator 2009.10.28";
        this.setTitle(fenstertitel);
        boolean eingelesen = DateiZugriff.readFile();
        il = new ImageLoader();
        icon = il.loadImageResource("icon.png");
        this.setIconImage(icon);
        ip_config = new JButton("  Verbinden mit BIER       ");
        ip_config.setActionCommand("0");
        ip_config.addActionListener(this);
        ip_config.setIcon(new ImageIcon(il.loadImageResource("ip_config.png")));
        ip_config.setToolTipText("Stellt die Verbindung zu einem BIER her");
        verbindung = false;
        com_config = new JButton("  Konfiguration                 ");
        com_config.setActionCommand("1");
        com_config.addActionListener(this);
        com_config.setIcon(new ImageIcon(il.loadImageResource("com_config.png")));
        com_config.setToolTipText("Konfiguriert den BIER");
        button_ende = new JButton("  Ende                             ");
        button_ende.setIcon(new ImageIcon(il.loadImageResource("exit.png")));
        button_ende.setToolTipText("Beendet den BIER Konfigurator");
        button_ende.addActionListener(this);
        button_ende.setActionCommand("-1");
        sende = new JButton("  Routingtabelle senden");
        sende.setIcon(new ImageIcon(il.loadImageResource("sendrouting.png")));
        sende.setToolTipText("Routing-Tabelle senden");
        sende.setActionCommand("3");
        sende.addActionListener(this);
        sende.setEnabled(false);
        ip_config.setBounds(185, 20, 230, 40);
        com_config.setBounds(185, 70, 230, 40);
        sende.setBounds(185, 120, 230, 40);
        button_ende.setBounds(185, 179, 230, 40);
        if (eingelesen) {
            ip = DateiZugriff.getIpAdresse();
            subnetmask = DateiZugriff.getSubnetzmaske();
        }
        JLabel ip_l = new JLabel("BIER IP:");
        JLabel ip_s = new JLabel("Subnetz-Maske:");
        ip_l.setBounds(10, 130, 150, 20);
        ipadr = new JTextField(ip);
        ipadr.setBounds(10, 150, 150, 25);
        ip_s.setBounds(10, 180, 150, 20);
        subnet = new JTextField(subnetmask);
        subnet.setBounds(10, 200, 150, 25);
        this.add(ip_s);
        this.add(ip_l);
        this.add(ipadr);
        this.add(subnet);
        this.add(sende);
        this.add(ip_config);
        this.add(com_config);
        this.add(button_ende);
        MainBitmap mb = new MainBitmap();
        mb.setBounds(10, 19, 170, 110);
        this.add(mb);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (isTransfering) {
                    JOptionPane.showMessageDialog(null, "Bitte warten Sie bis die Routingtabelle \u00fcbertragen wurde!");
                } else if (JOptionPane.showConfirmDialog(null, "Wollen Sie den BIER Konfigurator wirklich beenden?", "Beenden", 0, 3) == 0) {
                    if (verbindung) {
                        ConnectToBIER.sendEndeKonfig();
                    }
                    BIERKonfigurator.this.dispose();
                    System.exit(0);
                }
            }
        });
    }

    public static void main(String[] args) {
        BIERKonfigurator ctoolview = new BIERKonfigurator();
        ctoolview.setBounds(400, 200, 425, 260);
        ctoolview.setResizable(false);
        ctoolview.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int auswahl = Integer.parseInt(event.getActionCommand());
        Rectangle r = this.getBounds();
        switch (auswahl) {
            case -1: {
                if (JOptionPane.showConfirmDialog(null, "Wollen Sie den BIER Konfigurator wirklich beenden?", "Beenden", 0, 3) != 0) break;
                if (BIERKonfigurator.getVerbindung()) {
                    ConnectToBIER.sendEndeKonfig();
                }
                this.dispose();
                System.exit(0);
                break;
            }
            case 0: {
                if (!verbindung) {
                    if (DateiZugriff.pruefGueltigkeit(ipadr.getText()) && DateiZugriff.pruefGueltigkeit(subnet.getText())) {
                        ip = ipadr.getText();
                        subnetmask = subnet.getText();
                        new ConnectToBIER(ip);
                        break;
                    }
                    BIERKonfigurator.setVerbindung(false);
                    break;
                }
                ConnectToBIER.sendEndeKonfig();
                sende.setEnabled(false);
                BIERKonfigurator.setVerbindung(false);
                ObjectVectorClass.loescheRoutingVector();
                ObjectVectorClass.loescheNewObjectVector();
                break;
            }
            case 1: {
                new KonfigMenue((Frame)this, r);
                break;
            }
            case 3: {
                isTransfering = true;
                this.routingObjectVector = ObjectVectorClass.getRoutingObjekte();
                ConnectToBIER.sendRoutingTable(this.routingObjectVector);
                ConnectToBIER.sendEndeKonfig();
                ObjectVectorClass.loescheRoutingVector();
                ip_config.setText("  Verbinden mit BIER       ");
                ip_config.setIcon(new ImageIcon(il.loadImageResource("ip_config.png")));
                ip_config.setToolTipText("Stellt die Verbindung zu einem BIER her");
                sende.setEnabled(false);
                verbindung = false;
                ObjectVectorClass.loescheRoutingVector();
                ObjectVectorClass.loescheNewObjectVector();
                isTransfering = false;
            }
        }
    }

    public static boolean getZuweisungsDialog() {
        return zuweisungsDialog;
    }

    public static void setZuweisungsDialog(boolean argBoolean) {
        zuweisungsDialog = true;
    }

    public static Image getIcon() {
        return icon;
    }

    public static int getScreenSizeX() {
        return screenSizeX;
    }

    public static int getScreenSizeY() {
        return screenSizeY;
    }

    public static String getVersion() {
        return version;
    }

    public static void setOwnID(long arg) {
        com_config.setEnabled(true);
        ownid = arg;
    }

    public static long getOwnID() {
        return ownid;
    }

    public static String calculateCRC(String argString) {
        byte[] ba = BIERKonfigurator.fromHexString(argString);
        byte b = 0;
        int i = 2;
        while (i < ba.length) {
            b = (byte)(b + ba[i]);
            ++i;
        }
        CRC16 crc = new CRC16();
        crc.update(b);
        int c = crc.value;
        argString = c < 16 ? String.valueOf(argString) + "0" + Integer.toHexString(c) : String.valueOf(argString) + Integer.toHexString(c);
        return argString;
    }

    private static byte[] fromHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] b = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = BIERKonfigurator.charToNibble(s.charAt(i));
            int low = BIERKonfigurator.charToNibble(s.charAt(i + 1));
            b[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return b;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public static String getIp() {
        return ip;
    }

    public static void setIp(String argIp) {
        ip = argIp;
    }

    public static boolean getVerbindung() {
        return verbindung;
    }

    public static void setVerbindung(boolean argVerbindung) {
        verbindung = argVerbindung;
        if (verbindung) {
            ip_config.setText("  Verbindung trennen     ");
            ip_config.setIcon(new ImageIcon(il.loadImageResource("togo_aus.png")));
            ip_config.setToolTipText("Trennt die Verbindung mit dem BIER");
        } else {
            ip_config.setText("  Verbinden mit BIER       ");
            ip_config.setIcon(new ImageIcon(il.loadImageResource("ip_config.png")));
            ip_config.setToolTipText("Stellt die Verbindung zu einem BIER her");
        }
    }

    public static void klickbareButtons(boolean argFreigabe) {
        ip_config.setEnabled(argFreigabe);
        com_config.setEnabled(argFreigabe);
        button_ende.setEnabled(argFreigabe);
        if (verbindung) {
            sende.setEnabled(true);
        } else {
            sende.setEnabled(false);
        }
    }

    public static String getSubnetz() {
        return subnetmask;
    }

    public static void setSubnetz(String argSubnetz) {
        subnetmask = argSubnetz;
    }

    public static void Aktualisierung() {
        ipadr.setText(ip);
        subnet.setText(subnetmask);
        DateiZugriff.setIpAdresse(ip);
        DateiZugriff.setSubnetzmaske(subnetmask);
        DateiZugriff.writeFile();
    }
}

