/*
 * Decompiled with CFR 0.152.
 */
package bsc_main;

import bsc_main.TCMPacket;
import bsc_main.ZerlegungZK;
import java.io.ByteArrayInputStream;

public class BAPMessage {
    public static final byte HEADERID_RRT = 0;
    public static final byte HEADERID_UNKNOWN1 = 1;
    public static final byte HEADERID_UNKNOWN2 = 2;
    public static final byte HEADERID_TRT = 3;
    public static final byte HEADERID_RMT = 4;
    public static final byte HEADERID_TCT = 5;
    public static final byte HEADERID_TCM = 8;
    public static final byte ORG_RPS = 5;
    public static final byte ORG_1BS = 6;
    public static final byte ORG_4BS = 7;
    public static final byte ORG_HRC = 8;
    public static final byte ORG_6DT = 10;
    public static final byte ORG_MDA = 11;
    public static final byte ERR_SYNTAX_H_SEQ = 8;
    public static final byte ERR_SYNTAX_LENGTH = 9;
    public static final byte ERR_SYNTAX_CHKSUM = 10;
    public static final byte ERR_SYNTAX_ORG = 11;
    public static final byte ERR_MODEM_DUP_ID = 12;
    public static final byte ERR = 25;
    public static final byte ERR_TX_IDRANGE = 34;
    public static final byte ERR_MODEM_NOTWANTEDACK = 40;
    public static final byte ERR_MODEM_NOTACK = 41;
    public static final byte OK = 88;
    public static final byte INF_RX_SENSITIVITY = -120;
    public static final byte INF_INIT = -119;
    public static final byte INF_SW_VER = -116;
    public static final byte INF_IDBASE = -104;
    public static final byte INF_MODEM_STATUS = -88;
    private long bapID = 0L;
    private byte[] message = null;
    private int byte0 = 0;
    private int byte1 = 0;
    private int byte2 = 0;
    private int byte3 = 0;
    private int dataBytes = 0;
    private long objectID = 0L;
    private long datum_uhrzeit = 0L;
    private boolean highspeedMessage = false;
    private int protocol = 1;
    private int orgByte = 0;
    private int headerID = 1;
    private int status = 0;
    private int signalStrength = 255;
    private int subtelegramCount = 0;
    private long destinationID = -1L;
    private int securityLevel = 0;

    public BAPMessage() {
    }

    public BAPMessage(String stringMessage) {
        this.message = new byte[14];
        if (stringMessage.length() > 28) {
            int[] rauten = ZerlegungZK.getRauten((String)stringMessage);
            this.bapID = Long.parseLong(stringMessage.substring(0, rauten[0]));
            int i = 0;
            while (i < 14) {
                this.message[i] = (byte)Integer.parseInt(stringMessage.substring(rauten[0] + i * 2 + 1, rauten[0] + i * 2 + 3), 16);
                ++i;
            }
            this.datum_uhrzeit = Long.parseLong(stringMessage.substring(rauten[1] + 1));
        } else {
            this.bapID = -1L;
            int i = 0;
            while (i < 14) {
                this.message[i] = (byte)Integer.parseInt(stringMessage.substring(i * 2, i * 2 + 2), 16);
                ++i;
            }
            this.datum_uhrzeit = -1L;
        }
        this.objectID = BAPMessage.byteArrToLong(this.message, 8);
        this.byte3 = BAPMessage.byteArrToInt(this.message, 4);
        this.byte2 = BAPMessage.byteArrToInt(this.message, 5);
        this.byte1 = BAPMessage.byteArrToInt(this.message, 6);
        this.byte0 = BAPMessage.byteArrToInt(this.message, 7);
        this.dataBytes = (this.message[4] & 0xFF) << 24 | (this.message[5] & 0xFF) << 16 | (this.message[6] & 0xFF) << 8 | this.message[7] & 0xFF;
        this.orgByte = this.message[3];
        this.headerID = BAPMessage.readBits(this.message[2], 0, 3);
        this.status = BAPMessage.byteArrToInt(this.message, 12);
        this.highspeedMessage = false;
    }

    public BAPMessage(TCMPacket packet, long bapID) {
        this(packet, bapID, System.currentTimeMillis());
    }

    public BAPMessage(TCMPacket packet, long bapID, long timestamp) {
        this.bapID = bapID;
        this.protocol = packet.protocol;
        this.message = packet.completeData;
        this.datum_uhrzeit = timestamp;
        this.highspeedMessage = true;
        switch (this.protocol) {
            case 1: {
                if (this.readESP2(packet)) break;
                this.headerID = 1;
                break;
            }
            case 2: {
                if (this.readESP3(packet)) break;
                this.headerID = 1;
            }
        }
    }

    public BAPMessage(byte[] message, long bapID) {
        this(message, bapID, System.currentTimeMillis());
    }

    public BAPMessage(byte[] message, long bapID, long timestamp) {
        this.bapID = bapID;
        this.message = message;
        this.objectID = BAPMessage.byteArrToLong(message, 8);
        this.byte3 = BAPMessage.byteArrToInt(message, 4);
        this.byte2 = BAPMessage.byteArrToInt(message, 5);
        this.byte1 = BAPMessage.byteArrToInt(message, 6);
        this.byte0 = BAPMessage.byteArrToInt(message, 7);
        this.datum_uhrzeit = timestamp;
        this.dataBytes = (message[4] & 0xFF) << 24 | (message[5] & 0xFF) << 16 | (message[6] & 0xFF) << 8 | message[7] & 0xFF;
        this.orgByte = message[3];
        this.headerID = BAPMessage.readBits(message[2], 0, 3);
        this.status = BAPMessage.byteArrToInt(message, 12);
        this.highspeedMessage = true;
    }

    private boolean readESP2(TCMPacket packet) {
        this.objectID = BAPMessage.byteArrToLong(this.message, 8);
        this.byte3 = BAPMessage.byteArrToInt(this.message, 4);
        this.byte2 = BAPMessage.byteArrToInt(this.message, 5);
        this.byte1 = BAPMessage.byteArrToInt(this.message, 6);
        this.byte0 = BAPMessage.byteArrToInt(this.message, 7);
        this.dataBytes = (this.message[4] & 0xFF) << 24 | (this.message[5] & 0xFF) << 16 | (this.message[6] & 0xFF) << 8 | this.message[7] & 0xFF;
        this.orgByte = this.message[3];
        this.headerID = BAPMessage.readBits(this.message[2], 0, 3);
        this.status = BAPMessage.byteArrToInt(this.message, 12);
        return true;
    }

    private boolean readESP3(TCMPacket packet) {
        if (packet.type != 1) {
            System.err.println(String.format("Packet type %d is not supported", packet.type));
            return false;
        }
        if (packet.optionalData != null) {
            byte[] optionalData = packet.optionalData;
            this.subtelegramCount = optionalData[0] & 0xFF;
            this.destinationID = 0L;
            this.destinationID |= (long)(optionalData[1] & 0xFF) << 24;
            this.destinationID |= (long)(optionalData[2] & 0xFF) << 16;
            this.destinationID |= (long)(optionalData[3] & 0xFF) << 8;
            this.destinationID |= (long)(optionalData[4] & 0xFF);
            this.signalStrength = optionalData[5] & 0xFF;
            this.securityLevel = optionalData[6] & 0xFF;
        }
        if (this.securityLevel != 0) {
            System.err.println(String.format("Security type %d is not supported", this.securityLevel));
            return false;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(packet.data);
        int choice = inputStream.read();
        switch (choice) {
            case 165: {
                this.orgByte = 7;
                break;
            }
            case 213: {
                this.orgByte = 6;
                break;
            }
            case 246: {
                this.orgByte = 5;
                break;
            }
            default: {
                System.err.println(String.format("Unsupported choice %d", choice));
                return false;
            }
        }
        switch (this.orgByte) {
            case 7: {
                this.byte3 = inputStream.read();
                this.byte2 = inputStream.read();
                this.byte1 = inputStream.read();
                this.byte0 = inputStream.read();
                break;
            }
            case 6: {
                this.byte3 = inputStream.read();
                break;
            }
            case 5: {
                this.byte3 = inputStream.read();
            }
        }
        this.objectID = 0L;
        this.objectID |= (long)(inputStream.read() & 0xFF) << 24;
        this.objectID |= (long)(inputStream.read() & 0xFF) << 16;
        this.objectID |= (long)(inputStream.read() & 0xFF) << 8;
        this.objectID |= (long)(inputStream.read() & 0xFF);
        this.status = inputStream.read();
        this.headerID = 0;
        return true;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public boolean isHighspeedMessage() {
        return this.highspeedMessage;
    }

    public void setHighspeedMessage(boolean highspeedMessage) {
        this.highspeedMessage = highspeedMessage;
    }

    public long getBapID() {
        return this.bapID;
    }

    public void setBapID(long bapID) {
        this.bapID = bapID;
    }

    public int getOrgByte() {
        return this.orgByte;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public int getHeaderID() {
        return this.headerID;
    }

    public int getStatus() {
        return this.status;
    }

    public int getByte0() {
        return this.byte0;
    }

    public void setByte0(int value) {
        this.byte0 = value;
    }

    public int getByte1() {
        return this.byte1;
    }

    public void setByte1(int value) {
        this.byte1 = value;
    }

    public int getByte2() {
        return this.byte2;
    }

    public void setByte2(int value) {
        this.byte2 = value;
    }

    public int getByte3() {
        return this.byte3;
    }

    public void setByte3(int value) {
        this.byte3 = value;
    }

    public int getDataBytes() {
        return this.dataBytes;
    }

    public void setUnsignedByte3(int value) {
        this.byte3 = value;
    }

    public long getDatum_uhrzeit() {
        return this.datum_uhrzeit;
    }

    public void setDatum_uhrzeit(long datum_uhrzeit) {
        this.datum_uhrzeit = datum_uhrzeit;
    }

    public void setObjectID(long objectID) {
        this.objectID = objectID;
    }

    public boolean isLearnButtonPressed() {
        return (this.byte0 & 8) == 0;
    }

    public boolean hasRegularData() {
        return this.isLearnButtonPressed() ? (this.byte0 & 0x80) == 0 : true;
    }

    public static int byteArrToInt(byte[] ar, int start) {
        int low = ar[start] & 0xFF;
        return low;
    }

    public static long byteArrToLong(byte[] ar, int start) {
        long ret = 0L;
        ret = (long)(ar[start] & 0xFF) << 24 | (long)((ar[start + 1] & 0xFF) << 16) | (long)((ar[start + 2] & 0xFF) << 8) | (long)(ar[start + 3] & 0xFF);
        return ret;
    }

    public static String reformMessage(byte[] message, long bapid) {
        StringBuffer newMessage = new StringBuffer(100);
        newMessage.append(String.valueOf(bapid));
        newMessage.append('#');
        newMessage.append(BAPMessage.getHexString(message));
        newMessage.append('#');
        newMessage.append(String.valueOf(System.currentTimeMillis()));
        return newMessage.toString();
    }

    public static String getHexString(byte[] bs) {
        StringBuffer ret = new StringBuffer(bs.length);
        int i = 0;
        while (i < bs.length) {
            String hex = Integer.toHexString(256 + (bs[i] & 0xFF)).substring(1);
            ret.append(String.valueOf(hex.length() < 2 ? "0" : "") + hex);
            ++i;
        }
        return ret.toString();
    }

    public static int readBits(int data, int offset, int length) {
        if (offset + length > 32 || offset < 0 || offset > 31) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int bitposition = 31 - offset;
        int result = 0;
        int i = 0;
        while (i < length) {
            result = result << 1 | data >> bitposition & 1;
            --bitposition;
            ++i;
        }
        return result;
    }

    public static int readBits(byte data, int offset, int length) {
        if (offset + length > 8 || offset < 0 || offset > 7) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int bitposition = 7 - offset;
        int result = 0;
        int i = 0;
        while (i < length) {
            result = result << 1 | data >> bitposition & 1;
            --bitposition;
            ++i;
        }
        return result;
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }
}

