/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter12Byte;

public class CharacterConverterShift
extends CharacterConverter12Byte {
    public final byte SHIFT_OUT = (byte)14;
    public final byte SHIFT_IN = (byte)15;

    public CharacterConverterShift() {
        this.m_groupId = 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 15;
        int n4 = 0;
        while (n4 < n) {
            char c;
            if (cArray[n4] >= '\ud800' && cArray[n4] < '\udc00') {
                if (n4 + 1 >= n || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                c = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                ++n4;
            } else {
                c = this.toOracleCharacter(cArray[n4], '\u0000');
            }
            int n5 = c & 0xFF00;
            if (n5 != 0) {
                if (n3 == 15) {
                    n3 = 14;
                    byArray[n2++] = 14;
                }
                byArray[n2++] = (byte)(n5 >> 8);
                byArray[n2++] = (byte)c;
            } else {
                if (n3 == 14) {
                    n3 = 15;
                    byArray[n2++] = 15;
                }
                byArray[n2++] = (byte)c;
            }
            ++n4;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 65535;
        int n3 = 0;
        int n4 = 15;
        int n5 = 0;
        while (n5 < n) {
            if (cArray[n5] >= '\ud800' && cArray[n5] < '\udc00') {
                if (n5 + 1 < n && cArray[n5 + 1] >= '\udc00' && cArray[n5 + 1] <= '\udfff') {
                    n2 = this.toOracleCharacterWithReplacement(cArray[n5], cArray[n5 + 1]);
                    ++n5;
                } else {
                    byArray[n3++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                    byArray[n3++] = (byte)this.m_2ByteOraCharReplacement;
                }
            } else {
                n2 = this.toOracleCharacterWithReplacement(cArray[n5], '\u0000');
            }
            int n6 = n2 & 0xFF00;
            if (n6 != 0) {
                if (n4 == 15) {
                    n4 = 14;
                    byArray[n3++] = 14;
                }
                byArray[n3++] = (byte)(n6 >> 8);
                byArray[n3++] = (byte)n2;
            } else {
                if (n4 == 14) {
                    n4 = 15;
                    byArray[n3++] = 15;
                }
                byArray[n3++] = (byte)n2;
            }
            ++n5;
        }
        if (n4 == 14) {
            n4 = 15;
            byArray[n3++] = 15;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        char[] cArray = new char[n2 * 2];
        int n4 = 0;
        int n5 = n;
        int n6 = 15;
        while (n5 < n3) {
            int n7;
            int n8;
            if (byArray[n5] == 15) {
                n6 = 15;
                ++n5;
                continue;
            }
            if (byArray[n5] == 14) {
                n6 = 14;
                ++n5;
                continue;
            }
            if (n6 == 15) {
                n8 = byArray[n5] & 0xFF;
                n7 = this.toUnicode(n8);
                if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n4++] = (char)(n7 >>> 16);
                    cArray[n4++] = (char)(n7 & 0xFFFF);
                } else {
                    cArray[n4++] = (char)n7;
                }
                ++n5;
                continue;
            }
            if (n5 < n3 - 1) {
                n8 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
                n7 = this.toUnicode(n8);
                if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n4++] = (char)(n7 >>> 16);
                    cArray[n4++] = (char)(n7 & 0xFFFF);
                } else {
                    cArray[n4++] = (char)n7;
                }
                n5 += 2;
                continue;
            }
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return new String(cArray, 0, n4);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        char[] cArray = new char[n2 * 2];
        int n4 = 0;
        int n5 = n;
        int n6 = 15;
        while (n5 < n3) {
            int n7;
            int n8;
            if (byArray[n5] == 15) {
                n6 = 15;
                ++n5;
                continue;
            }
            if (byArray[n5] == 14) {
                n6 = 14;
                ++n5;
                continue;
            }
            if (n6 == 15) {
                n8 = byArray[n5] & 0xFF;
                n7 = this.toUnicodeWithReplacement(n8);
                if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n4++] = (char)(n7 >>> 16);
                    cArray[n4++] = (char)(n7 & 0xFFFF);
                } else {
                    cArray[n4++] = (char)n7;
                }
                ++n5;
                continue;
            }
            if (n5 >= n3 - 1) break;
            n8 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
            n7 = this.toUnicodeWithReplacement(n8);
            if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                cArray[n4++] = (char)(n7 >>> 16);
                cArray[n4++] = (char)(n7 & 0xFFFF);
            } else {
                cArray[n4++] = (char)n7;
            }
            n5 += 2;
        }
        return new String(cArray, 0, n4);
    }
}

