/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;

public class LobDBAccessImpl
implements BlobDBAccess,
ClobDBAccess,
BfileDBAccess {
    OracleConnection m_conn;
    DBAccess m_dbaccess;

    public LobDBAccessImpl(OracleConnection oracleConnection) throws SQLException {
        if (oracleConnection == null) {
            DBError.throwSqlException(68, "connection is null");
        }
        this.m_conn = oracleConnection;
        this.m_dbaccess = oracleConnection.db_access;
    }

    public synchronized long length(BLOB bLOB) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.lobLength(bLOB);
    }

    public synchronized long position(BLOB bLOB, byte[] byArray, long l) throws SQLException {
        if (l < 1L) {
            DBError.throwSqlException(68, "position()");
        }
        long l2 = -1L;
        if (byArray != null && byArray.length != 0) {
            this.m_conn.needLine();
            long l3 = this.m_dbaccess.hasPattern(bLOB, byArray, l);
            l2 = l3 == 0L ? -1L : l3;
        }
        return l2;
    }

    public synchronized long position(BLOB bLOB, BLOB bLOB2, long l) throws SQLException {
        if (l < 1L) {
            DBError.throwSqlException(68, "position()");
        }
        long l2 = -1L;
        if (bLOB2 != null) {
            this.m_conn.needLine();
            long l3 = this.m_dbaccess.isSubLob(bLOB, bLOB2, l);
            l2 = l3 == 0L ? -1L : l3;
        }
        return l2;
    }

    public synchronized int getBytes(BLOB bLOB, long l, int n, byte[] byArray) throws SQLException {
        if (n < 0 || l < 1L || byArray == null) {
            DBError.throwSqlException(68, "getBytes()");
        }
        int n2 = 0;
        if (n != 0) {
            this.m_conn.needLine();
            n2 = (int)this.m_dbaccess.lobRead(bLOB, l, (long)n, byArray);
        }
        return n2;
    }

    public synchronized int putBytes(BLOB bLOB, long l, byte[] byArray, int n) throws SQLException {
        if (l < 1L) {
            DBError.throwSqlException(68, "putBytes()");
        }
        int n2 = 0;
        if (byArray == null || byArray.length == 0 || n <= 0) {
            n2 = 0;
        } else {
            this.m_conn.needLine();
            n2 = (int)this.m_dbaccess.lobWrite(bLOB, l, byArray, n);
        }
        return n2;
    }

    public synchronized int getChunkSize(BLOB bLOB) throws SQLException {
        this.m_conn.needLine();
        return (int)this.m_dbaccess.getLobChunkSize(bLOB);
    }

    public synchronized void trim(BLOB bLOB, long l) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.trimLob(bLOB.getConnection(), bLOB, 2004, l);
    }

    public synchronized BLOB createTemporaryBlob(Connection connection, boolean bl, int n) throws SQLException {
        this.m_conn.needLine();
        return (BLOB)this.m_dbaccess.createTemporaryLob(connection, bl, n, 2004);
    }

    public synchronized void freeTemporary(BLOB bLOB) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.freeTemporaryLob(bLOB.getConnection(), bLOB, 2004);
    }

    public synchronized boolean isTemporary(BLOB bLOB) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.isTemporaryLob(bLOB.getConnection(), bLOB, 2004);
    }

    public synchronized void open(BLOB bLOB, int n) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.openLob(bLOB.getConnection(), bLOB, n, 2004);
    }

    public synchronized void close(BLOB bLOB) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.closeLob(bLOB.getConnection(), bLOB, 2004);
    }

    public synchronized boolean isOpen(BLOB bLOB) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.isLobOpen(bLOB.getConnection(), bLOB, 2004);
    }

    public synchronized long length(CLOB cLOB) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.lobLength(cLOB);
    }

    public synchronized long position(CLOB cLOB, String string, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        long l2 = -1L;
        if (string != null && string.length() != 0) {
            this.m_conn.needLine();
            long l3 = this.m_dbaccess.hasPattern(cLOB, string.toCharArray(), l);
            l2 = l3 == 0L ? -1L : l3;
        }
        return l2;
    }

    public synchronized long position(CLOB cLOB, CLOB cLOB2, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position");
        }
        long l2 = -1L;
        if (cLOB2 != null) {
            this.m_conn.needLine();
            long l3 = this.m_dbaccess.isSubLob(cLOB, cLOB2, l);
            l2 = l3 == 0L ? -1L : l3;
        }
        return l2;
    }

    public synchronized int getChars(CLOB cLOB, long l, int n, char[] cArray) throws SQLException {
        if (n < 0 || l < 1L || cArray == null) {
            DBError.check_error(68, "getChars()");
        }
        int n2 = 0;
        if (n != 0) {
            this.m_conn.needLine();
            n2 = (int)this.m_dbaccess.lobRead(cLOB, l, (long)n, cArray);
        }
        return n2;
    }

    public synchronized int putChars(CLOB cLOB, long l, char[] cArray, int n) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "putChars()");
        }
        int n2 = 0;
        if (cArray == null || cArray.length < 0 || n <= 0) {
            n2 = 0;
        } else {
            this.m_conn.needLine();
            n2 = (int)this.m_dbaccess.lobWrite(cLOB, l, cArray, n);
        }
        return n2;
    }

    public synchronized int getChunkSize(CLOB cLOB) throws SQLException {
        this.m_conn.needLine();
        return (int)this.m_dbaccess.getLobChunkSize(cLOB);
    }

    public synchronized void trim(CLOB cLOB, long l) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.trimLob(cLOB.getConnection(), cLOB, 2005, l);
    }

    public synchronized CLOB createTemporaryClob(Connection connection, boolean bl, int n, short s) throws SQLException {
        this.m_conn.needLine();
        return (CLOB)this.m_dbaccess.createTemporaryLob(connection, bl, n, 2005, s);
    }

    public synchronized void freeTemporary(CLOB cLOB) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.freeTemporaryLob(cLOB.getConnection(), cLOB, 2005);
    }

    public synchronized boolean isTemporary(CLOB cLOB) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.isTemporaryLob(cLOB.getConnection(), cLOB, 2005);
    }

    public synchronized void open(CLOB cLOB, int n) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.openLob(cLOB.getConnection(), cLOB, n, 2005);
    }

    public synchronized void close(CLOB cLOB) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.closeLob(cLOB.getConnection(), cLOB, 2005);
    }

    public synchronized boolean isOpen(CLOB cLOB) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.isLobOpen(cLOB.getConnection(), cLOB, 2005);
    }

    public synchronized long length(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.lobLength(bFILE);
    }

    public synchronized int getBytes(BFILE bFILE, long l, int n, byte[] byArray) throws SQLException {
        if (l < 1L || n < 0 || byArray == null) {
            DBError.check_error(68, "getBytes()");
        }
        int n2 = 0;
        if (n != 0) {
            this.m_conn.needLine();
            n2 = (int)this.m_dbaccess.lobRead(bFILE, l, (long)n, byArray);
        }
        return n2;
    }

    public synchronized long position(BFILE bFILE, byte[] byArray, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        long l2 = -1L;
        if (byArray != null && byArray.length != 0) {
            this.m_conn.needLine();
            long l3 = this.m_dbaccess.hasPattern(bFILE, byArray, l);
            l2 = l3 == 0L ? -1L : l3;
        }
        return l2;
    }

    public synchronized long position(BFILE bFILE, BFILE bFILE2, long l) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "position()");
        }
        long l2 = -1L;
        if (bFILE2 != null) {
            this.m_conn.needLine();
            long l3 = this.m_dbaccess.isSubLob(bFILE, bFILE2, l);
            l2 = l3 == 0L ? -1L : l3;
        }
        return l2;
    }

    public synchronized String getName(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.fileGetName(bFILE);
    }

    public synchronized String getDirAlias(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.fileGetDirAlias(bFILE);
    }

    public synchronized void openFile(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.fileOpen(bFILE);
    }

    public synchronized boolean isFileOpen(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.fileIsOpen(bFILE);
    }

    public synchronized boolean fileExists(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.fileExists(bFILE);
    }

    public synchronized void closeFile(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.fileClose(bFILE);
    }

    public synchronized void open(BFILE bFILE, int n) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.openLob(bFILE.getConnection(), bFILE, n, -13);
    }

    public synchronized void close(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        this.m_dbaccess.closeLob(bFILE.getConnection(), bFILE, -13);
    }

    public synchronized boolean isOpen(BFILE bFILE) throws SQLException {
        this.m_conn.needLine();
        return this.m_dbaccess.isLobOpen(bFILE.getConnection(), bFILE, -13);
    }

    public InputStream newInputStream(BFILE bFILE, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleBlobInputStream(bFILE, n);
        }
        return new OracleBlobInputStream(bFILE, n, l);
    }

    public InputStream newConversionInputStream(BFILE bFILE, int n) throws SQLException {
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(bFILE.getConnection().conversion, bFILE.getBinaryStream(), n);
        return oracleConversionInputStream;
    }

    public Reader newConversionReader(BFILE bFILE, int n) throws SQLException {
        OracleConversionReader oracleConversionReader = new OracleConversionReader(bFILE.getConnection().conversion, bFILE.getBinaryStream(), n);
        return oracleConversionReader;
    }

    public InputStream newInputStream(BLOB bLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleBlobInputStream(bLOB, n);
        }
        return new OracleBlobInputStream(bLOB, n, l);
    }

    public OutputStream newOutputStream(BLOB bLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleBlobOutputStream(bLOB, n);
        }
        return new OracleBlobOutputStream(bLOB, n, l);
    }

    public InputStream newConversionInputStream(BLOB bLOB, int n) throws SQLException {
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(bLOB.getConnection().conversion, bLOB.getBinaryStream(), n);
        return oracleConversionInputStream;
    }

    public Reader newConversionReader(BLOB bLOB, int n) throws SQLException {
        OracleConversionReader oracleConversionReader = new OracleConversionReader(bLOB.getConnection().conversion, bLOB.getBinaryStream(), n);
        return oracleConversionReader;
    }

    public InputStream newInputStream(CLOB cLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleClobInputStream(cLOB, n);
        }
        return new OracleClobInputStream(cLOB, n, l);
    }

    public OutputStream newOutputStream(CLOB cLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleClobOutputStream(cLOB, n);
        }
        return new OracleClobOutputStream(cLOB, n, l);
    }

    public Reader newReader(CLOB cLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleClobReader(cLOB, n);
        }
        return new OracleClobReader(cLOB, n, l);
    }

    public Writer newWriter(CLOB cLOB, int n, long l) throws SQLException {
        if (l == 0L) {
            return new OracleClobWriter(cLOB, n);
        }
        return new OracleClobWriter(cLOB, n, l);
    }
}

