/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UTFDataFormatException;
import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTFE
extends CharacterSet
implements CharacterRepConstants {
    static final int MAXBYTEPERCHAR = 4;
    static byte[][] utf8m2utfe;
    static byte[][] utfe2utf8m;
    private static int[] m_byteLen;

    static {
        byte[][] byArrayArray = new byte[16][];
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 55;
        byArray[5] = 45;
        byArray[6] = 46;
        byArray[7] = 47;
        byArray[8] = 22;
        byArray[9] = 5;
        byArray[10] = 21;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArrayArray[0] = byArray;
        byArrayArray[1] = new byte[]{16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31};
        byArrayArray[2] = new byte[]{64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97};
        byArrayArray[3] = new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111};
        byArrayArray[4] = new byte[]{124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42};
        byArrayArray[5] = new byte[]{-41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -83, -32, -67, 95, 109};
        byArrayArray[6] = new byte[]{121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106};
        byArrayArray[7] = new byte[]{-105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7};
        byArrayArray[8] = new byte[]{32, 33, 34, 35, 36, 37, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27};
        byArrayArray[9] = new byte[]{48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1};
        byArrayArray[10] = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 81, 82, 83, 84, 85, 86};
        byArrayArray[11] = new byte[]{87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 114, 115};
        byArrayArray[12] = new byte[]{116, 117, 118, 119, 120, -128, -118, -117, -116, -115, -114, -113, -112, -102, -101, -100};
        byArrayArray[13] = new byte[]{-99, -98, -97, -96, -86, -85, -84, -82, -81, -80, -79, -78, -77, -76, -75, -74};
        byArrayArray[14] = new byte[]{-73, -72, -71, -70, -69, -68, -66, -65, -54, -53, -52, -51, -50, -49, -38, -37};
        byArrayArray[15] = new byte[]{-36, -35, -34, -33, -31, -22, -21, -20, -19, -18, -17, -6, -5, -4, -3, -2};
        utf8m2utfe = byArrayArray;
        byte[][] byArrayArray2 = new byte[16][];
        byte[] byArray2 = new byte[16];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = -100;
        byArray2[5] = 9;
        byArray2[6] = -122;
        byArray2[7] = 127;
        byArray2[8] = -105;
        byArray2[9] = -115;
        byArray2[10] = -114;
        byArray2[11] = 11;
        byArray2[12] = 12;
        byArray2[13] = 13;
        byArray2[14] = 14;
        byArray2[15] = 15;
        byArrayArray2[0] = byArray2;
        byArrayArray2[1] = new byte[]{16, 17, 18, 19, -99, 10, 8, -121, 24, 25, -110, -113, 28, 29, 30, 31};
        byArrayArray2[2] = new byte[]{-128, -127, -126, -125, -124, -123, 23, 27, -120, -119, -118, -117, -116, 5, 6, 7};
        byArrayArray2[3] = new byte[]{-112, -111, 22, -109, -108, -107, -106, 4, -104, -103, -102, -101, 20, 21, -98, 26};
        byArrayArray2[4] = new byte[]{32, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, 46, 60, 40, 43, 124};
        byArrayArray2[5] = new byte[]{38, -86, -85, -84, -83, -82, -81, -80, -79, -78, 33, 36, 42, 41, 59, 94};
        byArrayArray2[6] = new byte[]{45, 47, -77, -76, -75, -74, -73, -72, -71, -70, -69, 44, 37, 95, 62, 63};
        byArrayArray2[7] = new byte[]{-68, -67, -66, -65, -64, -63, -62, -61, -60, 96, 58, 35, 64, 39, 61, 34};
        byArrayArray2[8] = new byte[]{-59, 97, 98, 99, 100, 101, 102, 103, 104, 105, -58, -57, -56, -55, -54, -53};
        byArrayArray2[9] = new byte[]{-52, 106, 107, 108, 109, 110, 111, 112, 113, 114, -51, -50, -49, -48, -47, -46};
        byArrayArray2[10] = new byte[]{-45, 126, 115, 116, 117, 118, 119, 120, 121, 122, -44, -43, -42, 88, -41, -40};
        byArrayArray2[11] = new byte[]{-39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, 93, -26, -25};
        byArrayArray2[12] = new byte[]{123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -24, -23, -22, -21, -20, -19};
        byArrayArray2[13] = new byte[]{13, 74, 75, 76, 77, 78, 79, 80, 81, 82, -18, -17, -16, -15, -14, -13};
        byArrayArray2[14] = new byte[]{92, -12, 83, 84, 85, 86, 87, 88, 89, 90, -11, -10, -9, -8, -7, -6};
        byArrayArray2[15] = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -5, -4, -3, -2, -1, -97};
        utfe2utf8m = byArrayArray2;
        int[] nArray = new int[16];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 3;
        nArray[15] = 4;
        m_byteLen = nArray;
    }

    CharacterSetUTFE(int n) {
        super(n);
        this.rep = 3;
    }

    int UTFEToJavaChar(byte[] byArray, int n, int n2, char[] cArray, CharacterSet.CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        while (n3 < n4) {
            byte by = utfe2utf8m[CharacterSetUTFE.high(byArray[n3])][CharacterSetUTFE.low(byArray[n3++])];
            switch (by >>> 4 & 0xF) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)(by & 0x7F);
                    break;
                }
                case 8: 
                case 9: {
                    cArray[n5++] = (char)(by & 0x1F);
                    break;
                }
                case 12: 
                case 13: {
                    if (n3 >= n4) {
                        characterConverterBehavior.onFailConversion();
                        n3 = n4;
                        break;
                    }
                    by = (byte)(by & 0x1F);
                    byte by2 = utfe2utf8m[CharacterSetUTFE.high(byArray[n3])][CharacterSetUTFE.low(byArray[n3++])];
                    if (!CharacterSetUTFE.is101xxxxx(by2)) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n5++] = 65533;
                        break;
                    }
                    cArray[n5++] = (char)(by << 5 | by2 & 0x1F);
                    break;
                }
                case 14: {
                    if (n3 + 1 >= n4) {
                        characterConverterBehavior.onFailConversion();
                        n3 = n4;
                        break;
                    }
                    by = (byte)(by & 0xF);
                    byte by2 = utfe2utf8m[CharacterSetUTFE.high(byArray[n3])][CharacterSetUTFE.low(byArray[n3++])];
                    byte by3 = utfe2utf8m[CharacterSetUTFE.high(byArray[n3])][CharacterSetUTFE.low(byArray[n3++])];
                    if (!CharacterSetUTFE.is101xxxxx(by2) || !CharacterSetUTFE.is101xxxxx(by3)) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n5++] = 65533;
                        break;
                    }
                    cArray[n5++] = (char)(by << 10 | (by2 & 0x1F) << 5 | by3 & 0x1F);
                    break;
                }
                case 15: {
                    if (n3 + 2 >= n4) {
                        characterConverterBehavior.onFailConversion();
                        n3 = n4;
                        break;
                    }
                    by = (byte)(by & 1);
                    byte by2 = utfe2utf8m[CharacterSetUTFE.high(byArray[n3])][CharacterSetUTFE.low(byArray[n3++])];
                    byte by3 = utfe2utf8m[CharacterSetUTFE.high(byArray[n3])][CharacterSetUTFE.low(byArray[n3++])];
                    byte by4 = utfe2utf8m[CharacterSetUTFE.high(byArray[n3])][CharacterSetUTFE.low(byArray[n3++])];
                    if (!(CharacterSetUTFE.is101xxxxx(by2) && CharacterSetUTFE.is101xxxxx(by3) && CharacterSetUTFE.is101xxxxx(by4))) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n5++] = 65533;
                        break;
                    }
                    cArray[n5++] = (char)(by << 15 | (by2 & 0x1F) << 10 | (by3 & 0x1F) << 5 | by4 & 0x1F);
                    break;
                }
                default: {
                    characterConverterBehavior.onFailConversion();
                    cArray[n5++] = 65533;
                    break;
                }
            }
        }
        return n5;
    }

    public byte[] convert(String string) throws SQLException {
        return this.convertWithReplacement(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 3) {
            byArray2 = CharacterSet.useOrCopy(byArray, n, n2);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            byArray2 = this.convert(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 4];
        int n = this.javaCharsToUTFE(cArray, 0, cArray.length, byArray, 0);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n;
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        int n4 = 0;
        if (n2 >= n3) {
            CharacterSet.failUTFConversion();
        }
        if ((n = CharacterSetUTFE.getUTFByteLength(by = byArray[n2])) == 0 || n2 + (n - 1) >= n3) {
            CharacterSet.failUTFConversion();
        }
        try {
            char[] cArray = new char[2];
            int n5 = this.UTFEToJavaChar(byArray, n2, n, cArray, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
            characterWalker.next += n;
            if (n5 == 1) {
                return cArray[0];
            }
            return cArray[0] << 16 | cArray[1];
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            CharacterSet.failUTFConversion();
            characterWalker.next = n2;
            return n4;
        }
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        if ((n & 0xFFFF0000) != 0) {
            CharacterSet.failUTFConversion();
        } else {
            char[] cArray = new char[]{(char)n};
            if (n <= 31) {
                CharacterSet.need(characterBuffer, 1);
                int n2 = n | 0x80;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n2)][CharacterSetUTFE.low(n2)];
            } else if (n <= 127) {
                CharacterSet.need(characterBuffer, 1);
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n)][CharacterSetUTFE.low(n)];
            } else if (n <= 1023) {
                CharacterSet.need(characterBuffer, 2);
                int n3 = (n & 0x3E0) >> 5 | 0xC0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n3)][CharacterSetUTFE.low(n3)];
                n3 = n & 0x1F | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n3)][CharacterSetUTFE.low(n3)];
            } else if (n <= 16383) {
                CharacterSet.need(characterBuffer, 3);
                int n4 = (n & 0x3C00) >> 10 | 0xE0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n4)][CharacterSetUTFE.low(n4)];
                n4 = (n & 0x3E0) >> 5 | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n4)][CharacterSetUTFE.low(n4)];
                n4 = n & 0x1F | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n4)][CharacterSetUTFE.low(n4)];
            } else {
                CharacterSet.need(characterBuffer, 4);
                int n5 = (n & 0x8000) >> 15 | 0xF0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n5)][CharacterSetUTFE.low(n5)];
                n5 = (n & 0x7C00) >> 10 | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n5)][CharacterSetUTFE.low(n5)];
                n5 = (n & 0x3E0) >> 5 | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n5)][CharacterSetUTFE.low(n5)];
                n5 = n & 0x1F | 0xA0;
                characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n5)][CharacterSetUTFE.low(n5)];
            }
        }
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[utfe2utf8m[CharacterSetUTFE.high(by)][CharacterSetUTFE.low(by)] >>> 4 & 0xF];
    }

    private static int high(int n) {
        return n >> 4 & 0xF;
    }

    private static boolean is101xxxxx(byte by) {
        return (by & 0xFFFFFFE0) == -96;
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    int javaCharsToUTFE(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = n + n2;
        int n5 = 0;
        int n6 = n;
        while (n6 < n4) {
            int n7;
            char c = cArray[n6];
            if (c <= '\u001f') {
                n7 = c | 0x80;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
            } else if (c <= '\u007f') {
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(c)][CharacterSetUTFE.low(c)];
            } else if (c <= '\u03ff') {
                n7 = (c & 0x3E0) >> 5 | 0xC0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = c & 0x1F | 0xA0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
            } else if (c <= '\u3fff') {
                n7 = (c & 0x3C00) >> 10 | 0xE0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = (c & 0x3E0) >> 5 | 0xA0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = c & 0x1F | 0xA0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
            } else {
                n7 = (c & 0x8000) >> 15 | 0xF0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = (c & 0x7C00) >> 10 | 0xA0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = (c & 0x3E0) >> 5 | 0xA0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = c & 0x1F | 0xA0;
                byArray[n5++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
            }
            ++n6;
        }
        return n5;
    }

    private static int low(int n) {
        return n & 0xF;
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = this.UTFEToJavaChar(byArray, n, n2, cArray, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new SQLException(uTFDataFormatException.getMessage());
        }
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = this.UTFEToJavaChar(byArray, n, n2, cArray, CharacterSet.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new IllegalStateException(uTFDataFormatException.getMessage());
        }
    }
}

