/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UTFDataFormatException;
import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL32UTF8
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen;

    static {
        int[] nArray = new int[16];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 3;
        nArray[15] = 4;
        m_byteLen = nArray;
    }

    CharacterSetAL32UTF8(int n) {
        super(n);
        this.rep = 6;
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToAL32UTF8(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 6) {
            byArray2 = CharacterSet.useOrCopy(byArray, n, n2);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            byArray2 = CharacterSet.stringToAL32UTF8(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToAL32UTF8(string);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n;
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        if (n2 >= n3) {
            CharacterSet.failUTFConversion();
        }
        if ((n = CharacterSetAL32UTF8.getUTFByteLength(by = byArray[n2])) == 0 || n2 + (n - 1) >= n3) {
            CharacterSet.failUTFConversion();
        }
        try {
            char[] cArray = new char[2];
            int n4 = CharacterSet.AL32UTF8ToJavaChar(byArray, n2, n, cArray, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
            characterWalker.next += n;
            if (n4 == 1) {
                return cArray[0];
            }
            return cArray[0] << 16 | cArray[1];
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            CharacterSet.failUTFConversion();
            return 0;
        }
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2;
        if ((n & 0xFFFF0000) != 0) {
            CharacterSet.need(characterBuffer, 4);
            char[] cArray = new char[]{(char)(n >>> 16), (char)n};
            n2 = CharacterSet.javaCharsToAL32UTF8(cArray, 0, 2, characterBuffer.bytes, characterBuffer.next);
        } else {
            CharacterSet.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n};
            n2 = CharacterSet.javaCharsToAL32UTF8(cArray, 0, 1, characterBuffer.bytes, characterBuffer.next);
        }
        characterBuffer.next += n2;
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[by >>> 4 & 0xF];
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = CharacterSet.AL32UTF8ToJavaChar(byArray, n, n2, cArray, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            CharacterSet.failUTFConversion();
            return "";
        }
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = CharacterSet.AL32UTF8ToJavaChar(byArray, n, n2, cArray, CharacterSet.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return "";
        }
    }
}

