/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;

class ResultSetUtil {
    static final int[][] s_allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};

    ResultSetUtil() {
    }

    static OracleResultSet createScrollResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n) throws SQLException {
        switch (n) {
            case 1: {
                return oracleResultSet;
            }
            case 2: {
                return new UpdatableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 3: {
                return new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 4: {
                ScrollableResultSet scrollableResultSet = new ScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
                return new UpdatableResultSet(scrollRsetStatement, scrollableResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 5: {
                return new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
            case 6: {
                SensitiveScrollableResultSet sensitiveScrollableResultSet = new SensitiveScrollableResultSet(scrollRsetStatement, (OracleResultSetImpl)oracleResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
                return new UpdatableResultSet(scrollRsetStatement, sensitiveScrollableResultSet, ResultSetUtil.getScrollType(n), ResultSetUtil.getUpdateConcurrency(n));
            }
        }
        DBError.check_error(23, null);
        return null;
    }

    static String addIdentifierToSql(String string) throws SQLException {
        String string2 = string.toLowerCase();
        int n = string2.indexOf("select");
        if (n == -1) {
            DBError.throwSqlException(88);
        }
        return "select rowid," + string.substring(n + "select".length());
    }

    static String removeForUpdate(String string) throws SQLException {
        String string2 = string.toUpperCase();
        int n = string2.lastIndexOf("UPDATE");
        if (n == -1) {
            return string;
        }
        string2 = string2 + " '\"*/\n";
        int n2 = string.length();
        boolean bl = true;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 <= n) {
            char c;
            int n6 = ResultSetUtil.skipWhitespace(string2, n5, n2);
            if (n5 < n6) {
                bl = true;
                n5 = n6;
                if (n5 > n) break;
            }
            if ((c = string2.charAt(n5++)) == '\'') {
                while ((c = string2.charAt(n5++)) != '\'') {
                }
                continue;
            }
            if (c == '\"') {
                while ((c = string2.charAt(n5++)) != '\"') {
                }
                bl = true;
                continue;
            }
            if (!ResultSetUtil.isSqlIdentifierChar(c)) {
                bl = true;
                continue;
            }
            if (bl && c == 'F' && string2.charAt(n5) == 'O' && string2.charAt(++n5) == 'R') {
                int n7 = n5 - 2;
                if (++n5 == (n6 = ResultSetUtil.skipWhitespace(string2, n5, n))) continue;
                n5 = n6;
                if (n5 == n) {
                    if (ResultSetUtil.isSqlIdentifierChar(string2.charAt(n5 + 6))) break;
                    n5 = Math.min(n2, n5 + 6);
                    n3 = n7;
                    n4 = n5;
                    break;
                }
                if (string2.charAt(n5) == 'U' && string2.charAt(++n5) == 'P' && string2.charAt(++n5) == 'D' && string2.charAt(++n5) == 'A' && string2.charAt(++n5) == 'T' && string2.charAt(++n5) == 'E' && !ResultSetUtil.isSqlIdentifierChar(string2.charAt(++n5))) {
                    n3 = n7;
                    n4 = n5;
                    bl = true;
                    continue;
                }
                bl = !ResultSetUtil.isSqlIdentifierChar(string2.charAt(n5));
                continue;
            }
            bl = false;
        }
        String string3 = n3 > -1 ? string.substring(0, n3) + string.substring(n4, n2) : string;
        return string3;
    }

    static boolean isSqlIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '#' || c == '.' || c == '@';
    }

    static int skipWhitespace(String string, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (!Character.isWhitespace(c)) {
                if (c == '/' && string.charAt(n3 + 1) == '*') {
                    while ((c = string.charAt(++n3)) != '*' || string.charAt(++n3) != '/') {
                    }
                } else {
                    if (c == '-' && string.charAt(n3 + 1) == '-') {
                        n3 += 2;
                        while (string.charAt(n3++) != '\n') {
                        }
                    }
                    return n3;
                }
            }
            ++n3;
        }
        return n3;
    }

    static int getScrollType(int n) {
        return s_allRsetTypes[n][0];
    }

    static int getUpdateConcurrency(int n) {
        return s_allRsetTypes[n][1];
    }

    static int getRsetTypeCode(int n, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < s_allRsetTypes.length) {
            if (s_allRsetTypes[n3][0] == n && s_allRsetTypes[n3][1] == n2) {
                return n3;
            }
            ++n3;
        }
        DBError.throwSqlException(68);
        return 0;
    }

    public static boolean needIdentifier(int n) throws SQLException {
        return n != 1 && n != 3;
    }

    public static boolean needIdentifier(int n, int n2) throws SQLException {
        return ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(n, n2));
    }

    public static boolean needCache(int n) throws SQLException {
        return n >= 3;
    }

    public static boolean needCache(int n, int n2) throws SQLException {
        return ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(n, n2));
    }

    public static boolean supportRefreshRow(int n) throws SQLException {
        return n >= 4;
    }

    public static boolean supportRefreshRow(int n, int n2) throws SQLException {
        return ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(n, n2));
    }
}

