/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.firmware;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.components.JWizardHeader;
import de.bsc.bapfinder.components.ProgressDialog;
import de.bsc.bapfinder.plugins.Plugin;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.plugins.firmware.Firmware;
import de.bsc.bapfinder.plugins.firmware.localization.Messages;
import de.bsc.bapfinder.tools.RandomArrayStream;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FirmwareDialog
extends JDialog
implements ActionListener,
IBAPFinder.IBAPListener {
    private static final long serialVersionUID = 7994091209853624124L;
    private static final int COMMAND_REBOOT = 4;
    private static final int MESSAGE_COMMAND = 1;
    private static final int MESSAGE_FIRMWARE_INIT = 6;
    private static final int MESSAGE_FIRMWARE_DATA = 7;
    private static final int MESSAGE_FIRMWARE_STATE = 8;
    private static final int MESSAGE_FIRMWARE_WRITE = 9;
    private static final int MESSAGE_FIRMWARE_COMPLETE = 10;
    private static final int ERROR_INIT_FAILED = 1;
    private static final int ERROR_RECEIVE_FAILED = 2;
    private static final int ERROR_WRITE_FAILED = 3;
    private static final int ERROR_ALREADY_INITIALIZED = 4;
    private static final int ERROR_NOT_INITIALIZED = 5;
    private static final int STATE_INIT_OK = 1;
    private static final int STATE_RECEIVE_OK = 2;
    private static final int STATE_WRITE_OK = 3;
    private static final int STATE_COMPLETE = 4;
    private static final int STATE_TYPE_STATE = 1;
    private static final int STATE_TYPE_ERROR = 2;
    private static File lastDirectory = new File(".");
    private JPanel jContentPane;
    private IBAPFinder.IBAP bap;
    private IBAPFinder.IBAP bapBackup;
    private String mac;
    private Window owner;
    private RandomArrayStream firmware;
    private IBAPFinder api;
    private Firmware plugin;
    private JWizardHeader wizardHeader;
    private JPanel panelSettings;
    private JPanel panelButtons;
    private JButton buttonCommit;
    private JButton buttonClose;
    private JPanel panelFirmwareCurrent;
    private JPanel panelVersionCurrent;
    private JTextField textFieldVersionCurrent;
    private JPanel panelFeaturesCurrent;
    private JTextField textFieldFeaturesCurrent;
    private JPanel panelFirmwareNew;
    private JPanel panelVersionNew;
    private JTextField textFieldVersionNew;
    private JPanel panelFeaturesNew;
    private JTextField textFieldFeaturesNew;
    private JPanel panelFirmwareNewButtons;
    private JButton buttonInternet;
    private JButton buttonFile;
    private JLabel labelFirmwareNew;

    public FirmwareDialog(Firmware plugin) {
        super(plugin.api.getWindow());
        this.plugin = plugin;
        this.api = plugin.api;
        this.owner = this.api.getWindow();
        this.bap = this.api.getSelectedBAP();
        this.bapBackup = this.bap.clone();
        this.mac = this.bap.getMac();
        this.initialize();
        this.setLocationRelativeTo(this.owner);
        this.setModal(true);
        this.updateTextFields();
    }

    private void initialize() {
        this.setSize(444, 353);
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(false);
        this.api.addBAPListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                FirmwareDialog.this.api.removeBAPListener(FirmwareDialog.this);
            }
        });
    }

    private File getFile(String argTitle) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(lastDirectory);
        chooser.setDialogTitle(argTitle);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("*.bin", "bin"));
        chooser.setMultiSelectionEnabled(false);
        int state = chooser.showOpenDialog(this);
        if (state == 1) {
            return null;
        }
        File file = chooser.getSelectedFile();
        lastDirectory = file.isDirectory() ? file : file.getParentFile();
        return file;
    }

    private void setNewVersion(long version) {
        String text = String.format("%d", version);
        this.textFieldVersionNew.setText(text);
    }

    private void setNewCommands(long commands) {
    }

    private void setNewFeatures(long features) {
        String text = "";
        int count = 0;
        if (Tools.isFlagSet(features, 1L)) {
            text = String.valueOf(text) + "HS";
            ++count;
        }
        if (Tools.isFlagSet(features, 2L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = Tools.isFlagSet(features, 16L) ? String.valueOf(text) + "SA-E" : String.valueOf(text) + "SA";
            ++count;
        }
        if (Tools.isFlagSet(features, 64L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + "E3";
            ++count;
        }
        if (Tools.isFlagSet(features, 512L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + "D";
            ++count;
        }
        if (Tools.isFlagSet(features, 4096L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + "C";
            ++count;
        }
        if (Tools.isFlagSet(features, 8192L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + "B";
            ++count;
        }
        this.textFieldFeaturesNew.setText(text);
    }

    @Override
    public void bapReceived(IBAPFinder.IBAP bap) {
        if (this.bap != null || !bap.getMac().equals(this.mac) || !bap.isOnline()) {
            return;
        }
        this.bap = bap;
        this.updateTextFields();
    }

    private void updateTextFields() {
        String text = "";
        int count = 0;
        if (this.bap.hasFeature(1L)) {
            text = String.valueOf(text) + "HS";
            ++count;
        }
        if (this.bap.hasFeature(2L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = this.bap.hasFeature(16L) ? String.valueOf(text) + "SA-E" : String.valueOf(text) + "SA";
            ++count;
        }
        if (this.bap.hasFeature(64L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + "E3";
            ++count;
        }
        if (this.bap.hasFeature(512L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + "D";
            ++count;
        }
        if (this.bap.hasFeature(4096L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + "C";
            ++count;
        }
        if (this.bap.hasFeature(8192L)) {
            if (count > 0) {
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + "B";
            ++count;
        }
        this.textFieldFeaturesCurrent.setText(text);
        text = String.format("%d", this.bap.getVersion());
        this.textFieldVersionCurrent.setText(text);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints constraintsPanelButtons = new GridBagConstraints();
            constraintsPanelButtons.gridx = 0;
            constraintsPanelButtons.fill = 2;
            constraintsPanelButtons.gridy = 2;
            GridBagConstraints constraintsPanelSettings = new GridBagConstraints();
            constraintsPanelSettings.gridx = 0;
            constraintsPanelSettings.fill = 1;
            constraintsPanelSettings.weightx = 1.0;
            constraintsPanelSettings.weighty = 1.0;
            constraintsPanelSettings.gridy = 1;
            GridBagConstraints constraintsWizardHeader = new GridBagConstraints();
            constraintsWizardHeader.gridx = 0;
            constraintsWizardHeader.fill = 2;
            constraintsWizardHeader.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getWizardHeader(), constraintsWizardHeader);
            this.jContentPane.add((Component)this.getPanelSettings(), constraintsPanelSettings);
            this.jContentPane.add((Component)this.getPanelButtons(), constraintsPanelButtons);
        }
        return this.jContentPane;
    }

    private JWizardHeader getWizardHeader() {
        if (this.wizardHeader == null) {
            this.wizardHeader = new JWizardHeader();
            this.wizardHeader.setImage(this.plugin.loadImage("memory.png"));
            this.wizardHeader.setTextHeader1(Messages.getString("FirmwareDialog.84"));
            this.wizardHeader.setTextHeader2(Messages.getString("FirmwareDialog.34"));
        }
        return this.wizardHeader;
    }

    private JPanel getPanelSettings() {
        if (this.panelSettings == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.anchor = 10;
            gridBagConstraints11.weighty = 0.0;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridy = 0;
            this.panelSettings = new JPanel();
            this.panelSettings.setLayout(new GridBagLayout());
            this.panelSettings.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelSettings.add((Component)this.getPanelFirmwareCurrent(), gridBagConstraints5);
            this.panelSettings.add((Component)this.getPanelFirmwareNew(), gridBagConstraints11);
        }
        return this.panelSettings;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(5, 0, 5, 5);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.anchor = 13;
            this.panelButtons = new JPanel();
            this.panelButtons.setLayout(new GridBagLayout());
            this.panelButtons.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelButtons.add((Component)this.getButtonCommit(), gridBagConstraints3);
            this.panelButtons.add((Component)this.getButtonClose(), gridBagConstraints4);
        }
        return this.panelButtons;
    }

    private JButton getButtonCommit() {
        if (this.buttonCommit == null) {
            this.buttonCommit = new JButton();
            this.buttonCommit.setFont(new Font("Tahoma", 0, 11));
            this.buttonCommit.setText(Messages.getString("FirmwareDialog.36"));
            this.buttonCommit.setPreferredSize(new Dimension(100, 25));
            this.buttonCommit.setEnabled(false);
            this.buttonCommit.setMaximumSize(new Dimension(100, 24));
            this.buttonCommit.setMinimumSize(new Dimension(100, 24));
            this.buttonCommit.setActionCommand("commit");
            this.buttonCommit.addActionListener(this);
        }
        return this.buttonCommit;
    }

    private JButton getButtonClose() {
        if (this.buttonClose == null) {
            this.buttonClose = new JButton();
            this.buttonClose.setFont(new Font("Tahoma", 0, 11));
            this.buttonClose.setText(Messages.getString("FirmwareDialog.1"));
            this.buttonClose.setPreferredSize(new Dimension(100, 25));
            this.buttonClose.setMaximumSize(new Dimension(100, 24));
            this.buttonClose.setMinimumSize(new Dimension(100, 24));
            this.buttonClose.setActionCommand("close");
            this.buttonClose.addActionListener(this);
        }
        return this.buttonClose;
    }

    private JPanel getPanelFirmwareCurrent() {
        if (this.panelFirmwareCurrent == null) {
            GridBagConstraints constraintsPanelFeaturesCurrent = new GridBagConstraints();
            constraintsPanelFeaturesCurrent.gridx = 1;
            constraintsPanelFeaturesCurrent.fill = 2;
            constraintsPanelFeaturesCurrent.weightx = 1.0;
            constraintsPanelFeaturesCurrent.gridy = 0;
            GridBagConstraints constraintsPanelVersionCurrent = new GridBagConstraints();
            constraintsPanelVersionCurrent.gridx = 0;
            constraintsPanelVersionCurrent.fill = 2;
            constraintsPanelVersionCurrent.weightx = 1.0;
            constraintsPanelVersionCurrent.gridy = 0;
            this.panelFirmwareCurrent = new JPanel();
            this.panelFirmwareCurrent.setLayout(new GridBagLayout());
            this.panelFirmwareCurrent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("FirmwareDialog.41"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelFirmwareCurrent.add((Component)this.getPanelVersionCurrent(), constraintsPanelVersionCurrent);
            this.panelFirmwareCurrent.add((Component)this.getPanelFeaturesCurrent(), constraintsPanelFeaturesCurrent);
        }
        return this.panelFirmwareCurrent;
    }

    private JPanel getPanelVersionCurrent() {
        if (this.panelVersionCurrent == null) {
            GridBagConstraints constraintsTextFieldVersionCurrent = new GridBagConstraints();
            constraintsTextFieldVersionCurrent.fill = 2;
            constraintsTextFieldVersionCurrent.gridy = 0;
            constraintsTextFieldVersionCurrent.weightx = 1.0;
            constraintsTextFieldVersionCurrent.gridx = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 3;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridx = 0;
            this.panelVersionCurrent = new JPanel();
            this.panelVersionCurrent.setLayout(new GridBagLayout());
            this.panelVersionCurrent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("FirmwareDialog.43"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelVersionCurrent.setPreferredSize(new Dimension(10, 54));
            this.panelVersionCurrent.add((Component)this.getTextFieldVersionCurrent(), constraintsTextFieldVersionCurrent);
        }
        return this.panelVersionCurrent;
    }

    private JTextField getTextFieldVersionCurrent() {
        if (this.textFieldVersionCurrent == null) {
            this.textFieldVersionCurrent = new JTextField();
            this.textFieldVersionCurrent.setFont(new Font("Tahoma", 0, 11));
            this.textFieldVersionCurrent.setEditable(false);
        }
        return this.textFieldVersionCurrent;
    }

    private JPanel getPanelFeaturesCurrent() {
        if (this.panelFeaturesCurrent == null) {
            GridBagConstraints constraintsTextFieldFeaturesCurrent = new GridBagConstraints();
            constraintsTextFieldFeaturesCurrent.fill = 2;
            constraintsTextFieldFeaturesCurrent.gridy = 0;
            constraintsTextFieldFeaturesCurrent.weightx = 1.0;
            constraintsTextFieldFeaturesCurrent.gridx = 0;
            this.panelFeaturesCurrent = new JPanel();
            this.panelFeaturesCurrent.setLayout(new GridBagLayout());
            this.panelFeaturesCurrent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("FirmwareDialog.46"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelFeaturesCurrent.setPreferredSize(new Dimension(10, 54));
            this.panelFeaturesCurrent.add((Component)this.getTextFieldFeaturesCurrent(), constraintsTextFieldFeaturesCurrent);
        }
        return this.panelFeaturesCurrent;
    }

    private JTextField getTextFieldFeaturesCurrent() {
        if (this.textFieldFeaturesCurrent == null) {
            this.textFieldFeaturesCurrent = new JTextField();
            this.textFieldFeaturesCurrent.setEditable(false);
            this.textFieldFeaturesCurrent.setFont(new Font("Tahoma", 0, 11));
        }
        return this.textFieldFeaturesCurrent;
    }

    private JPanel getPanelFirmwareNew() {
        if (this.panelFirmwareNew == null) {
            GridBagConstraints constraintsPanelFirmwareNewButtons = new GridBagConstraints();
            constraintsPanelFirmwareNewButtons.gridx = 0;
            constraintsPanelFirmwareNewButtons.gridwidth = 2;
            constraintsPanelFirmwareNewButtons.fill = 2;
            constraintsPanelFirmwareNewButtons.insets = new Insets(0, 2, 0, 2);
            constraintsPanelFirmwareNewButtons.gridy = 1;
            GridBagConstraints constraintsFeaturesNew = new GridBagConstraints();
            constraintsFeaturesNew.gridx = 1;
            constraintsFeaturesNew.fill = 2;
            constraintsFeaturesNew.weightx = 1.0;
            constraintsFeaturesNew.gridy = 0;
            GridBagConstraints constraintsPanelVersionNew = new GridBagConstraints();
            constraintsPanelVersionNew.gridx = 0;
            constraintsPanelVersionNew.fill = 2;
            constraintsPanelVersionNew.weightx = 1.0;
            constraintsPanelVersionNew.gridy = 0;
            this.panelFirmwareNew = new JPanel();
            this.panelFirmwareNew.setLayout(new GridBagLayout());
            this.panelFirmwareNew.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("FirmwareDialog.49"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelFirmwareNew.add((Component)this.getPanelVersionNew(), constraintsPanelVersionNew);
            this.panelFirmwareNew.add((Component)this.getPanelFeaturesNew(), constraintsFeaturesNew);
            this.panelFirmwareNew.add((Component)this.getPanelFirmwareNewButtons(), constraintsPanelFirmwareNewButtons);
        }
        return this.panelFirmwareNew;
    }

    private JPanel getPanelVersionNew() {
        if (this.panelVersionNew == null) {
            GridBagConstraints constraintsTextFieldFirmwareNew = new GridBagConstraints();
            constraintsTextFieldFirmwareNew.fill = 2;
            constraintsTextFieldFirmwareNew.gridy = 0;
            constraintsTextFieldFirmwareNew.weightx = 1.0;
            constraintsTextFieldFirmwareNew.gridx = 0;
            this.panelVersionNew = new JPanel();
            this.panelVersionNew.setLayout(new GridBagLayout());
            this.panelVersionNew.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("FirmwareDialog.43"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelVersionNew.setPreferredSize(new Dimension(10, 54));
            this.panelVersionNew.add((Component)this.getTextFieldFirmwareNew(), constraintsTextFieldFirmwareNew);
        }
        return this.panelVersionNew;
    }

    private JTextField getTextFieldFirmwareNew() {
        if (this.textFieldVersionNew == null) {
            this.textFieldVersionNew = new JTextField();
            this.textFieldVersionNew.setEditable(false);
            this.textFieldVersionNew.setFont(new Font("Tahoma", 0, 11));
        }
        return this.textFieldVersionNew;
    }

    private JPanel getPanelFeaturesNew() {
        if (this.panelFeaturesNew == null) {
            GridBagConstraints constraintsTextFieldFeaturesNew = new GridBagConstraints();
            constraintsTextFieldFeaturesNew.fill = 2;
            constraintsTextFieldFeaturesNew.gridy = 0;
            constraintsTextFieldFeaturesNew.weightx = 1.0;
            constraintsTextFieldFeaturesNew.gridx = 0;
            this.panelFeaturesNew = new JPanel();
            this.panelFeaturesNew.setLayout(new GridBagLayout());
            this.panelFeaturesNew.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("FirmwareDialog.46"), 0, 2, new Font("Tahoma", 0, 11), new Color(59, 59, 59)));
            this.panelFeaturesNew.setPreferredSize(new Dimension(10, 54));
            this.panelFeaturesNew.add((Component)this.getTextFieldFeaturesNew(), constraintsTextFieldFeaturesNew);
        }
        return this.panelFeaturesNew;
    }

    private JTextField getTextFieldFeaturesNew() {
        if (this.textFieldFeaturesNew == null) {
            this.textFieldFeaturesNew = new JTextField();
            this.textFieldFeaturesNew.setEditable(false);
            this.textFieldFeaturesNew.setFont(new Font("Tahoma", 0, 11));
        }
        return this.textFieldFeaturesNew;
    }

    private JPanel getPanelFirmwareNewButtons() {
        if (this.panelFirmwareNewButtons == null) {
            GridBagConstraints constraintsLabelFirmwareNew = new GridBagConstraints();
            constraintsLabelFirmwareNew.gridx = 0;
            constraintsLabelFirmwareNew.insets = new Insets(0, 5, 0, 0);
            constraintsLabelFirmwareNew.weightx = 1.0;
            constraintsLabelFirmwareNew.anchor = 17;
            constraintsLabelFirmwareNew.gridy = 0;
            this.labelFirmwareNew = new JLabel();
            this.labelFirmwareNew.setText(Messages.getString("FirmwareDialog.57"));
            this.labelFirmwareNew.setMinimumSize(new Dimension(200, 14));
            this.labelFirmwareNew.setMaximumSize(new Dimension(200, 14));
            this.labelFirmwareNew.setPreferredSize(new Dimension(200, 14));
            this.labelFirmwareNew.setFont(new Font("Tahoma", 0, 11));
            GridBagConstraints constraintsButtonFile = new GridBagConstraints();
            constraintsButtonFile.gridx = 2;
            constraintsButtonFile.insets = new Insets(5, 0, 5, 2);
            constraintsButtonFile.anchor = 13;
            constraintsButtonFile.weightx = 0.0;
            constraintsButtonFile.gridy = 0;
            GridBagConstraints constraintsButtonInternet = new GridBagConstraints();
            constraintsButtonInternet.gridx = 1;
            constraintsButtonInternet.insets = new Insets(5, 5, 5, 2);
            constraintsButtonInternet.anchor = 13;
            constraintsButtonInternet.fill = 0;
            constraintsButtonInternet.weightx = 0.0;
            constraintsButtonInternet.gridy = 0;
            this.panelFirmwareNewButtons = new JPanel();
            this.panelFirmwareNewButtons.setLayout(new GridBagLayout());
            this.panelFirmwareNewButtons.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelFirmwareNewButtons.add((Component)this.getButtonInternet(), constraintsButtonInternet);
            this.panelFirmwareNewButtons.add((Component)this.getButtonFile(), constraintsButtonFile);
            this.panelFirmwareNewButtons.add((Component)this.labelFirmwareNew, constraintsLabelFirmwareNew);
        }
        return this.panelFirmwareNewButtons;
    }

    private JButton getButtonInternet() {
        if (this.buttonInternet == null) {
            this.buttonInternet = new JButton();
            this.buttonInternet.setPreferredSize(new Dimension(100, 24));
            this.buttonInternet.setFont(new Font("Tahoma", 0, 11));
            this.buttonInternet.setMinimumSize(new Dimension(100, 26));
            this.buttonInternet.setMaximumSize(new Dimension(100, 26));
            this.buttonInternet.setText(Messages.getString("FirmwareDialog.60"));
            this.buttonInternet.setActionCommand("network");
            this.buttonInternet.addActionListener(this);
        }
        return this.buttonInternet;
    }

    private JButton getButtonFile() {
        if (this.buttonFile == null) {
            this.buttonFile = new JButton();
            this.buttonFile.setPreferredSize(new Dimension(100, 24));
            this.buttonFile.setFont(new Font("Tahoma", 0, 11));
            this.buttonFile.setMinimumSize(new Dimension(100, 26));
            this.buttonFile.setMaximumSize(new Dimension(100, 26));
            this.buttonFile.setText(Messages.getString("FirmwareDialog.63"));
            this.buttonFile.setActionCommand("file");
            this.buttonFile.addActionListener(this);
        }
        return this.buttonFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("close")) {
            this.setVisible(false);
            this.dispose();
        } else if (command.equals("commit")) {
            SwingWorker<Void, Integer> task = new SwingWorker<Void, Integer>(){

                @Override
                protected Void doInBackground() {
                    RandomArrayStream stream = new RandomArrayStream();
                    try {
                        try {
                            try {
                                FirmwareDialog.this.firmware.seek(16);
                                long features = FirmwareDialog.this.firmware.readLong();
                                FirmwareDialog.this.firmware.seek(256);
                                stream.writeInt(FirmwareDialog.this.firmware.available());
                                stream.writeLong(features);
                            }
                            catch (IOException e1) {
                                throw new PluginException(e1);
                            }
                            this.firePropertyChange("progressMax", null, FirmwareDialog.this.firmware.available() * 2);
                            this.firePropertyChange("progressInfo", null, Messages.getString("FirmwareDialog.69"));
                            IBAPFinder.IMessage message = FirmwareDialog.this.api.sendToConfigPort(FirmwareDialog.this.bap, 6, stream, true, 60000);
                            if (message.getMessageType() != 1) {
                                throw new PluginException(2);
                            }
                            if (message.getDataType() != 8) {
                                throw new PluginException(4);
                            }
                            if (message.getData().readInt() != 1) {
                                throw new PluginException(5);
                            }
                            int zaehler = 0;
                            while (FirmwareDialog.this.firmware.available() > 0) {
                                byte[] data;
                                int length;
                                try {
                                    length = FirmwareDialog.this.firmware.readInt();
                                    data = new byte[length];
                                    FirmwareDialog.this.firmware.read(data);
                                }
                                catch (IOException e1) {
                                    throw new PluginException(e1);
                                }
                                this.firePropertyChange("progressInfo", null, Messages.getString("FirmwareDialog.71"));
                                stream.seek(0);
                                stream.trim();
                                stream.writeInt(length);
                                stream.write(data);
                                message = FirmwareDialog.this.api.sendToConfigPort(FirmwareDialog.this.bap, 7, stream, true, 60000);
                                if (message.getMessageType() != 1) {
                                    throw new PluginException(2);
                                }
                                if (message.getDataType() != 8) {
                                    throw new PluginException(4);
                                }
                                if (message.getData().readInt() != 1) {
                                    throw new PluginException(3);
                                }
                                this.firePropertyChange("progress", null, zaehler += length);
                                this.firePropertyChange("progressInfo", null, Messages.getString("FirmwareDialog.74"));
                                message = FirmwareDialog.this.api.sendToConfigPort(FirmwareDialog.this.bap, 9, null, true, 60000);
                                if (message.getMessageType() != 1) {
                                    throw new PluginException(2);
                                }
                                if (message.getDataType() != 8) {
                                    throw new PluginException(4);
                                }
                                if (message.getData().readInt() != 1) {
                                    throw new PluginException(3);
                                }
                                this.firePropertyChange("progress", null, zaehler += length);
                            }
                            this.firePropertyChange("progressInfo", null, Messages.getString("FirmwareDialog.77"));
                            this.firePropertyChange("indeterminate", null, true);
                            message = FirmwareDialog.this.api.sendToConfigPort(FirmwareDialog.this.bap, 10, null, true, 240000);
                            if (message.getMessageType() != 1) {
                                throw new PluginException(2);
                            }
                            if (message.getDataType() != 8) {
                                throw new PluginException(4);
                            }
                            if (message.getData().readInt() != 1) {
                                throw new PluginException(3);
                            }
                            stream.seek(0);
                            stream.trim();
                            stream.writeInt(4);
                            FirmwareDialog.this.api.sendToConfigPort(FirmwareDialog.this.bap, 1, stream);
                            this.firePropertyChange("progressInfo", null, Messages.getString("FirmwareDialog.80"));
                            this.firePropertyChange("indeterminate", null, true);
                            FirmwareDialog.this.api.removeBAP(FirmwareDialog.this.bap.getMac());
                            FirmwareDialog.this.bap = null;
                            long starttime = System.currentTimeMillis();
                            while (FirmwareDialog.this.bap == null && starttime + 120000L > System.currentTimeMillis()) {
                                Thread.sleep(10L);
                            }
                            if (FirmwareDialog.this.bap == null) {
                                throw new PluginException(6);
                            }
                            FirmwareDialog.this.firmware.close();
                            FirmwareDialog.this.firmware = null;
                        }
                        catch (Exception e1) {
                            this.firePropertyChange("state", null, (Object)SwingWorker.StateValue.DONE);
                            FirmwareDialog.this.processError(e1);
                            stream.close();
                            return null;
                        }
                    }
                    finally {
                        stream.close();
                    }
                    this.firePropertyChange("state", null, (Object)SwingWorker.StateValue.DONE);
                    FirmwareDialog.this.processSuccess();
                    return null;
                }
            };
            ProgressDialog<Void, Integer> progressDialog = new ProgressDialog<Void, Integer>((Window)this, Messages.getString("FirmwareDialog.84"), task, false);
            progressDialog.setImage(this.plugin.loadImage("memory.png"));
            task.execute();
        } else if (command.equals("file")) {
            File file = this.getFile(Messages.getString("FirmwareDialog.87"));
            if (file == null) {
                return;
            }
            RandomArrayStream stream = new RandomArrayStream();
            long header = 0L;
            long version = 0L;
            long features = 0L;
            long commands = 0L;
            try {
                stream.load(file);
                header = stream.readLong();
                if (header != 424150L) {
                    throw new IOException("1");
                }
                version = stream.readLong();
                features = stream.readLong();
                commands = stream.readLong();
                if (Tools.isFlagSet(features, 1024L) != Tools.isFlagSet(this.bap.getFeatures(), 1024L)) {
                    throw new IOException("2");
                }
                if (Tools.isFlagSet(features, 16384L) != Tools.isFlagSet(this.bap.getFeatures(), 16384L)) {
                    throw new IOException("2");
                }
                stream.seek(256);
                this.firmware = stream;
            }
            catch (IOException e1) {
                String message = e1.getMessage();
                if (message != null) {
                    if (message.equals("1")) {
                        JOptionPane.showMessageDialog(this, Messages.getString("FirmwareDialog.91"), Messages.getString("FirmwareDialog.106"), 0);
                    } else if (message.equals("2")) {
                        JOptionPane.showMessageDialog(this, Messages.getString("FirmwareDialog.94"), Messages.getString("FirmwareDialog.106"), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getString("FirmwareDialog.96"), Messages.getString("FirmwareDialog.106"), 0);
                }
                e1.printStackTrace();
                this.buttonCommit.setEnabled(false);
                this.textFieldFeaturesNew.setText("");
                this.textFieldVersionNew.setText("");
                return;
            }
            this.setNewVersion(version);
            this.setNewFeatures(features);
            this.setNewCommands(commands);
            this.buttonCommit.setEnabled(true);
        } else if (command.equals("network")) {
            JOptionPane.showMessageDialog(this, Messages.getString("FirmwareDialog.101"), Messages.getString("FirmwareDialog.106"), 1);
        }
    }

    private void processSuccess() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean result;
                FirmwareDialog.this.updateTextFields();
                FirmwareDialog.this.buttonCommit.setEnabled(false);
                FirmwareDialog.this.textFieldFeaturesNew.setText("");
                FirmwareDialog.this.textFieldVersionNew.setText("");
                Plugin pluginNetwork = FirmwareDialog.this.api.getPlugin("Network", new PluginVersion(1, 0, 0, 0));
                boolean bl = result = pluginNetwork != null && pluginNetwork.hasMethod("saveConfig", Boolean.TYPE, FirmwareDialog.this.bap, FirmwareDialog.this.bapBackup);
                if (result && FirmwareDialog.this.bap != null) {
                    boolean bl2 = result = JOptionPane.showConfirmDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.122"), Messages.getString("FirmwareDialog.106"), 0, 3) == 0;
                    if (result) {
                        try {
                            result = pluginNetwork.call("saveConfig", Boolean.TYPE, FirmwareDialog.this.bap, FirmwareDialog.this.bapBackup);
                        }
                        catch (PluginException e) {
                            e.printStackTrace();
                            result = false;
                        }
                        if (result) {
                            FirmwareDialog.this.api.removeBAP(FirmwareDialog.this.bap.getMac());
                            JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.123"), Messages.getString("FirmwareDialog.106"), 1);
                        } else {
                            JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.124"), Messages.getString("FirmwareDialog.106"), 0);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.105"), Messages.getString("FirmwareDialog.106"), 1);
                }
            }
        });
    }

    private void processError(final Exception e) {
        e.printStackTrace();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e instanceof PluginException) {
                    PluginException pluginException = (PluginException)e;
                    int errorcode = pluginException.getErrorcode();
                    if (errorcode == 1) {
                        JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.107"), Messages.getString("FirmwareDialog.106"), 0);
                    } else if (errorcode == 2) {
                        JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.109"), Messages.getString("FirmwareDialog.106"), 0);
                    } else if (errorcode == 3) {
                        JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.111"), Messages.getString("FirmwareDialog.106"), 0);
                    } else if (errorcode == 4) {
                        JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.113"), Messages.getString("FirmwareDialog.106"), 0);
                    } else if (errorcode == 5) {
                        JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.115"), Messages.getString("FirmwareDialog.106"), 0);
                    } else if (errorcode == 6) {
                        JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.117"), Messages.getString("FirmwareDialog.106"), 0);
                    } else {
                        JOptionPane.showMessageDialog(FirmwareDialog.this, Messages.getString("FirmwareDialog.119"), Messages.getString("FirmwareDialog.106"), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(FirmwareDialog.this, String.valueOf(Messages.getString("FirmwareDialog.121")) + Tools.getStackTrace(e), Messages.getString("FirmwareDialog.106"), 0);
                }
            }
        });
    }
}

