/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.firmware;

import de.bsc.bapfinder.IBAPFinder;
import de.bsc.bapfinder.plugins.Plugin;
import de.bsc.bapfinder.plugins.PluginException;
import de.bsc.bapfinder.plugins.PluginVersion;
import de.bsc.bapfinder.plugins.firmware.FirmwareDialog;
import de.bsc.bapfinder.plugins.firmware.localization.Messages;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class Firmware
extends Plugin
implements ActionListener {
    IBAPFinder api;
    private JButton buttonFirmware;

    @Override
    public void initialize(IBAPFinder api) throws PluginException {
        if (api == null) {
            throw new PluginException("FirmwarePlugin: API == null");
        }
        this.api = api;
        this.buttonFirmware = new JButton();
        this.buttonFirmware.setPreferredSize(new Dimension(100, 25));
        this.buttonFirmware.setEnabled(false);
        this.buttonFirmware.setFont(new Font("Tahoma", 0, 11));
        this.buttonFirmware.setText(Messages.getString("Firmware.1"));
        this.buttonFirmware.setActionCommand("firmware");
        this.buttonFirmware.addActionListener(this);
        api.addButton(this.buttonFirmware);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("firmware") && this.api.getSelectedBAP() != null) {
            new FirmwareDialog(this).setVisible(true);
        }
    }

    @Override
    public String getName() {
        return "Firmware";
    }

    @Override
    public PluginVersion getVersion() {
        return new PluginVersion(1, 1, 0, 0);
    }

    @Override
    public PluginVersion neededAPIVersion() {
        return new PluginVersion(1, 1, 0, 0);
    }

    @Override
    public void selectedBAPChanged(IBAPFinder.IBAP bap) {
        if (bap == null || !bap.hasFeature(128L) || !bap.isOnline()) {
            this.buttonFirmware.setEnabled(false);
        } else {
            this.buttonFirmware.setEnabled(true);
        }
    }
}

