/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins;

public class PluginVersion {
    private static final long MASK_MAJOR = -281474976710656L;
    private static final long MASK_MINOR = 0xFFFF00000000L;
    private static final long MASK_PATCH = 0xFFFF0000L;
    private static final long MASK_BUILD = 65535L;
    private long version;
    private int major;
    private int minor;
    private int patch;
    private int build;
    private Types type;

    public PluginVersion(int major, int minor, int patch, int build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.version = 0L;
        this.version |= ((long)major & 0xFFFFL) << 48;
        this.version |= ((long)minor & 0xFFFFL) << 32;
        this.version |= ((long)patch & 0xFFFFL) << 16;
        this.version |= (long)build & 0xFFFFL;
    }

    public PluginVersion(long version) {
        this.version = version;
        this.major = (int)(version >>> 48) & 0xFFFF;
        this.minor = (int)(version >>> 32) & 0xFFFF;
        this.patch = (int)(version >>> 16) & 0xFFFF;
        this.build = (int)version & 0xFFFF;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public void setMajorVersion(short major) {
        this.major = major;
        this.version &= 0xFFFFFFFFFFFFL;
        this.version |= ((long)major & 0xFFFFL) << 48;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(short minor) {
        this.minor = minor;
        this.version &= 0xFFFF0000FFFFFFFFL;
        this.version |= ((long)minor & 0xFFFFL) << 32;
    }

    public int getPatchVersion() {
        return this.patch;
    }

    public void setPatchVersion(short patch) {
        this.patch = patch;
        this.version &= 0xFFFFFFFF0000FFFFL;
        this.version |= ((long)patch & 0xFFFFL) << 16;
    }

    public int getBuildVersion() {
        return this.build;
    }

    public void setBuildVersion(short build) {
        this.build = build;
        this.version &= 0xFFFFFFFFFFFF0000L;
        this.version |= (long)build & 0xFFFFL;
    }

    public Types getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = Types.valueOf(type);
    }

    public void setType(Types type) {
        this.type = type;
    }

    public long getVersion() {
        return this.version;
    }

    public long getVersionWithoutBuild() {
        long version = this.version;
        return version &= 0xFFFFFFFFFFFF0000L;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getVersionString() {
        return String.format("%02d.%02d.%02d Build %04d", this.getMajorVersion(), this.getMinorVersion(), this.getPatchVersion(), this.getBuildVersion());
    }

    public String toString() {
        return this.getVersionString();
    }

    public boolean equals(Object object) {
        if (object instanceof PluginVersion) {
            return this.version == ((PluginVersion)object).version;
        }
        return false;
    }

    public static enum Types {
        ALPHA("Alpha"),
        BETA("Beta"),
        RC("Release candidate"),
        RELEASE("Release"),
        PATCH("Patch");

        private String name = "";

        private Types(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Types valueOf(String string) {
            return Enum.valueOf(Types.class, string);
        }
    }
}

