/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.IByteClassLoader;
import com.wibu.xpm.Logger;
import com.wibu.xpm.MessageHandler;
import com.wibu.xpm.Runtime;
import com.wibu.xpm.Version;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.Key;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Starter {
    private Manifest mManifest = null;
    final int major = 9;
    final int minor = 0;
    final int build = 1241;
    final int release = 503;
    final int year = 2014;
    final int month = 3;
    final int day = 14;
    Version mVersion = new Version(9, 0, 1241, 503, 2014, 3, 14);
    Version runtimeVersion = new Version();
    private Properties mprops = null;
    private boolean mfVerbose = false;
    private static ClassLoader mclServletClassLoader = null;
    private static ClassLoader mclClassLoader = null;
    private static IByteClassLoader mclByteClassLoader = null;
    private static Starter mpInstance = null;
    private MessageHandler msghandler = null;

    private Starter() {
        String string;
        Logger logger = Logger.getLogger(true);
        if (!logger.isLoggable(Level.WARNING)) {
            logger.setLevel(Level.WARNING);
        } else {
            int n = logger.getLevel();
            if (n == 0) {
                logger.setLevel(Level.WARNING);
            }
        }
        if (this.mprops == null) {
            this.mprops = this.loadRuntimeProperties(logger);
        }
        if ((string = this.mprops.getProperty("RuntimeLogLevel")) != null) {
            try {
                Level level = Level.parse(string);
                logger.setLevel(level);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static synchronized Starter getInstance() {
        if (mpInstance == null) {
            mpInstance = new Starter();
        }
        return mpInstance;
    }

    Manifest getManifest() throws IOException {
        int n;
        URL uRL;
        if (null == this.mManifest && (uRL = this.getClass().getResource("/com/wibu/xpm/Starter.class")).getProtocol() == "jar" && -1 != (n = uRL.toString().indexOf(33))) {
            String string = uRL.toString().substring(0, n + 1);
            string = string + "/META-INF/MANIFEST.MF";
            URL uRL2 = new URL(string);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
            this.mManifest = jarURLConnection.getManifest();
        }
        return this.mManifest;
    }

    public void setVerbose(boolean bl, String[] stringArray) {
        this.mfVerbose = bl;
        Logger logger = Logger.getLogger(true);
        if (this.mfVerbose && !logger.isLoggable(Level.INFO)) {
            logger.setLevel(Level.INFO);
            this.printVersionInfo(stringArray);
        }
    }

    public String getMainClass() throws Exception {
        Manifest manifest = this.getManifest();
        if (null != manifest) {
            String string = manifest.getMainAttributes().getValue("XpmMain");
            if (null != string && 0 == string.length()) {
                return null;
            }
            return string;
        }
        return null;
    }

    protected void printVersionInfo(String[] stringArray) {
        URL uRL;
        System.out.println();
        System.out.println("Dumping Environment Information");
        System.out.println("===============================");
        System.out.println("LD_LIBRARY_PATH        : " + System.getProperty("java.library.path"));
        System.out.println("CLASSPATH              : " + System.getProperty("java.class.path"));
        try {
            System.out.println("JAVA_TOOL_OPTIONS      : " + System.getenv("JAVA_TOOL_OPTIONS"));
        }
        catch (Error error) {
            // empty catch block
        }
        System.out.println("Java Runtime           : " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + ")");
        System.out.println("System Information     : " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")");
        System.out.println("Working Directory      : " + System.getProperty("user.dir"));
        System.out.println("sun.arch.data.model    : " + System.getProperty("sun.arch.data.model"));
        if (null != stringArray) {
            System.out.println("Argument(s)            : " + Integer.toString(stringArray.length - 1));
            for (int i = 1; i < stringArray.length; ++i) {
                System.out.println("   (" + Integer.toString(i) + ")                 : " + stringArray[i]);
            }
        }
        if (null != (uRL = this.getClass().getResource("/com/wibu/xpm/ClassLoader.class.wibu"))) {
            System.out.println("ClassLoader.class      : " + uRL.getFile());
        } else {
            System.out.println("ClassLoader.class : null");
        }
        System.out.println("ClassLoader            : " + this.getClass().getClassLoader().toString());
        System.out.print("Security Manager       : ");
        if (null == System.getSecurityManager()) {
            System.out.println("null");
        } else {
            System.out.println(System.getSecurityManager().getClass().toString());
        }
        System.out.println("Starter Version        : " + this.mVersion.toString());
    }

    public String getProperty(String string, String string2) {
        if (null == string2) {
            return this.mprops.getProperty(string);
        }
        return this.mprops.getProperty(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadRuntimeProperties(Logger logger) {
        InputStream inputStream = null;
        Properties properties = null;
        try {
            properties = new Properties();
            String string = "com/wibu/xpm/runtime.properties";
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            if (null == inputStream) {
                inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(string);
            }
            if (null == inputStream) {
                inputStream = this.getClass().getResourceAsStream("/com/wibu/xpm/runtime.properties");
            }
            if (null != inputStream) {
                properties.load(inputStream);
            } else if (null != logger) {
                logger.warning("Configuration file '" + string + "' not found.");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.error(iOException.getMessage());
                }
            }
        }
        return properties;
    }

    protected MessageHandler createMessageHandler() throws Exception {
        MessageHandler messageHandler = null;
        String string = null;
        if (null != this.mprops) {
            string = this.mprops.getProperty("MessageHandler", "com.wibu.xpm.SwingMessageHandler");
        }
        if (null == string) {
            messageHandler = new MessageHandler();
        } else {
            Class<?> clazz = Class.forName(string);
            messageHandler = (MessageHandler)clazz.newInstance();
        }
        messageHandler.init(this.mprops);
        return messageHandler;
    }

    public ClassLoader getServletClassLoader() throws Exception {
        if (null == mclServletClassLoader) {
            mclServletClassLoader = (ClassLoader)this.createClassLoader("com/wibu/xpm/ServletClassLoader");
        }
        return mclServletClassLoader;
    }

    public IByteClassLoader getByteClassLoader() throws Exception {
        if (null == mclByteClassLoader) {
            mclByteClassLoader = (IByteClassLoader)this.createClassLoader("com/wibu/xpm/ByteClassLoader");
        }
        return mclByteClassLoader;
    }

    public ClassLoader createClassLoader() throws Exception {
        String string = this.mprops.getProperty("ClassLoader", "ClassLoader");
        mclClassLoader = (ClassLoader)this.createClassLoader("com/wibu/xpm/" + string);
        return mclClassLoader;
    }

    public boolean openClassLoader(boolean bl) throws Exception {
        if (!this.startUp()) {
            return false;
        }
        if (bl) {
            return this.preMain(Thread.currentThread().getContextClassLoader());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean preMain(ClassLoader classLoader) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.runtimeVersion.msBuild > 105) {
            object5 = null;
            try {
                object5 = classLoader.loadClass("com.wibu.xpm.NativeWorker");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (null == object5) {
                object4 = Logger.getLogger(true);
                object4.warning("Problem loading NativeWorker - skipped.");
            } else {
                object4 = ((Class)object5).newInstance();
                Runtime.getInstance().setNativeWorker(object4);
            }
        }
        if (null != (object5 = this.mprops.getProperty("PreloadClasses"))) {
            object4 = ((String)object5).split(":");
            for (int i = 0; i < ((String[])object4).length; ++i) {
                if (0 == object4[i].compareTo("com.wibu.xpm.DebugJvmti")) {
                    object3 = this.mprops.getProperty("com.wibu.xpm.DebugJvmti");
                    object2 = ((String)object3).split(":");
                    if (((String[])object2).length != 3) {
                        object = Logger.getLogger(true);
                        ((Logger)object).warning("DebugJvmti entry corrupt.");
                        continue;
                    }
                    if (!Runtime.getInstance().checkEntry((String)object2[0], 2L, Long.parseLong((String)object2[1]), Long.parseLong((String)object2[2]), 0L)) continue;
                }
                if ((object3 = classLoader.loadClass(object4[i])) == null) continue;
                object2 = (Runnable)((Class)object3).newInstance();
                object2.run();
            }
        }
        if (null != (object4 = this.mprops.getProperty("Prefetch"))) {
            Logger logger = Logger.getLogger(true);
            logger.info("Prefetching classes.");
            object3 = new Vector();
            object2 = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/wibu/xpm/prefetch.bin");
            try {
                if (null == object2) {
                    logger.fatal("Error loading list of encrypted class files.");
                    boolean bl = false;
                    return bl;
                }
                object3 = this.readClassNameList((InputStream)object2);
            }
            finally {
                if (object2 != null) {
                    ((InputStream)object2).close();
                }
            }
            object = ((Vector)object3).elements();
            int n = 0;
            int n2 = ((Vector)object3).size();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (!this.msghandler.prefetchClass(n++, n2, string)) {
                    return false;
                }
                Class<?> clazz = classLoader.loadClass(string);
                Runtime.getInstance().watch(clazz);
            }
            Runtime.getInstance().cleanUp();
        }
        return true;
    }

    private Vector readClassNameList(InputStream inputStream) throws Exception {
        String string;
        int n;
        int n2;
        int n3;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        objectInputStream.readObject();
        objectInputStream.readInt();
        int n4 = objectInputStream.readInt();
        byte[] byArray = new byte[n4];
        for (n2 = objectInputStream.read(byArray, 0, n4); n2 < n4; n2 += n3) {
            n3 = objectInputStream.read(byArray, n2, n4 - n2);
            if (n3 != -1) continue;
            Logger.getLogger(true).fatal("Error reading prefetch key.");
            break;
        }
        objectInputStream.readObject();
        n3 = objectInputStream.readInt();
        byte[] byArray2 = new byte[n3];
        for (n2 = objectInputStream.read(byArray2, 0, n3); n2 < n3; n2 += n) {
            n = objectInputStream.read(byArray2, n2, n3 - n2);
            if (n != -1) continue;
            Logger.getLogger(true).fatal("Error reading prefetch data.");
            break;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
        cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(new byte[16]));
        byte[] byArray3 = cipher.doFinal(byArray2, 0, n3);
        Vector<String> vector = new Vector<String>();
        InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray3));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while (null != (string = bufferedReader.readLine())) {
            int n5 = string.lastIndexOf(".class");
            if (n5 <= 0) continue;
            vector.add(string.substring(0, n5));
        }
        return vector;
    }

    protected boolean startUp() throws Exception {
        this.msghandler = this.createMessageHandler();
        this.msghandler.messageBoot();
        Runtime runtime = Runtime.getInstance();
        if (null == runtime) {
            runtime = Runtime.init(this.msghandler);
            runtime.SetApplicationName(this.mprops.getProperty("ApplicationName"));
        }
        String string = this.mprops.getProperty("MinXpmBuild", "10");
        runtime.getVersion(this.runtimeVersion);
        if (this.mfVerbose) {
            System.out.println("Runtime Version        : " + this.runtimeVersion.toString());
        }
        if (this.runtimeVersion.msBuild < Integer.parseInt(string)) {
            String string2 = this.mprops.getProperty("MinXpmVersion", "6.20");
            this.msghandler.errorUnspecified("Runtime version too old. Minimum version " + string2 + " Build " + string + " required!");
            return false;
        }
        if (!this.registerVms(runtime, this.runtimeVersion, this.msghandler)) {
            return false;
        }
        String string3 = this.getProperty("Native Hook", null);
        if (null != string3) {
            runtime.setNativeHook(string3);
        }
        return true;
    }

    public ClassLoader createEclipseClassLoader() throws Exception {
        mclClassLoader = (ClassLoader)this.createClassLoader("com/wibu/xpm/EclipseClassLoader");
        return mclClassLoader;
    }

    public ClassLoader getClassLoader() {
        return mclClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object createClassLoader(String string) throws Exception {
        InputStream inputStream;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class clazz = null;
        try {
            inputStream = null;
            byte[] byArray = null;
            inputStream = classLoader.getResourceAsStream(string + ".class.wibu");
            if (null == inputStream) {
                throw new ClassNotFoundException();
            }
            try {
                long l;
                int n = 0;
                int n2 = inputStream.available();
                byArray = new byte[n2];
                do {
                    if ((l = (long)inputStream.read(byArray, n, n2 - n)) != -1L) continue;
                    System.err.println("Error reading classBytes of " + string);
                    Object var10_11 = null;
                    return var10_11;
                } while ((n = (int)((long)n + l)) < n2);
            }
            catch (Exception exception) {
                System.err.println("Exception at reading classBytes of " + string);
            }
            finally {
                inputStream.close();
            }
            if (!this.startUp()) {
                return null;
            }
            clazz = Runtime.getInstance().loadClass(Thread.currentThread().getContextClassLoader(), string, byArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ClassNotFoundException();
        }
        if (null == clazz) {
            return null;
        }
        inputStream = clazz.newInstance();
        if (null == inputStream) return inputStream;
        if (this.preMain((ClassLoader)((Object)inputStream))) return inputStream;
        return null;
    }

    protected boolean readSignature(Runtime runtime, InputStream inputStream) throws IOException {
        Logger logger = Logger.getLogger(true);
        Properties properties = new Properties();
        properties.load(inputStream);
        Enumeration<?> enumeration = properties.propertyNames();
        block4: while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            byte[] byArray = string2.getBytes();
            switch (runtime.registerVm(string, byArray)) {
                case 0: {
                    logger.fine("Registered VM '" + string + "'.");
                    continue block4;
                }
                case 1: {
                    logger.fine("Registration of VM '" + string + "' skipped.");
                    continue block4;
                }
            }
            logger.warning("Registration of VM '" + string + "' failed!");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean registerVms(Runtime runtime, Version version, MessageHandler messageHandler) {
        Logger logger = Logger.getLogger(true);
        String string = System.getProperty("java.specification.version");
        String[] stringArray = string.split("\\.");
        if (2 != stringArray.length) {
            logger.fatal("Invalid value of 'java.specification.version': '" + string + "'.");
            return false;
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        if (n == 1 && n2 < 6) {
            logger.info("Previous Java version (" + string + ") found - no verification required.");
            return true;
        }
        if (version.msBuild < 50) {
            messageHandler.errorUnspecified("Runtime version too old for Java 6. Minimum version 6.20 Build 50 required!");
            return false;
        }
        try {
            InputStream inputStream;
            Serializable serializable;
            String string2 = "com/wibu/xpm/vm.properties";
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources(string2);
            if (null == enumeration) {
                logger.warning("No JVM signatures found!");
            } else {
                while (enumeration.hasMoreElements() && null != (serializable = enumeration.nextElement())) {
                    logger.info("Reading JVM signatures from " + ((URL)serializable).toString());
                    inputStream = ((URL)serializable).openStream();
                    try {
                        if (null == inputStream) {
                            logger.fatal("Error reading JVM signatures from " + ((URL)serializable).toString());
                            boolean bl = false;
                            return bl;
                        }
                        this.readSignature(runtime, inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            serializable = new File(System.getProperty("user.home") + File.separator + "WibuVm.jar");
            if (!((File)serializable).isFile()) return true;
            inputStream = null;
            FileInputStream fileInputStream = null;
            ZipInputStream zipInputStream = null;
            ZipInputStream zipInputStream2 = null;
            try {
                String string3;
                inputStream = new FileInputStream((File)serializable);
                fileInputStream = new FileInputStream((File)serializable);
                zipInputStream = new JarInputStream(inputStream);
                zipInputStream2 = new JarInputStream(fileInputStream);
                do {
                    JarEntry jarEntry;
                    if (null == (jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry())) return true;
                    ((JarInputStream)zipInputStream2).getNextJarEntry();
                    string3 = jarEntry.getName();
                    zipInputStream.closeEntry();
                } while (!string3.equals("com/wibu/xpm/vm.properties"));
                this.readSignature(runtime, zipInputStream2);
                return true;
            }
            finally {
                if (zipInputStream2 != null) {
                    zipInputStream2.close();
                }
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            logger.warning("Error reading whitelist file: " + iOException.getLocalizedMessage());
            return false;
        }
    }

    public static void cleanUp() {
        mpInstance = null;
    }
}

