/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.Janitor;
import com.wibu.xpm.Logger;
import com.wibu.xpm.NotSupportedException;
import com.wibu.xpm.Runtime;
import com.wibu.xpm.Starter;
import com.wibu.xpm.Version;

public class ProtectionManager {
    private final int major = 9;
    private final int minor = 0;
    private final int build = 1241;
    private final int release = 503;
    private final int year = 2014;
    private static final int month = 3;
    private final int day = 14;
    private Version mVersion = new Version(9, 0, 1241, 503, 2014, 3, 14);
    private Logger mLogger = Logger.getLogger(true);
    private ProtectionThread mthrSecurity = null;
    private Thread mthrShutdown = null;
    private static volatile ProtectionManager instance = null;

    private ProtectionManager() {
        this.mLogger.trace("init()");
        try {
            Starter starter = Starter.getInstance();
            starter.setVerbose(false, null);
            starter.openClassLoader(false);
            Runtime runtime = Runtime.getInstance();
            this.mthrShutdown = Janitor.addShutdownHook(runtime);
            this.mthrSecurity = new ProtectionThread(runtime);
            this.mthrSecurity.start();
        }
        catch (Exception exception) {
            this.mLogger.error(exception.getMessage());
        }
        this.mLogger.fine("ProtectionManager initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ProtectionManager getInstance() {
        if (instance != null) return instance;
        Class<ProtectionManager> clazz = ProtectionManager.class;
        synchronized (ProtectionManager.class) {
            if (instance != null) return instance;
            instance = new ProtectionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws NotSupportedException {
        this.mLogger.fine("Stopping ProtectionManager");
        if (this.mthrSecurity != null) {
            this.mthrSecurity.halt();
        }
        if (this.mthrShutdown != null) {
            this.mthrShutdown.start();
            try {
                this.mthrShutdown.join();
            }
            catch (InterruptedException interruptedException) {
                this.mLogger.error("Error running Janitor");
            }
        }
        this.mLogger.fine("ProtectionManager stop completed.");
        Class<ProtectionManager> clazz = ProtectionManager.class;
        synchronized (ProtectionManager.class) {
            instance = null;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public static void start() {
        ProtectionManager.getInstance();
    }

    public static void stop() throws NotSupportedException {
        ProtectionManager.getInstance().close();
    }

    static class ProtectionThread
    extends Thread {
        private Logger mLogger = Logger.getLogger(true);
        private Runtime mRuntime = null;
        private volatile boolean running = true;

        protected ProtectionThread(Runtime runtime) {
            this.mRuntime = runtime;
        }

        private void halt() throws NotSupportedException {
            if (!this.mRuntime.iRuntimeCheckShutdownAllowed()) {
                throw new NotSupportedException();
            }
            this.running = false;
            this.interrupt();
            try {
                this.join();
                this.mLogger.fine("ProtectionThread-Halt completed");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            int n = 4;
            block7: while (this.running) {
                try {
                    Thread.sleep(n * 1000);
                    this.mLogger.debug("Executing Runtime Check");
                    int n2 = this.mRuntime.runtimeCheck();
                    this.mLogger.debug("Runtime Check returned " + Integer.toString(n2));
                    switch (n2) {
                        case 0: {
                            n = 5;
                            continue block7;
                        }
                        case -1: {
                            this.mLogger.error("Runtime check failed!");
                            System.exit(0);
                            continue block7;
                        }
                    }
                    n = Math.abs(n2);
                }
                catch (InterruptedException interruptedException) {
                    this.mLogger.debug("ProtectionThread has been interrupted");
                }
                catch (Exception exception) {
                    this.mLogger.debug("Exception in ProtectionThread: " + exception.getLocalizedMessage());
                }
            }
            this.mLogger.fine("ProtectionThread shutdown");
        }
    }
}

