/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.Janitor;
import com.wibu.xpm.Logger;
import com.wibu.xpm.MessageHandler;
import com.wibu.xpm.Runtime;
import com.wibu.xpm.Starter;
import com.wibu.xpm.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class SystemClassLoader
extends ClassLoader
implements Runnable {
    final int major = 9;
    final int minor = 0;
    final int build = 1241;
    final int release = 503;
    final int year = 2014;
    final int month = 3;
    final int day = 14;
    protected Version mVersion = new Version(9, 0, 1241, 503, 2014, 3, 14);
    protected Runtime mRuntime = null;
    protected boolean mfInitialized = false;
    protected boolean mfRuntimeCheckFailed = false;
    protected Logger mLogger = null;
    protected Thread mthrSecurity = null;
    protected String mstrWhiteList = null;

    public SystemClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    private void init() {
        if (!this.mfInitialized) {
            Object object;
            Object object2;
            try {
                object2 = Starter.getInstance();
                ((Starter)object2).setVerbose(false, null);
                object = ((Starter)object2).createMessageHandler();
                Runtime.init((MessageHandler)object);
                ((MessageHandler)object).messageStart();
                ((Starter)object2).openClassLoader(false);
                this.mfInitialized = true;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            this.mRuntime = Runtime.getInstance();
            try {
                object2 = "com/wibu/xpm/encrypted";
                object = this.findResources((String)object2);
                if (null != object) {
                    URL uRL;
                    this.mstrWhiteList = new String();
                    while (object.hasMoreElements() && null != (uRL = (URL)object.nextElement())) {
                        byte[] byArray = SystemClassLoader.readFully(uRL);
                        if (null == byArray) continue;
                        this.mLogger.info("Reading whitelist file");
                        String string = new String(byArray);
                        this.mstrWhiteList = this.mstrWhiteList + string.replaceAll("\n", ":");
                    }
                    this.mLogger.info("WhiteList: " + this.mstrWhiteList);
                }
            }
            catch (IOException iOException) {
                this.mLogger.warning("Error reading whitelist file: " + iOException.getLocalizedMessage());
            }
            Janitor.addShutdownHook(this.mRuntime);
            this.mthrSecurity = new Thread(this);
            this.mLogger.fine("SystemClassLoader initialized.");
        }
    }

    @Override
    public void run() {
        int n = 4;
        block6: while (true) {
            try {
                while (true) {
                    Thread.sleep(n * 1000);
                    this.mLogger.debug("Executing Runtime Check");
                    int n2 = this.mRuntime.runtimeCheck();
                    this.mLogger.debug("Runtime Check returned " + Integer.toString(n2));
                    switch (n2) {
                        case 0: {
                            n = 5;
                            continue block6;
                        }
                        case -1: {
                            this.mLogger.error("Runtime check failed!");
                            this.mfRuntimeCheckFailed = true;
                            System.exit(0);
                            continue block6;
                        }
                    }
                    n = Math.abs(n2);
                }
            }
            catch (Exception exception) {
                this.mLogger.debug("Exception in Security Thread: " + exception.getLocalizedMessage());
                continue;
            }
            break;
        }
    }

    protected boolean shouldLoadWithJni(String string) {
        if (this.mstrWhiteList != null) {
            String[] stringArray = this.mstrWhiteList.split(":");
            for (int i = 0; i < stringArray.length; ++i) {
                if (0 == stringArray[i].length() || !string.startsWith(stringArray[i])) continue;
                this.mLogger.info("Class " + string + " matches whitelist.");
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        String string2;
        Class clazz;
        block19: {
            if (null == this.mLogger) {
                this.mLogger = Logger.getLogger(true);
            }
            this.mLogger.trace("SystemClassLoader.loadClass(" + string + ")");
            clazz = null;
            clazz = super.findLoadedClass(string);
            if (clazz != null) {
                this.mLogger.info("Found already loaded class " + string);
                return clazz;
            }
            string2 = string.replace('.', '/') + ".class";
            try {
                clazz = super.loadClass(string, bl);
                this.mLogger.fine("System loaded " + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                InputStream inputStream = null;
                byte[] byArray = null;
                try {
                    inputStream = this.getResourceAsStream(string2 + ".wibu");
                    if (null == inputStream) {
                        this.mLogger.fine("Error looking for " + string2 + ".wibu - trying with Context CL");
                        inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string2 + ".wibu");
                    }
                    if (null == inputStream) {
                        this.mLogger.info("Error loading class '" + string + "'");
                        throw classNotFoundException;
                    }
                    if (!this.mfInitialized) {
                        this.init();
                    }
                    byArray = SystemClassLoader.readFully(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            this.mLogger.warning("Error closing stream");
                        }
                    }
                }
                if (byArray == null) {
                    this.mLogger.fine("Class " + string2 + "' not found!");
                }
                if (!this.mthrSecurity.isAlive()) {
                    this.mLogger.debug("Starting security thread.");
                    this.mthrSecurity.start();
                    Thread.yield();
                }
                if (null == (clazz = this.mRuntime.loadClass(this, string.replace('.', '/'), byArray))) break block19;
                this.mLogger.fine("Class '" + string2 + "' decrypted.");
            }
        }
        if (null != clazz) {
            URL uRL = this.getResource(string2 + ".wibu");
            this.addPackage(string, uRL);
            return clazz;
        }
        return clazz;
    }

    protected void addPackage(String string, URL uRL) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            URL uRL2 = null;
            Package package_ = this.getPackage(string2);
            if (null != package_) {
                return;
            }
            try {
                Attributes attributes;
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                Manifest manifest = jarURLConnection.getManifest();
                if (null != manifest && null != (attributes = manifest.getMainAttributes())) {
                    string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.definePackage(string2, string3, string4, string5, string6, string7, string8, uRL2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            if (inputStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = SystemClassLoader.readFully(inputStream);
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(true).error(iOException.getLocalizedMessage());
                }
            }
        }
    }

    public static byte[] readFully(InputStream inputStream) {
        byte[] byArray = null;
        int n = 0;
        try {
            n = inputStream.available();
            byArray = new byte[n];
            for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
            }
            return byArray;
        }
        catch (Exception exception) {
            Logger.getLogger(true).error(exception.getLocalizedMessage());
            return byArray;
        }
    }

    public String toString() {
        return "com.wibu.xpm.SystemClassLoader " + this.mVersion.toString();
    }
}

