/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.remote.vnc.streams;

public abstract class InStream {
    protected byte[] b;
    protected int ptr;
    protected int end;
    public static int maxStringLength = 65535;

    protected InStream() {
    }

    public final int check(int itemSize, int nItems) throws Exception {
        if (this.ptr + itemSize * nItems > this.end) {
            if (this.ptr + itemSize > this.end) {
                return this.overrun(itemSize, nItems);
            }
            nItems = (this.end - this.ptr) / itemSize;
        }
        return nItems;
    }

    public final void check(int itemSize) throws Exception {
        if (this.ptr + itemSize > this.end) {
            this.overrun(itemSize, 1);
        }
    }

    public final int readS8() throws Exception {
        this.check(1);
        return this.b[this.ptr++];
    }

    public final int readS16() throws Exception {
        this.check(2);
        byte b0 = this.b[this.ptr++];
        int b1 = this.b[this.ptr++] & 0xFF;
        return b0 << 8 | b1;
    }

    public final int readS32() throws Exception {
        this.check(4);
        byte b0 = this.b[this.ptr++];
        int b1 = this.b[this.ptr++] & 0xFF;
        int b2 = this.b[this.ptr++] & 0xFF;
        int b3 = this.b[this.ptr++] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    public final int readU8() throws Exception {
        return this.readS8() & 0xFF;
    }

    public final int readU16() throws Exception {
        return this.readS16() & 0xFFFF;
    }

    public final int readU32() throws Exception {
        return this.readS32() & 0xFFFFFFFF;
    }

    public final String readString() throws Exception {
        int len = this.readU32();
        if (len > maxStringLength) {
            throw new Exception("InStream max string length exceeded");
        }
        char[] str = new char[len];
        int i = 0;
        while (i < len) {
            int j = i + this.check(1, len - i);
            while (i < j) {
                str[i++] = (char)this.b[this.ptr++];
            }
        }
        return new String(str);
    }

    public final void skip(int bytes) throws Exception {
        while (bytes > 0) {
            int n = this.check(1, bytes);
            this.ptr += n;
            bytes -= n;
        }
    }

    public void readBytes(byte[] data, int offset, int length) throws Exception {
        int offsetEnd = offset + length;
        while (offset < offsetEnd) {
            int n = this.check(1, offsetEnd - offset);
            System.arraycopy(this.b, this.ptr, data, offset, n);
            this.ptr += n;
            offset += n;
        }
    }

    public final int readOpaque8() throws Exception {
        return this.readU8();
    }

    public final int readOpaque16() throws Exception {
        return this.readU16();
    }

    public final int readOpaque32() throws Exception {
        return this.readU32();
    }

    public final int readOpaque24A() throws Exception {
        this.check(3);
        byte b0 = this.b[this.ptr++];
        byte b1 = this.b[this.ptr++];
        byte b2 = this.b[this.ptr++];
        return b0 << 24 | b1 << 16 | b2 << 8;
    }

    public final int readOpaque24B() throws Exception {
        this.check(3);
        byte b0 = this.b[this.ptr++];
        byte b1 = this.b[this.ptr++];
        byte b2 = this.b[this.ptr++];
        return b0 << 16 | b1 << 8 | b2;
    }

    public boolean bytesAvailable() {
        return this.end != this.ptr;
    }

    public final byte[] getbuf() {
        return this.b;
    }

    public final int getptr() {
        return this.ptr;
    }

    public final int getend() {
        return this.end;
    }

    public final void setptr(int p) {
        this.ptr = p;
    }

    protected abstract int overrun(int var1, int var2) throws Exception;

    public abstract int pos();
}

