/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.remote.vnc;

public class Options {
    private static String[] names = new String[]{"Encoding", "Compression level", "JPEG image quality", "Cursor shape updates", "Use CopyRect", "Restricted colors", "Mouse buttons 2 and 3", "View only", "Scale remote cursor", "Share desktop"};
    private static String[][] values = new String[][]{{"Auto", "Raw", "RRE", "CoRRE", "Hextile", "Zlib", "Tight", "ZRLE"}, {"Default", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, {"JPEG off", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, {"Enable", "Ignore", "Disable"}, {"Yes", "No"}, {"Yes", "No"}, {"Normal", "Reversed"}, {"Yes", "No"}, {"No", "50%", "75%", "125%", "150%"}, {"Yes", "No"}};
    private static final int encodingIndex = 0;
    private static final int compressLevelIndex = 1;
    private static final int jpegQualityIndex = 2;
    private static final int cursorUpdatesIndex = 3;
    private static final int useCopyRectIndex = 4;
    private static final int eightBitColorsIndex = 5;
    private static final int mouseButtonIndex = 6;
    private static final int viewOnlyIndex = 7;
    private static final int scaleCursorIndex = 8;
    private static final int shareDesktopIndex = 9;
    public static int preferredEncoding;
    public static int compressLevel;
    public static int jpegQuality;
    public static boolean useCopyRect;
    public static boolean requestCursorUpdates;
    public static boolean ignoreCursorUpdates;
    public static boolean eightBitColors;
    public static boolean reverseMouseButtons2And3;
    public static boolean shareDesktop;
    public static boolean viewOnly;
    public static int scaleCursor;
    public static boolean autoScale;
    public static int scalingFactor;
    private static String[] choices;

    static {
        choices = new String[names.length];
        Options.choices[0] = "Tight";
        Options.choices[1] = "9";
        Options.choices[2] = "6";
        Options.choices[3] = "Enable";
        Options.choices[4] = "Yes";
        Options.choices[5] = "No";
        Options.choices[6] = "Normal";
        Options.choices[7] = "No";
        Options.choices[8] = "No";
        Options.choices[9] = "Yes";
        autoScale = false;
        scalingFactor = 100;
        Options.setEncodings();
        Options.setColorFormat();
        Options.setOtherOptions();
    }

    private static void setEncodings() {
        useCopyRect = choices[4].equals("Yes");
        preferredEncoding = 0;
        if (choices[0].equals("RRE")) {
            preferredEncoding = 2;
        } else if (choices[0].equals("CoRRE")) {
            preferredEncoding = 4;
        } else if (choices[0].equals("Hextile")) {
            preferredEncoding = 5;
        } else if (choices[0].equals("ZRLE")) {
            preferredEncoding = 16;
        } else if (choices[0].equals("Zlib")) {
            preferredEncoding = 6;
        } else if (choices[0].equals("Tight")) {
            preferredEncoding = 7;
        } else if (choices[0].equals("Auto")) {
            preferredEncoding = -1;
        }
        try {
            compressLevel = Integer.parseInt(choices[1]);
        }
        catch (NumberFormatException numberFormatException) {
            compressLevel = -1;
        }
        if (compressLevel < 1 || compressLevel > 9) {
            compressLevel = -1;
        }
        try {
            jpegQuality = Integer.parseInt(choices[2]);
        }
        catch (NumberFormatException numberFormatException) {
            jpegQuality = -1;
        }
        if (jpegQuality < 0 || jpegQuality > 9) {
            jpegQuality = -1;
        }
        boolean bl = requestCursorUpdates = !choices[3].equals("Disable");
        if (requestCursorUpdates) {
            ignoreCursorUpdates = choices[3].equals("Ignore");
        }
    }

    private static void setColorFormat() {
        eightBitColors = choices[5].equals("Yes");
    }

    private static void setOtherOptions() {
        reverseMouseButtons2And3 = choices[6].equals("Reversed");
        viewOnly = choices[7].equals("Yes");
        shareDesktop = choices[9].equals("Yes");
        String scaleString = choices[8];
        if (scaleString.endsWith("%")) {
            scaleString = scaleString.substring(0, scaleString.length() - 1);
        }
        try {
            scaleCursor = Integer.parseInt(scaleString);
        }
        catch (NumberFormatException numberFormatException) {
            scaleCursor = 0;
        }
        if (scaleCursor < 10 || scaleCursor > 500) {
            scaleCursor = 0;
        }
    }
}

