/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.remote.vnc;

import de.bsc.bapfinder.plugins.remote.vnc.IVNC;
import de.bsc.bapfinder.plugins.remote.vnc.Options;
import de.bsc.bapfinder.plugins.remote.vnc.RFBProtocol;
import de.bsc.bapfinder.plugins.remote.vnc.streams.InStream;
import de.bsc.bapfinder.plugins.remote.vnc.streams.MemInStream;
import de.bsc.bapfinder.plugins.remote.vnc.streams.ZlibInStream;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.zip.Inflater;
import javax.swing.JPanel;

public class JVNCPanel
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ComponentListener {
    private static final long serialVersionUID = -1729115467956330427L;
    private IVNC vnc;
    private RFBProtocol rfb;
    private ColorModel cm8;
    private ColorModel cm24;
    private Color[] colors;
    private int bytesPixel;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private int scalingFactor;
    private int scaledWidth;
    private int scaledHeight;
    private Image memImage;
    private Graphics memGraphics;
    private Image rawPixelsImage;
    private MemoryImageSource pixelsSource;
    private byte[] pixels8;
    private int[] pixels24;
    private long statStartTime;
    private int statNumUpdates;
    private int statNumTotalRects;
    private int statNumPixelRects;
    private int statNumRectsTight;
    private int statNumRectsTightJPEG;
    private int statNumRectsZRLE;
    private int statNumRectsHextile;
    private int statNumRectsRaw;
    private int statNumRectsCopy;
    private int statNumBytesEncoded;
    private int statNumBytesDecoded;
    private byte[] zrleBuf;
    private int zrleBufLen = 0;
    private byte[] zrleTilePixels8;
    private int[] zrleTilePixels24;
    private ZlibInStream zrleInStream;
    private byte[] zlibBuf;
    private int zlibBufLen = 0;
    private Inflater zlibInflater;
    private Inflater[] tightInflaters;
    private int x = 0;
    private int y = 0;
    private Cursor dot = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().createImage(new byte[4]), new Point(0, 0), "dot");
    private Rectangle jpegRect;
    private boolean inputEnabled;
    private Robot robot;
    private Color hextile_bg;
    private Color hextile_fg;
    boolean showSoftCursor = false;
    MemoryImageSource softCursorSource;
    Image softCursor;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int origCursorWidth;
    int origCursorHeight;
    int hotX;
    int hotY;
    int origHotX;
    int origHotY;

    public JVNCPanel(IVNC vnc) throws IOException {
        this.vnc = vnc;
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {}
        this.scalingFactor = Options.scalingFactor;
        this.tightInflaters = new Inflater[4];
        this.cm8 = new DirectColorModel(8, 7, 56, 192);
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.setFocusTraversalKeys(0, Collections.emptySet());
        this.setFocusTraversalKeys(1, Collections.emptySet());
        this.colors = new Color[256];
        int i = 0;
        while (i < 256) {
            this.colors[i] = new Color(this.cm8.getRGB(i));
            ++i;
        }
        this.inputEnabled = false;
        if (!Options.viewOnly) {
            this.enableInput(true);
        }
        this.addKeyListener(this);
        this.addComponentListener(this);
        this.disableFocusTraversalKeys();
        this.setFocusable(true);
        this.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(RFBProtocol rfb) throws Exception {
        this.rfb = rfb;
        try {
            this.setPixelFormat();
            rfb.writeFramebufferUpdateRequest(0, 0, rfb.getFrameBufferWidth(), rfb.getFrameBufferHeight(), false);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.resetStats();
        boolean statsRestarted = false;
        block26: while (!rfb.closed()) {
            int msgType = rfb.readServerMessageType();
            switch (msgType) {
                case 0: {
                    if (this.statNumUpdates == this.vnc.getDebugStatsExcludeUpdates() && !statsRestarted) {
                        this.resetStats();
                        statsRestarted = true;
                    } else if (this.statNumUpdates == this.vnc.getDebugStatsMeasureUpdates() && statsRestarted) {
                        this.vnc.disconnect();
                    }
                    rfb.readFramebufferUpdate();
                    ++this.statNumUpdates;
                    boolean cursorPosReceived = false;
                    int i = 0;
                    while (i < rfb.updateNRects) {
                        rfb.readFramebufferUpdateRectHdr();
                        ++this.statNumTotalRects;
                        int rx = rfb.updateRectX;
                        int ry = rfb.updateRectY;
                        int rw = rfb.updateRectW;
                        int rh = rfb.updateRectH;
                        if (rfb.updateRectEncoding == -224) break;
                        if (rfb.updateRectEncoding == -223) {
                            rfb.setFramebufferSize(rw, rh);
                            this.updateFramebufferSize();
                            break;
                        }
                        if (rfb.updateRectEncoding == -240 || rfb.updateRectEncoding == -239) {
                            this.handleCursorShapeUpdate(rfb.updateRectEncoding, rx, ry, rw, rh);
                        } else if (rfb.updateRectEncoding == -232) {
                            rx = rx * this.scalingFactor / 100;
                            ry = ry * this.scalingFactor / 100;
                            this.softCursorMove(rx += this.x, ry += this.y);
                            this.realCursorMove(rx, ry);
                            cursorPosReceived = true;
                        } else {
                            long numBytesReadBefore = rfb.getNumBytesRead();
                            rfb.startTiming();
                            switch (rfb.updateRectEncoding) {
                                case 0: {
                                    ++this.statNumRectsRaw;
                                    this.handleRawRect(rx, ry, rw, rh);
                                    break;
                                }
                                case 1: {
                                    ++this.statNumRectsCopy;
                                    this.handleCopyRect(rx, ry, rw, rh);
                                    break;
                                }
                                case 2: {
                                    this.handleRRERect(rx, ry, rw, rh);
                                    break;
                                }
                                case 4: {
                                    this.handleCoRRERect(rx, ry, rw, rh);
                                    break;
                                }
                                case 5: {
                                    ++this.statNumRectsHextile;
                                    this.handleHextileRect(rx, ry, rw, rh);
                                    break;
                                }
                                case 16: {
                                    ++this.statNumRectsZRLE;
                                    this.handleZRLERect(rx, ry, rw, rh);
                                    break;
                                }
                                case 6: {
                                    this.handleZlibRect(rx, ry, rw, rh);
                                    break;
                                }
                                case 7: {
                                    ++this.statNumRectsTight;
                                    this.handleTightRect(rx, ry, rw, rh);
                                    break;
                                }
                                default: {
                                    throw new Exception("Unknown RFB rectangle encoding " + rfb.updateRectEncoding);
                                }
                            }
                            rfb.stopTiming();
                            ++this.statNumPixelRects;
                            this.statNumBytesDecoded += rw * rh * this.bytesPixel;
                            this.statNumBytesEncoded += (int)(rfb.getNumBytesRead() - numBytesReadBefore);
                        }
                        ++i;
                    }
                    boolean fullUpdateNeeded = false;
                    if (this.vnc.getDeferUpdateRequests() > 0 && rfb.available() == 0 && !cursorPosReceived) {
                        RFBProtocol rx = rfb;
                        synchronized (rx) {
                            try {
                                rfb.wait(this.vnc.getDeferUpdateRequests());
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    this.vnc.autoSelectEncodings();
                    if (Options.eightBitColors != (this.bytesPixel == 1)) {
                        this.setPixelFormat();
                        fullUpdateNeeded = true;
                    }
                    int w = rfb.getFrameBufferWidth();
                    int h = rfb.getFrameBufferHeight();
                    rfb.writeFramebufferUpdateRequest(0, 0, w, h, !fullUpdateNeeded);
                    continue block26;
                }
                case 1: {
                    throw new Exception("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block26;
                }
                case 3: {
                    rfb.readServerCutText();
                    continue block26;
                }
                case 7: {
                    continue block26;
                }
                default: {
                    throw new Exception("Unknown RFB message type " + msgType);
                }
            }
        }
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        int y0;
        int x0;
        Rectangle r;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.memImage != null) {
            Image image = this.memImage;
            synchronized (image) {
                if (this.rfb.getFrameBufferWidth() == this.scaledWidth) {
                    g.drawImage(this.memImage, 0, 0, null);
                } else {
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g2d.drawImage(this.memImage, this.x, this.y, this.scaledWidth, this.scaledHeight, null);
                }
            }
        }
        if (this.softCursor != null && this.showSoftCursor && this.softCursor != null && (r = new Rectangle(x0 = this.cursorX - this.hotX, y0 = this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight)).intersects(g.getClipBounds())) {
            g2d.drawImage(this.softCursor, x0, y0, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0xA0) == 0) {
            return true;
        }
        if ((infoflags & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.memGraphics.drawImage(img, this.jpegRect.x, this.jpegRect.y, null);
                this.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    public synchronized void enableInput(boolean enable) {
        if (enable && !this.inputEnabled) {
            this.inputEnabled = true;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.createSoftCursor();
        } else if (!enable && this.inputEnabled) {
            this.inputEnabled = false;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.removeMouseWheelListener(this);
            this.createSoftCursor();
        }
    }

    public void setPixelFormat() throws IOException {
        if (Options.eightBitColors) {
            this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
            this.bytesPixel = 1;
        } else {
            this.rfb.writeSetPixelFormat(32, 24, false, true, 255, 255, 255, 16, 8, 0);
            this.bytesPixel = 4;
        }
        this.updateFramebufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFramebufferSize() {
        int fbWidth = this.rfb.getFrameBufferWidth();
        int fbHeight = this.rfb.getFrameBufferHeight();
        if (this.memImage == null) {
            this.memImage = this.createImage(fbWidth, fbHeight);
            this.memGraphics = this.memImage.getGraphics();
        } else if (this.memImage.getWidth(null) != fbWidth || this.memImage.getHeight(null) != fbHeight) {
            Image image = this.memImage;
            synchronized (image) {
                this.memImage = this.createImage(fbWidth, fbHeight);
                this.memGraphics = this.memImage.getGraphics();
            }
        }
        if (this.bytesPixel == 1) {
            this.pixels24 = null;
            this.pixels8 = new byte[fbWidth * fbHeight];
            this.pixelsSource = new MemoryImageSource(fbWidth, fbHeight, this.cm8, this.pixels8, 0, fbWidth);
            this.zrleTilePixels24 = null;
            this.zrleTilePixels8 = new byte[4096];
        } else {
            this.pixels8 = null;
            this.pixels24 = new int[fbWidth * fbHeight];
            this.pixelsSource = new MemoryImageSource(fbWidth, fbHeight, this.cm24, this.pixels24, 0, fbWidth);
            this.zrleTilePixels8 = null;
            this.zrleTilePixels24 = new int[4096];
        }
        this.pixelsSource.setAnimated(true);
        this.rawPixelsImage = Toolkit.getDefaultToolkit().createImage(this.pixelsSource);
        this.calcGeometry();
    }

    void handleRawRect(int x, int y, int w, int h) throws IOException {
        this.handleRawRect(x, y, w, h, true);
    }

    void handleRawRect(int x, int y, int w, int h, boolean paint) throws IOException {
        if (this.bytesPixel == 1) {
            int dy = y;
            while (dy < y + h) {
                this.rfb.readFully(this.pixels8, dy * this.rfb.getFrameBufferWidth() + x, w);
                ++dy;
            }
        } else {
            byte[] buf = new byte[w * 4];
            int dy = y;
            while (dy < y + h) {
                this.rfb.readFully(buf);
                int offset = dy * this.rfb.getFrameBufferHeight() + x;
                int i = 0;
                while (i < w) {
                    this.pixels24[offset + i] = (buf[i * 4 + 2] & 0xFF) << 16 | (buf[i * 4 + 1] & 0xFF) << 8 | buf[i * 4] & 0xFF;
                    ++i;
                }
                ++dy;
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        if (paint) {
            this.scheduleRepaint(x, y, w, h);
        }
    }

    void handleCopyRect(int x, int y, int w, int h) throws IOException {
        this.rfb.readCopyRect();
        this.memGraphics.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, w, h, x - this.rfb.copyRectSrcX, y - this.rfb.copyRectSrcY);
        this.scheduleRepaint(x, y, w, h);
    }

    void handleRRERect(int x, int y, int w, int h) throws IOException {
        int nSubrects = this.rfb.readU32();
        byte[] bg_buf = new byte[this.bytesPixel];
        this.rfb.readFully(bg_buf);
        Color pixel = this.bytesPixel == 1 ? this.colors[bg_buf[0] & 0xFF] : new Color(bg_buf[2] & 0xFF, bg_buf[1] & 0xFF, bg_buf[0] & 0xFF);
        this.memGraphics.setColor(pixel);
        this.memGraphics.fillRect(x, y, w, h);
        byte[] buf = new byte[nSubrects * (this.bytesPixel + 8)];
        this.rfb.readFully(buf);
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(buf));
        int j = 0;
        while (j < nSubrects) {
            if (this.bytesPixel == 1) {
                pixel = this.colors[ds.readUnsignedByte()];
            } else {
                ds.skip(4L);
                pixel = new Color(buf[j * 12 + 2] & 0xFF, buf[j * 12 + 1] & 0xFF, buf[j * 12] & 0xFF);
            }
            int sx = x + ds.readUnsignedShort();
            int sy = y + ds.readUnsignedShort();
            int sw = ds.readUnsignedShort();
            int sh = ds.readUnsignedShort();
            this.memGraphics.setColor(pixel);
            this.memGraphics.fillRect(sx, sy, sw, sh);
            ++j;
        }
        this.scheduleRepaint(x, y, w, h);
    }

    void handleCoRRERect(int x, int y, int w, int h) throws IOException {
        int nSubrects = this.rfb.readU32();
        byte[] bg_buf = new byte[this.bytesPixel];
        this.rfb.readFully(bg_buf);
        Color pixel = this.bytesPixel == 1 ? this.colors[bg_buf[0] & 0xFF] : new Color(bg_buf[2] & 0xFF, bg_buf[1] & 0xFF, bg_buf[0] & 0xFF);
        this.memGraphics.setColor(pixel);
        this.memGraphics.fillRect(x, y, w, h);
        byte[] buf = new byte[nSubrects * (this.bytesPixel + 4)];
        this.rfb.readFully(buf);
        int i = 0;
        int j = 0;
        while (j < nSubrects) {
            if (this.bytesPixel == 1) {
                pixel = this.colors[buf[i++] & 0xFF];
            } else {
                pixel = new Color(buf[i + 2] & 0xFF, buf[i + 1] & 0xFF, buf[i] & 0xFF);
                i += 4;
            }
            int sx = x + (buf[i++] & 0xFF);
            int sy = y + (buf[i++] & 0xFF);
            int sw = buf[i++] & 0xFF;
            int sh = buf[i++] & 0xFF;
            this.memGraphics.setColor(pixel);
            this.memGraphics.fillRect(sx, sy, sw, sh);
            ++j;
        }
        this.scheduleRepaint(x, y, w, h);
    }

    void handleHextileRect(int x, int y, int w, int h) throws IOException {
        this.hextile_bg = new Color(0);
        this.hextile_fg = new Color(0);
        int ty = y;
        while (ty < y + h) {
            int th = 16;
            if (y + h - ty < 16) {
                th = y + h - ty;
            }
            int tx = x;
            while (tx < x + w) {
                int tw = 16;
                if (x + w - tx < 16) {
                    tw = x + w - tx;
                }
                this.handleHextileSubrect(tx, ty, tw, th);
                tx += 16;
            }
            this.scheduleRepaint(x, y, w, h);
            ty += 16;
        }
    }

    void handleHextileSubrect(int tx, int ty, int tw, int th) throws IOException {
        int subencoding = this.rfb.readU8();
        if ((subencoding & 1) != 0) {
            this.handleRawRect(tx, ty, tw, th, false);
            return;
        }
        byte[] cbuf = new byte[this.bytesPixel];
        if ((subencoding & 2) != 0) {
            this.rfb.readFully(cbuf);
            this.hextile_bg = this.bytesPixel == 1 ? this.colors[cbuf[0] & 0xFF] : new Color(cbuf[2] & 0xFF, cbuf[1] & 0xFF, cbuf[0] & 0xFF);
        }
        this.memGraphics.setColor(this.hextile_bg);
        this.memGraphics.fillRect(tx, ty, tw, th);
        if ((subencoding & 4) != 0) {
            this.rfb.readFully(cbuf);
            this.hextile_fg = this.bytesPixel == 1 ? this.colors[cbuf[0] & 0xFF] : new Color(cbuf[2] & 0xFF, cbuf[1] & 0xFF, cbuf[0] & 0xFF);
        }
        if ((subencoding & 8) == 0) {
            return;
        }
        int nSubrects = this.rfb.readU8();
        int bufsize = nSubrects * 2;
        if ((subencoding & 0x10) != 0) {
            bufsize += nSubrects * this.bytesPixel;
        }
        byte[] buf = new byte[bufsize];
        this.rfb.readFully(buf);
        int i = 0;
        if ((subencoding & 0x10) == 0) {
            this.memGraphics.setColor(this.hextile_fg);
            int j = 0;
            while (j < nSubrects) {
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.fillRect(sx, sy, sw, sh);
                ++j;
            }
        } else if (this.bytesPixel == 1) {
            int j = 0;
            while (j < nSubrects) {
                this.hextile_fg = this.colors[buf[i++] & 0xFF];
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(sx, sy, sw, sh);
                ++j;
            }
        } else {
            int j = 0;
            while (j < nSubrects) {
                this.hextile_fg = new Color(buf[i + 2] & 0xFF, buf[i + 1] & 0xFF, buf[i] & 0xFF);
                i += 4;
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(sx, sy, sw, sh);
                ++j;
            }
        }
    }

    void handleZRLERect(int x, int y, int w, int h) throws Exception {
        int nBytes;
        if (this.zrleInStream == null) {
            this.zrleInStream = new ZlibInStream();
        }
        if ((nBytes = this.rfb.readU32()) > 0x4000000) {
            throw new Exception("ZRLE decoder: illegal compressed data size");
        }
        if (this.zrleBuf == null || this.zrleBufLen < nBytes) {
            this.zrleBufLen = nBytes + 4096;
            this.zrleBuf = new byte[this.zrleBufLen];
        }
        this.rfb.readFully(this.zrleBuf, 0, nBytes);
        this.zrleInStream.setUnderlying(new MemInStream(this.zrleBuf, 0, nBytes), nBytes);
        int ty = y;
        while (ty < y + h) {
            int th = Math.min(y + h - ty, 64);
            int tx = x;
            while (tx < x + w) {
                int tw = Math.min(x + w - tx, 64);
                int mode = this.zrleInStream.readU8();
                boolean rle = (mode & 0x80) != 0;
                int palSize = mode & 0x7F;
                int[] palette = new int[128];
                this.readZrlePalette(palette, palSize);
                if (palSize == 1) {
                    int pix = palette[0];
                    Color c = this.bytesPixel == 1 ? this.colors[pix] : new Color(0xFF000000 | pix);
                    this.memGraphics.setColor(c);
                    this.memGraphics.fillRect(tx, ty, tw, th);
                } else {
                    if (!rle) {
                        if (palSize == 0) {
                            this.readZrleRawPixels(tw, th);
                        } else {
                            this.readZrlePackedPixels(tw, th, palette, palSize);
                        }
                    } else if (palSize == 0) {
                        this.readZrlePlainRLEPixels(tw, th);
                    } else {
                        this.readZrlePackedRLEPixels(tw, th, palette);
                    }
                    this.handleUpdatedZrleTile(tx, ty, tw, th);
                }
                tx += 64;
            }
            ty += 64;
        }
        this.zrleInStream.reset();
        this.scheduleRepaint(x, y, w, h);
    }

    int readPixel(InStream is) throws Exception {
        int pix;
        if (this.bytesPixel == 1) {
            pix = is.readU8();
        } else {
            int p1 = is.readU8();
            int p2 = is.readU8();
            int p3 = is.readU8();
            pix = (p3 & 0xFF) << 16 | (p2 & 0xFF) << 8 | p1 & 0xFF;
        }
        return pix;
    }

    void readPixels(InStream is, int[] dst, int count) throws Exception {
        if (this.bytesPixel == 1) {
            byte[] buf = new byte[count];
            is.readBytes(buf, 0, count);
            int i = 0;
            while (i < count) {
                dst[i] = buf[i] & 0xFF;
                ++i;
            }
        } else {
            byte[] buf = new byte[count * 3];
            is.readBytes(buf, 0, count * 3);
            int i = 0;
            while (i < count) {
                dst[i] = (buf[i * 3 + 2] & 0xFF) << 16 | (buf[i * 3 + 1] & 0xFF) << 8 | buf[i * 3] & 0xFF;
                ++i;
            }
        }
    }

    void readZrlePalette(int[] palette, int palSize) throws Exception {
        this.readPixels(this.zrleInStream, palette, palSize);
    }

    void readZrleRawPixels(int tw, int th) throws Exception {
        if (this.bytesPixel == 1) {
            this.zrleInStream.readBytes(this.zrleTilePixels8, 0, tw * th);
        } else {
            this.readPixels(this.zrleInStream, this.zrleTilePixels24, tw * th);
        }
    }

    void readZrlePackedPixels(int tw, int th, int[] palette, int palSize) throws Exception {
        int bppp = palSize > 16 ? 8 : (palSize > 4 ? 4 : (palSize > 2 ? 2 : 1));
        int ptr = 0;
        int i = 0;
        while (i < th) {
            int eol = ptr + tw;
            int b = 0;
            int nbits = 0;
            while (ptr < eol) {
                if (nbits == 0) {
                    b = this.zrleInStream.readU8();
                    nbits = 8;
                }
                int index = b >> (nbits -= bppp) & (1 << bppp) - 1 & 0x7F;
                if (this.bytesPixel == 1) {
                    this.zrleTilePixels8[ptr++] = (byte)palette[index];
                    continue;
                }
                this.zrleTilePixels24[ptr++] = palette[index];
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    void readZrlePlainRLEPixels(int tw, int th) throws Exception {
        ptr = 0;
        end = ptr + tw * th;
        while (ptr < end) {
            pix = this.readPixel(this.zrleInStream);
            len = 1;
            do {
                b = this.zrleInStream.readU8();
                len += b;
            } while (b == 255);
            if (len > end - ptr) {
                throw new Exception("ZRLE decoder: assertion failed (len <= end-ptr)");
            }
            if (this.bytesPixel != 1) ** GOTO lbl18
            while (len-- > 0) {
                this.zrleTilePixels8[ptr++] = (byte)pix;
            }
            continue;
lbl-1000:
            // 1 sources

            {
                this.zrleTilePixels24[ptr++] = pix;
lbl18:
                // 2 sources

                ** while (len-- > 0)
            }
lbl19:
            // 1 sources

        }
    }

    /*
     * Unable to fully structure code
     */
    void readZrlePackedRLEPixels(int tw, int th, int[] palette) throws Exception {
        ptr = 0;
        end = ptr + tw * th;
        while (ptr < end) {
            index = this.zrleInStream.readU8();
            len = 1;
            if ((index & 128) != 0) {
                do {
                    b = this.zrleInStream.readU8();
                    len += b;
                } while (b == 255);
                if (len > end - ptr) {
                    throw new Exception("ZRLE decoder: assertion failed (len <= end - ptr)");
                }
            }
            pix = palette[index &= 127];
            if (this.bytesPixel != 1) ** GOTO lbl20
            while (len-- > 0) {
                this.zrleTilePixels8[ptr++] = (byte)pix;
            }
            continue;
lbl-1000:
            // 1 sources

            {
                this.zrleTilePixels24[ptr++] = pix;
lbl20:
                // 2 sources

                ** while (len-- > 0)
            }
lbl21:
            // 1 sources

        }
    }

    void handleUpdatedZrleTile(int x, int y, int w, int h) {
        Object[] dst;
        Object[] src;
        if (this.bytesPixel == 1) {
            src = this.zrleTilePixels8;
            dst = this.pixels8;
        } else {
            src = this.zrleTilePixels24;
            dst = this.pixels24;
        }
        int offsetSrc = 0;
        int offsetDst = y * this.rfb.getFrameBufferWidth() + x;
        int j = 0;
        while (j < h) {
            System.arraycopy(src, offsetSrc, dst, offsetDst, w);
            offsetSrc += w;
            offsetDst += this.rfb.getFrameBufferWidth();
            ++j;
        }
        this.handleUpdatedPixels(x, y, w, h);
    }

    void handleZlibRect(int x, int y, int w, int h) throws Exception {
        int nBytes = this.rfb.readU32();
        if (this.zlibBuf == null || this.zlibBufLen < nBytes) {
            this.zlibBufLen = nBytes * 2;
            this.zlibBuf = new byte[this.zlibBufLen];
        }
        this.rfb.readFully(this.zlibBuf, 0, nBytes);
        if (this.zlibInflater == null) {
            this.zlibInflater = new Inflater();
        }
        this.zlibInflater.setInput(this.zlibBuf, 0, nBytes);
        if (this.bytesPixel == 1) {
            int dy = y;
            while (dy < y + h) {
                this.zlibInflater.inflate(this.pixels8, dy * this.rfb.getFrameBufferWidth() + x, w);
                ++dy;
            }
        } else {
            byte[] buf = new byte[w * 4];
            int dy = y;
            while (dy < y + h) {
                this.zlibInflater.inflate(buf);
                int offset = dy * this.rfb.getFrameBufferWidth() + x;
                int i = 0;
                while (i < w) {
                    this.pixels24[offset + i] = (buf[i * 4 + 2] & 0xFF) << 16 | (buf[i * 4 + 1] & 0xFF) << 8 | buf[i * 4] & 0xFF;
                    ++i;
                }
                ++dy;
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        this.scheduleRepaint(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTightRect(int x, int y, int w, int h) throws Exception {
        int dataSize;
        int i;
        byte[] buf;
        int comp_ctl = this.rfb.readU8();
        int stream_id = 0;
        while (stream_id < 4) {
            if ((comp_ctl & 1) != 0 && this.tightInflaters[stream_id] != null) {
                this.tightInflaters[stream_id] = null;
            }
            comp_ctl >>= 1;
            ++stream_id;
        }
        if (comp_ctl > 9) {
            throw new Exception("Incorrect tight subencoding: " + comp_ctl);
        }
        if (comp_ctl == 8) {
            if (this.bytesPixel == 1) {
                int idx = this.rfb.readU8();
                this.memGraphics.setColor(this.colors[idx]);
            } else {
                byte[] buf2 = new byte[3];
                this.rfb.readFully(buf2);
                Color bg = new Color(0xFF000000 | (buf2[0] & 0xFF) << 16 | (buf2[1] & 0xFF) << 8 | buf2[2] & 0xFF);
                this.memGraphics.setColor(bg);
            }
            this.memGraphics.fillRect(x, y, w, h);
            this.scheduleRepaint(x, y, w, h);
            return;
        }
        if (comp_ctl == 9) {
            ++this.statNumRectsTightJPEG;
            byte[] jpegData = new byte[this.rfb.readCompactLen()];
            this.rfb.readFully(jpegData);
            Image jpegImage = Toolkit.getDefaultToolkit().createImage(jpegData);
            Rectangle rectangle = this.jpegRect = new Rectangle(x, y, w, h);
            synchronized (rectangle) {
                Toolkit.getDefaultToolkit().prepareImage(jpegImage, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new Exception("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        int numColors = 0;
        int rowSize = w;
        byte[] palette8 = new byte[2];
        int[] palette24 = new int[256];
        boolean useGradient = false;
        if ((comp_ctl & 4) != 0) {
            int filter_id = this.rfb.readU8();
            if (filter_id == 1) {
                numColors = this.rfb.readU8() + 1;
                if (this.bytesPixel == 1) {
                    if (numColors != 2) {
                        throw new Exception("Incorrect tight palette size: " + numColors);
                    }
                    this.rfb.readFully(palette8);
                } else {
                    buf = new byte[numColors * 3];
                    this.rfb.readFully(buf);
                    i = 0;
                    while (i < numColors) {
                        palette24[i] = (buf[i * 3] & 0xFF) << 16 | (buf[i * 3 + 1] & 0xFF) << 8 | buf[i * 3 + 2] & 0xFF;
                        ++i;
                    }
                }
                if (numColors == 2) {
                    rowSize = (w + 7) / 8;
                }
            } else if (filter_id == 2) {
                useGradient = true;
            } else if (filter_id != 0) {
                throw new Exception("Incorrect tight filter id: " + filter_id);
            }
        }
        if (numColors == 0 && this.bytesPixel == 4) {
            rowSize *= 3;
        }
        if ((dataSize = h * rowSize) < 12) {
            if (numColors != 0) {
                byte[] indexedData = new byte[dataSize];
                this.rfb.readFully(indexedData);
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(x, y, w, h, indexedData, palette8);
                    } else {
                        this.decodeMonoData(x, y, w, h, indexedData, palette24);
                    }
                } else {
                    i = 0;
                    int dy = y;
                    while (dy < y + h) {
                        int dx = x;
                        while (dx < x + w) {
                            this.pixels24[dy * this.rfb.getFrameBufferWidth() + dx] = palette24[indexedData[i++] & 0xFF];
                            ++dx;
                        }
                        ++dy;
                    }
                }
            } else if (useGradient) {
                buf = new byte[w * h * 3];
                this.rfb.readFully(buf);
                this.decodeGradientData(x, y, w, h, buf);
            } else if (this.bytesPixel == 1) {
                int dy = y;
                while (dy < y + h) {
                    this.rfb.readFully(this.pixels8, dy * this.rfb.getFrameBufferWidth() + x, w);
                    ++dy;
                }
            } else {
                buf = new byte[w * 3];
                int dy = y;
                while (dy < y + h) {
                    this.rfb.readFully(buf);
                    int offset = dy * this.rfb.getFrameBufferWidth() + x;
                    i = 0;
                    while (i < w) {
                        this.pixels24[offset + i] = (buf[i * 3] & 0xFF) << 16 | (buf[i * 3 + 1] & 0xFF) << 8 | buf[i * 3 + 2] & 0xFF;
                        ++i;
                    }
                    ++dy;
                }
            }
        } else {
            int zlibDataLen = this.rfb.readCompactLen();
            byte[] zlibData = new byte[zlibDataLen];
            this.rfb.readFully(zlibData);
            int stream_id2 = comp_ctl & 3;
            if (this.tightInflaters[stream_id2] == null) {
                this.tightInflaters[stream_id2] = new Inflater();
            }
            Inflater myInflater = this.tightInflaters[stream_id2];
            myInflater.setInput(zlibData);
            byte[] buf3 = new byte[dataSize];
            myInflater.inflate(buf3);
            if (numColors != 0) {
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(x, y, w, h, buf3, palette8);
                    } else {
                        this.decodeMonoData(x, y, w, h, buf3, palette24);
                    }
                } else {
                    int i2 = 0;
                    int dy = y;
                    while (dy < y + h) {
                        int dx = x;
                        while (dx < x + w) {
                            this.pixels24[dy * this.rfb.getFrameBufferWidth() + dx] = palette24[buf3[i2++] & 0xFF];
                            ++dx;
                        }
                        ++dy;
                    }
                }
            } else if (useGradient) {
                this.decodeGradientData(x, y, w, h, buf3);
            } else if (this.bytesPixel == 1) {
                int destOffset = y * this.rfb.getFrameBufferWidth() + x;
                int dy = 0;
                while (dy < h) {
                    System.arraycopy(buf3, dy * w, this.pixels8, destOffset, w);
                    destOffset += this.rfb.getFrameBufferWidth();
                    ++dy;
                }
            } else {
                int srcOffset = 0;
                int dy = 0;
                while (dy < h) {
                    myInflater.inflate(buf3);
                    int destOffset = (y + dy) * this.rfb.getFrameBufferWidth() + x;
                    int i3 = 0;
                    while (i3 < w) {
                        this.pixels24[destOffset + i3] = (buf3[srcOffset] & 0xFF) << 16 | (buf3[srcOffset + 1] & 0xFF) << 8 | buf3[srcOffset + 2] & 0xFF;
                        srcOffset += 3;
                        ++i3;
                    }
                    ++dy;
                }
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        this.scheduleRepaint(x, y, w, h);
    }

    void decodeMonoData(int x, int y, int w, int h, byte[] src, byte[] palette) {
        int i = y * this.rfb.getFrameBufferWidth() + x;
        int rowBytes = (w + 7) / 8;
        int dy = 0;
        while (dy < h) {
            int n;
            int dx = 0;
            while (dx < w / 8) {
                byte b = src[dy * rowBytes + dx];
                n = 7;
                while (n >= 0) {
                    this.pixels8[i++] = palette[b >> n & 1];
                    --n;
                }
                ++dx;
            }
            n = 7;
            while (n >= 8 - w % 8) {
                this.pixels8[i++] = palette[src[dy * rowBytes + dx] >> n & 1];
                --n;
            }
            i += this.rfb.getFrameBufferWidth() - w;
            ++dy;
        }
    }

    void decodeMonoData(int x, int y, int w, int h, byte[] src, int[] palette) {
        int i = y * this.rfb.getFrameBufferWidth() + x;
        int rowBytes = (w + 7) / 8;
        int dy = 0;
        while (dy < h) {
            int n;
            int dx = 0;
            while (dx < w / 8) {
                byte b = src[dy * rowBytes + dx];
                n = 7;
                while (n >= 0) {
                    this.pixels24[i++] = palette[b >> n & 1];
                    --n;
                }
                ++dx;
            }
            n = 7;
            while (n >= 8 - w % 8) {
                this.pixels24[i++] = palette[src[dy * rowBytes + dx] >> n & 1];
                --n;
            }
            i += this.rfb.getFrameBufferWidth() - w;
            ++dy;
        }
    }

    void decodeGradientData(int x, int y, int w, int h, byte[] buf) {
        byte[] prevRow = new byte[w * 3];
        byte[] thisRow = new byte[w * 3];
        byte[] pix = new byte[3];
        int[] est = new int[3];
        int offset = y * this.rfb.getFrameBufferWidth() + x;
        int dy = 0;
        while (dy < h) {
            int c = 0;
            while (c < 3) {
                pix[c] = (byte)(prevRow[c] + buf[dy * w * 3 + c]);
                thisRow[c] = pix[c];
                ++c;
            }
            this.pixels24[offset++] = (pix[0] & 0xFF) << 16 | (pix[1] & 0xFF) << 8 | pix[2] & 0xFF;
            int dx = 1;
            while (dx < w) {
                c = 0;
                while (c < 3) {
                    est[c] = (prevRow[dx * 3 + c] & 0xFF) + (pix[c] & 0xFF) - (prevRow[(dx - 1) * 3 + c] & 0xFF);
                    if (est[c] > 255) {
                        est[c] = 255;
                    } else if (est[c] < 0) {
                        est[c] = 0;
                    }
                    pix[c] = (byte)(est[c] + buf[(dy * w + dx) * 3 + c]);
                    thisRow[dx * 3 + c] = pix[c];
                    ++c;
                }
                this.pixels24[offset++] = (pix[0] & 0xFF) << 16 | (pix[1] & 0xFF) << 8 | pix[2] & 0xFF;
                ++dx;
            }
            System.arraycopy(thisRow, 0, prevRow, 0, w * 3);
            offset += this.rfb.getFrameBufferWidth() - w;
            ++dy;
        }
    }

    void handleUpdatedPixels(int x, int y, int w, int h) {
        this.pixelsSource.newPixels(x, y, w, h);
        this.memGraphics.setClip(x, y, w, h);
        this.memGraphics.drawImage(this.rawPixelsImage, 0, 0, null);
        this.memGraphics.setClip(0, 0, this.rfb.getFrameBufferWidth(), this.rfb.getFrameBufferHeight());
    }

    void scheduleRepaint(int x, int y, int w, int h) {
        if (this.rfb.getFrameBufferWidth() != this.scaledWidth) {
            int sx = x * this.scalingFactor / 100;
            int sy = y * this.scalingFactor / 100;
            int sw = ((x + w) * this.scalingFactor + 49) / 100 - sx + 1;
            int sh = ((y + h) * this.scalingFactor + 49) / 100 - sy + 1;
            x = sx;
            y = sy;
            w = sw;
            h = sh;
        }
        this.repaint(this.vnc.getDeferScreenUpdates(), x += this.x, y += this.y, w, h);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        this.processLocalKeyEvent(evt);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        this.processLocalKeyEvent(evt);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        evt.consume();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.processLocalMouseEvent(evt, false);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.processLocalMouseEvent(evt, false);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.processLocalMouseEvent(evt, true);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.processLocalMouseEvent(evt, true);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        this.processLocalMouseWheelEvent(evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalKeyEvent(KeyEvent evt) {
        if (this.rfb != null && this.rfb.isInNormalProtocol()) {
            if (!this.inputEnabled) {
                if ((evt.getKeyChar() == 'r' || evt.getKeyChar() == 'R') && evt.getID() == 401) {
                    try {
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.getFrameBufferWidth(), this.rfb.getFrameBufferHeight(), false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                RFBProtocol rFBProtocol = this.rfb;
                synchronized (rFBProtocol) {
                    try {
                        this.rfb.writeKeyEvent(evt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.rfb.notify();
                }
            }
        }
        evt.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalMouseWheelEvent(MouseWheelEvent evt) {
        if (this.rfb != null && this.rfb.isInNormalProtocol()) {
            boolean process;
            boolean bl = process = evt.getX() >= this.x && evt.getX() <= this.x + this.scaledWidth && evt.getY() >= this.y && evt.getY() <= this.y + this.scaledHeight;
            if (!process) {
                return;
            }
            RFBProtocol rFBProtocol = this.rfb;
            synchronized (rFBProtocol) {
                try {
                    evt = new MouseWheelEvent((Component)evt.getSource(), evt.getID(), evt.getWhen(), evt.getModifiers(), evt.getPoint().x - this.x, evt.getPoint().y - this.y, evt.getClickCount(), evt.isPopupTrigger(), evt.getScrollType(), evt.getScrollAmount(), evt.getWheelRotation());
                    this.rfb.writeWheelEvent(evt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.rfb.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalMouseEvent(MouseEvent evt, boolean moved) {
        if (this.rfb != null && this.rfb.isInNormalProtocol()) {
            boolean process;
            boolean bl = process = evt.getX() >= this.x && evt.getX() <= this.x + this.scaledWidth && evt.getY() >= this.y && evt.getY() <= this.y + this.scaledHeight;
            if (this.showSoftCursor) {
                if (process) {
                    if (this.getCursor() != this.dot) {
                        this.setCursor(this.dot);
                    }
                } else if (this.getCursor() != Cursor.getDefaultCursor()) {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            if (!process) {
                return;
            }
            if (moved) {
                this.softCursorMove(evt.getX(), evt.getY());
            }
            evt = new MouseEvent(evt.getComponent(), evt.getID(), evt.getWhen(), evt.getModifiers(), evt.getX() - this.x, evt.getY() - this.y, evt.getXOnScreen() - this.x, evt.getYOnScreen() - this.y, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
            if (this.rfb.getFrameBufferWidth() != this.scaledWidth) {
                int sx = (evt.getX() * 100 + this.scalingFactor / 2) / this.scalingFactor;
                int sy = (evt.getY() * 100 + this.scalingFactor / 2) / this.scalingFactor;
                evt.translatePoint(sx - evt.getX(), sy - evt.getY());
            }
            RFBProtocol rFBProtocol = this.rfb;
            synchronized (rFBProtocol) {
                try {
                    this.rfb.writePointerEvent(evt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.rfb.notify();
            }
        }
    }

    void resetStats() {
        this.statStartTime = System.currentTimeMillis();
        this.statNumUpdates = 0;
        this.statNumTotalRects = 0;
        this.statNumPixelRects = 0;
        this.statNumRectsTight = 0;
        this.statNumRectsTightJPEG = 0;
        this.statNumRectsZRLE = 0;
        this.statNumRectsHextile = 0;
        this.statNumRectsRaw = 0;
        this.statNumRectsCopy = 0;
        this.statNumBytesEncoded = 0;
        this.statNumBytesDecoded = 0;
    }

    synchronized void handleCursorShapeUpdate(int encodingType, int xhot, int yhot, int width, int height) throws IOException {
        System.out.println("shape update");
        this.softCursorFree();
        if (width * height == 0) {
            return;
        }
        if (Options.ignoreCursorUpdates) {
            int bytesPerRow = (width + 7) / 8;
            int bytesMaskData = bytesPerRow * height;
            if (encodingType == -240) {
                this.rfb.skipBytes(6 + bytesMaskData * 2);
            } else {
                this.rfb.skipBytes(width * height * this.bytesPixel + bytesMaskData);
            }
            return;
        }
        this.softCursorSource = this.decodeCursorShape(encodingType, width, height);
        this.origCursorWidth = width;
        this.origCursorHeight = height;
        this.origHotX = xhot;
        this.origHotY = yhot;
        this.createSoftCursor();
        this.showSoftCursor = true;
        this.repaint(this.vnc.getDeferCursorUpdates(), this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
    }

    synchronized MemoryImageSource decodeCursorShape(int encodingType, int width, int height) throws IOException {
        int bytesPerRow = (width + 7) / 8;
        int bytesMaskData = bytesPerRow * height;
        int[] softCursorPixels = new int[width * height];
        if (encodingType == -240) {
            byte[] rgb = new byte[6];
            this.rfb.readFully(rgb);
            int[] colors = new int[]{0xFF000000 | (rgb[3] & 0xFF) << 16 | (rgb[4] & 0xFF) << 8 | rgb[5] & 0xFF, 0xFF000000 | (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF};
            byte[] pixBuf = new byte[bytesMaskData];
            this.rfb.readFully(pixBuf);
            byte[] maskBuf = new byte[bytesMaskData];
            this.rfb.readFully(maskBuf);
            int i = 0;
            int y = 0;
            while (y < height) {
                int result;
                int n;
                int x = 0;
                while (x < width / 8) {
                    byte pixByte = pixBuf[y * bytesPerRow + x];
                    byte maskByte = maskBuf[y * bytesPerRow + x];
                    n = 7;
                    while (n >= 0) {
                        result = (maskByte >> n & 1) != 0 ? colors[pixByte >> n & 1] : 0;
                        softCursorPixels[i++] = result;
                        --n;
                    }
                    ++x;
                }
                n = 7;
                while (n >= 8 - width % 8) {
                    result = (maskBuf[y * bytesPerRow + x] >> n & 1) != 0 ? colors[pixBuf[y * bytesPerRow + x] >> n & 1] : 0;
                    softCursorPixels[i++] = result;
                    --n;
                }
                ++y;
            }
        } else {
            byte[] pixBuf = new byte[width * height * this.bytesPixel];
            this.rfb.readFully(pixBuf);
            byte[] maskBuf = new byte[bytesMaskData];
            this.rfb.readFully(maskBuf);
            int i = 0;
            int y = 0;
            while (y < height) {
                int result;
                int n;
                int x = 0;
                while (x < width / 8) {
                    byte maskByte = maskBuf[y * bytesPerRow + x];
                    n = 7;
                    while (n >= 0) {
                        result = (maskByte >> n & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(pixBuf[i]) : 0xFF000000 | (pixBuf[i * 4 + 2] & 0xFF) << 16 | (pixBuf[i * 4 + 1] & 0xFF) << 8 | pixBuf[i * 4] & 0xFF) : 0;
                        softCursorPixels[i++] = result;
                        --n;
                    }
                    ++x;
                }
                n = 7;
                while (n >= 8 - width % 8) {
                    result = (maskBuf[y * bytesPerRow + x] >> n & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(pixBuf[i]) : 0xFF000000 | (pixBuf[i * 4 + 2] & 0xFF) << 16 | (pixBuf[i * 4 + 1] & 0xFF) << 8 | pixBuf[i * 4] & 0xFF) : 0;
                    softCursorPixels[i++] = result;
                    --n;
                }
                ++y;
            }
        }
        return new MemoryImageSource(width, height, softCursorPixels, 0, width);
    }

    synchronized void createSoftCursor() {
        int scaleCursor;
        if (this.softCursorSource == null) {
            return;
        }
        int n = scaleCursor = this.scalingFactor < 10 ? 10 : this.scalingFactor;
        if (scaleCursor == 0 || !this.inputEnabled) {
            scaleCursor = 100;
        }
        int x = this.cursorX - this.hotX;
        int y = this.cursorY - this.hotY;
        int w = this.cursorWidth;
        int h = this.cursorHeight;
        this.cursorWidth = (this.origCursorWidth * scaleCursor + 50) / 100;
        this.cursorHeight = (this.origCursorHeight * scaleCursor + 50) / 100;
        this.hotX = (this.origHotX * scaleCursor + 50) / 100;
        this.hotY = (this.origHotY * scaleCursor + 50) / 100;
        this.softCursor = Toolkit.getDefaultToolkit().createImage(this.softCursorSource);
        if (scaleCursor != 100) {
            this.softCursor = this.softCursor.getScaledInstance(this.cursorWidth, this.cursorHeight, 4);
        }
        if (this.showSoftCursor) {
            x = Math.min(x, this.cursorX - this.hotX);
            y = Math.min(y, this.cursorY - this.hotY);
            w = Math.max(w, this.cursorWidth);
            h = Math.max(h, this.cursorHeight);
            this.repaint(this.vnc.getDeferCursorUpdates(), x, y, w, h);
        }
    }

    synchronized void softCursorMove(int x, int y) {
        int oldX = this.cursorX;
        int oldY = this.cursorY;
        this.cursorX = x;
        this.cursorY = y;
        if (this.showSoftCursor) {
            this.repaint(this.vnc.getDeferCursorUpdates(), oldX - this.hotX, oldY - this.hotY, this.cursorWidth, this.cursorHeight);
            this.repaint(this.vnc.getDeferCursorUpdates(), this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }

    synchronized void realCursorMove(int x, int y) {
        if (this.getCursor() != Cursor.getDefaultCursor()) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            this.repaint(this.vnc.getDeferCursorUpdates(), this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }

    private void disableFocusTraversalKeys() {
        try {
            Class[] argClasses = new Class[]{Boolean.TYPE};
            Method method = this.getClass().getMethod("setFocusTraversalKeysEnabled", argClasses);
            Object[] argObjects = new Object[]{new Boolean(false)};
            method.invoke((Object)this, argObjects);
        }
        catch (Exception exception) {}
    }

    void calcGeometry() {
        if (this.rfb == null) {
            return;
        }
        Dimension size = this.getSize();
        this.maxWidth = size.width;
        this.maxHeight = size.height;
        int fbWidth = this.rfb.getFrameBufferWidth();
        int fbHeight = this.rfb.getFrameBufferHeight();
        if (this.maxWidth > 0 && this.maxHeight > 0) {
            int f1 = this.maxWidth * 100 / fbWidth;
            int f2 = this.maxHeight * 100 / fbHeight;
            this.scalingFactor = Math.min(f1, f2);
            System.out.println("Scaling desktop at " + this.scalingFactor + "%");
        }
        this.scaledWidth = (fbWidth * this.scalingFactor + 50) / 100;
        this.scaledHeight = (fbHeight * this.scalingFactor + 50) / 100;
        this.x = Math.max((size.width - this.scaledWidth) / 2, 0);
        this.y = Math.max((size.height - this.scaledHeight) / 2, 0);
        this.createSoftCursor();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.calcGeometry();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public long getStatStartTime() {
        return this.statStartTime;
    }

    public int getStatNumPixelRects() {
        return this.statNumPixelRects;
    }

    public double getStatNumUpdates() {
        return this.statNumUpdates;
    }

    public int getStatNumTotalRects() {
        return this.statNumTotalRects;
    }

    public int getStatNumRectsTight() {
        return this.statNumRectsTight;
    }

    public int getStatNumRectsRaw() {
        return this.statNumRectsRaw;
    }

    public int getStatNumRectsZRLE() {
        return this.statNumRectsZRLE;
    }

    public int getStatNumRectsHextile() {
        return this.statNumRectsHextile;
    }

    public int getStatNumRectsCopy() {
        return this.statNumRectsCopy;
    }

    public int getStatNumRectsTightJPEG() {
        return this.statNumRectsTightJPEG;
    }

    public int getStatNumBytesDecoded() {
        return this.statNumBytesDecoded;
    }

    public int getStatNumBytesEncoded() {
        return this.statNumBytesEncoded;
    }
}

