/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.plugins.remote;

import de.bsc.bapfinder.components.PasswordDialog;
import de.bsc.bapfinder.plugins.remote.VNCPlugin;
import de.bsc.bapfinder.plugins.remote.localization.Messages;
import de.bsc.bapfinder.plugins.remote.vnc.IVNC;
import de.bsc.bapfinder.plugins.remote.vnc.JVNCPanel;
import de.bsc.bapfinder.plugins.remote.vnc.Options;
import de.bsc.bapfinder.plugins.remote.vnc.RFBProtocol;
import de.bsc.bapfinder.plugins.remote.vnc.tools.DesCipher;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class VNCDialog
extends JFrame
implements IVNC,
Runnable {
    private static final long serialVersionUID = -838101851555685139L;
    private RFBProtocol rfb;
    private Thread rfbThread;
    private String host;
    private int port;
    private String ftpDropDown;
    private String passwordParam;
    private boolean showOfflineDesktop;
    private int deferScreenUpdates;
    private int deferCursorUpdates;
    private int deferUpdateRequests;
    private int debugStatsExcludeUpdates;
    private int debugStatsMeasureUpdates;
    private boolean ftpOnly;
    private boolean graftFtp;
    private int[] encodingsSaved;
    private int nEncodingsSaved;
    private JVNCPanel vncPanel;
    private VNCPlugin plugin;

    public VNCDialog() {
        this((VNCPlugin)null);
    }

    public VNCDialog(VNCPlugin vncPlugin) {
        this.plugin = vncPlugin;
        this.host = vncPlugin.device.getIp();
        this.port = 5900;
        this.initGUI();
        this.initVNC();
    }

    public void initVNC() {
        this.rfb = new RFBProtocol(this.host, this.port, this);
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    private void initGUI() {
        this.setSize(1024, 768);
        this.setLocationRelativeTo(null);
        this.getContentPane().add((Component)this.getPanel(), "Center");
        this.setDefaultCloseOperation(2);
        this.setTitle(Messages.getString("VNC.0"));
        this.setIconImage(this.plugin.loadImage("serverkl.png"));
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VNCDialog.this.disconnect();
                VNCDialog.this.plugin.enableParent(true);
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.plugin.enableParent(!b);
    }

    @Override
    public void run() {
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            this.vncPanel.start(this.rfb);
        }
        catch (NoRouteToHostException e) {
            this.fatalError("Network error: no route to server: " + this.host, e);
        }
        catch (UnknownHostException e) {
            this.fatalError("Network error: server name unknown: " + this.host, e);
        }
        catch (ConnectException e) {
            this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port, e);
        }
        catch (EOFException e) {
            if (this.showOfflineDesktop) {
                e.printStackTrace();
                System.out.println("Network error: remote side closed connection");
                if (this.vncPanel != null) {
                    this.vncPanel.enableInput(false);
                }
                if (this.rfb != null && !this.rfb.closed()) {
                    this.rfb.disconnect();
                }
            } else {
                this.fatalError("Network error: remote side closed connection", e);
            }
        }
        catch (IOException e) {
            String str = e.getMessage();
            if (str != null && str.length() != 0) {
                this.fatalError("Network Error: " + str, e);
            } else {
                this.fatalError(e.toString(), e);
            }
        }
        catch (Exception e) {
            String str = e.getMessage();
            if (str != null && str.length() != 0) {
                this.fatalError("Error: " + str, e);
            }
            this.fatalError(e.toString(), e);
        }
    }

    void connectAndAuthenticate() throws Exception {
        System.out.println("Initializing...");
        System.out.println("Connecting to " + this.host + ", port " + this.port + "...");
        this.rfb.connect();
        System.out.println("Connected to server");
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.getServerMajor() + "." + this.rfb.getServerMinor());
        this.rfb.writeVersionMsg();
        System.out.println("Using RFB protocol version " + this.rfb.getClientMajor() + "." + this.rfb.getClientMinor());
        int secType = this.rfb.negotiateSecurity();
        int authType = secType == 16 ? secType : secType;
        switch (authType) {
            case 1: {
                System.out.println("No authentication needed");
                this.rfb.authenticateNone();
                break;
            }
            case 2: {
                System.out.println("Performing standard VNC authentication");
                String pw = null;
                if (this.passwordParam == null) {
                    pw = PasswordDialog.getPassword(this);
                    if (pw == null) {
                        this.disconnect();
                        this.setVisible(false);
                        this.dispose();
                        return;
                    }
                } else {
                    pw = this.passwordParam;
                }
                try {
                    this.rfb.authenticateVNC(pw);
                    break;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, Messages.getString("VNC.1"));
                    this.disconnect();
                    this.setVisible(false);
                    this.dispose();
                    return;
                }
            }
            default: {
                throw new Exception("Unknown authentication scheme " + authType);
            }
        }
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        String name = this.rfb.getDesktopName();
        int width = this.rfb.getFrameBufferWidth();
        int height = this.rfb.getFrameBufferHeight();
        System.out.println("Desktop name is " + name);
        System.out.println("Desktop size is " + width + " x " + height);
        final String title = String.valueOf(Messages.getString("VNC.0")) + ": " + name + "@" + width + "x" + height;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VNCDialog.this.setTitle(title);
            }
        });
        this.setEncodings();
    }

    private void setEncodings() {
        this.setEncodings(false);
    }

    private void setEncodings(boolean autoSelectOnly) {
        if (this.rfb == null || !this.rfb.isInNormalProtocol()) {
            return;
        }
        int preferredEncoding = Options.preferredEncoding;
        if (preferredEncoding == -1) {
            long kbitsPerSecond = this.rfb.kbitsPerSecond();
            if (this.nEncodingsSaved < 1) {
                System.out.println("Using Tight/ZRLE encodings");
                preferredEncoding = 7;
            } else if (kbitsPerSecond > 2000L && this.encodingsSaved[0] != 5) {
                System.out.println("Throughput " + kbitsPerSecond + " kbit/s - changing to Hextile encoding");
                preferredEncoding = 5;
            } else if (kbitsPerSecond < 1000L && this.encodingsSaved[0] != 7) {
                System.out.println("Throughput " + kbitsPerSecond + " kbit/s - changing to Tight/ZRLE encodings");
                preferredEncoding = 7;
            } else {
                if (autoSelectOnly) {
                    return;
                }
                preferredEncoding = this.encodingsSaved[0];
            }
        } else if (autoSelectOnly) {
            return;
        }
        int[] encodings = new int[20];
        int nEncodings = 0;
        encodings[nEncodings++] = preferredEncoding;
        if (Options.useCopyRect) {
            encodings[nEncodings++] = 1;
        }
        if (preferredEncoding != 7) {
            encodings[nEncodings++] = 7;
        }
        if (preferredEncoding != 16) {
            encodings[nEncodings++] = 16;
        }
        if (preferredEncoding != 5) {
            encodings[nEncodings++] = 5;
        }
        if (preferredEncoding != 6) {
            encodings[nEncodings++] = 6;
        }
        if (preferredEncoding != 4) {
            encodings[nEncodings++] = 4;
        }
        if (preferredEncoding != 2) {
            encodings[nEncodings++] = 2;
        }
        if (Options.compressLevel >= 0 && Options.compressLevel <= 9) {
            encodings[nEncodings++] = -256 + Options.compressLevel;
        }
        if (Options.jpegQuality >= 0 && Options.jpegQuality <= 9) {
            encodings[nEncodings++] = -32 + Options.jpegQuality;
        }
        if (Options.requestCursorUpdates) {
            encodings[nEncodings++] = -240;
            encodings[nEncodings++] = -239;
            if (!Options.ignoreCursorUpdates) {
                encodings[nEncodings++] = -232;
            }
        }
        encodings[nEncodings++] = -224;
        encodings[nEncodings++] = -223;
        boolean encodingsWereChanged = false;
        if (nEncodings != this.nEncodingsSaved) {
            encodingsWereChanged = true;
        } else {
            int i = 0;
            while (i < nEncodings) {
                if (encodings[i] != this.encodingsSaved[i]) {
                    encodingsWereChanged = true;
                    break;
                }
                ++i;
            }
        }
        if (encodingsWereChanged) {
            try {
                this.rfb.writeSetEncodings(encodings, nEncodings);
                if (this.vncPanel != null) {
                    this.vncPanel.softCursorFree();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.encodingsSaved = encodings;
            this.nEncodingsSaved = nEncodings;
        }
    }

    private JVNCPanel getPanel() {
        if (this.vncPanel == null) {
            try {
                this.vncPanel = new JVNCPanel(this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.vncPanel;
    }

    @Override
    public synchronized void disconnect() {
        System.out.println("Disconnecting");
        if (this.vncPanel != null) {
            double sec = (double)(System.currentTimeMillis() - this.vncPanel.getStatStartTime()) / 1000.0;
            double rate = (double)Math.round(this.vncPanel.getStatNumUpdates() / sec * 100.0) / 100.0;
            int nRealRects = this.vncPanel.getStatNumPixelRects();
            int nPseudoRects = this.vncPanel.getStatNumTotalRects() - this.vncPanel.getStatNumPixelRects();
            System.out.println("Updates received: " + this.vncPanel.getStatNumUpdates() + " (" + nRealRects + " rectangles + " + nPseudoRects + " pseudo), " + rate + " updates/sec");
            int numRectsOther = nRealRects - this.vncPanel.getStatNumRectsTight() - this.vncPanel.getStatNumRectsZRLE() - this.vncPanel.getStatNumRectsHextile() - this.vncPanel.getStatNumRectsRaw() - this.vncPanel.getStatNumRectsCopy();
            System.out.println("Rectangles: Tight=" + this.vncPanel.getStatNumRectsTight() + "(JPEG=" + this.vncPanel.getStatNumRectsTightJPEG() + ") ZRLE=" + this.vncPanel.getStatNumRectsZRLE() + " Hextile=" + this.vncPanel.getStatNumRectsHextile() + " Raw=" + this.vncPanel.getStatNumRectsRaw() + " CopyRect=" + this.vncPanel.getStatNumRectsCopy() + " other=" + numRectsOther);
            int raw = this.vncPanel.getStatNumBytesDecoded();
            int compressed = this.vncPanel.getStatNumBytesEncoded();
            if (compressed > 0) {
                double ratio = (double)Math.round((double)raw / (double)compressed * 1000.0) / 1000.0;
                System.out.println("Pixel data: " + this.vncPanel.getStatNumBytesDecoded() + " bytes, " + this.vncPanel.getStatNumBytesEncoded() + " compressed, ratio " + ratio);
            }
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.disconnect();
        }
    }

    private synchronized void fatalError(String str) {
        System.out.println(str);
        System.exit(1);
    }

    private synchronized void fatalError(String str, Exception e) {
        if (this.rfb != null && this.rfb.closed()) {
            System.out.println("RFB thread finished");
            return;
        }
        System.out.println(str);
        e.printStackTrace();
        if (this.rfb != null) {
            this.rfb.disconnect();
        }
        JOptionPane.showMessageDialog(this, str);
        this.dispose();
    }

    @Override
    public void dispose() {
        this.plugin.enableParent(true);
        super.dispose();
    }

    private void readParameters(String[] args) {
        this.host = this.readParameter(args, "HOST", true);
        if (this.host == null) {
            this.fatalError("HOST parameter not specified");
        }
        this.port = this.readIntParameter(args, "PORT", 5900);
        this.readPasswordParameters(args);
        this.showOfflineDesktop = false;
        String str = this.readParameter(args, "Show Offline Desktop", false);
        if (str != null && str.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.ftpDropDown = this.readParameter(args, "ftpDropDown", false);
        if (this.ftpDropDown != null) {
            this.ftpDropDown = this.ftpDropDown.replaceAll("%2F", "/");
            this.ftpDropDown = this.ftpDropDown.replaceAll("%2f", "/");
            this.ftpDropDown = this.ftpDropDown.replaceAll("_2F_", "/");
            this.ftpDropDown = this.ftpDropDown.replaceAll("%20", " ");
            System.out.println("ftpDropDown: '" + this.ftpDropDown + "'");
        }
        this.ftpOnly = false;
        str = this.readParameter(args, "ftpOnly", false);
        if (str != null && str.equalsIgnoreCase("Yes")) {
            this.ftpOnly = true;
        }
        this.graftFtp = false;
        str = this.readParameter(args, "graftFtp", false);
        if (str != null && str.equalsIgnoreCase("Yes")) {
            this.graftFtp = true;
        }
        this.deferScreenUpdates = this.readIntParameter(args, "Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter(args, "Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter(args, "Defer update requests", 0);
        this.debugStatsExcludeUpdates = this.readIntParameter(args, "DEBUG_XU", 0);
        this.debugStatsMeasureUpdates = this.readIntParameter(args, "DEBUG_CU", 0);
    }

    private void readPasswordParameters(String[] args) {
        String encPasswordParam = this.readParameter(args, "ENCPASSWORD", false);
        if (encPasswordParam == null) {
            this.passwordParam = this.readParameter(args, "PASSWORD", false);
        } else {
            byte[] pw = new byte[8];
            int len = encPasswordParam.length() / 2;
            if (len > 8) {
                len = 8;
            }
            int i = 0;
            while (i < len) {
                String hex = encPasswordParam.substring(i * 2, i * 2 + 2);
                Integer x = new Integer(Integer.parseInt(hex, 16));
                pw[i] = x.byteValue();
                ++i;
            }
            byte[] key = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            DesCipher des = new DesCipher(key);
            des.decrypt(pw, 0, pw, 0);
            this.passwordParam = new String(pw);
        }
    }

    public String readParameter(String[] args, String name, boolean required) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase(name)) {
                try {
                    return args[i + 1];
                }
                catch (Exception exception) {
                    if (required) {
                        this.fatalError(String.valueOf(name) + " parameter not specified");
                    }
                    return null;
                }
            }
            i += 2;
        }
        if (required) {
            this.fatalError(String.valueOf(name) + " parameter not specified");
        }
        return null;
    }

    private int readIntParameter(String[] args, String name, int defaultValue) {
        String str = this.readParameter(args, name, false);
        int result = defaultValue;
        if (str != null) {
            try {
                result = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private void setCutText(String text) {
        try {
            if (this.rfb != null && this.rfb.isInNormalProtocol()) {
                this.rfb.writeClientCutText(text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void autoSelectEncodings() {
        this.setEncodings(true);
    }

    @Override
    public RFBProtocol getProtocol() {
        return this.rfb;
    }

    @Override
    public int getDeferUpdateRequests() {
        return this.deferUpdateRequests;
    }

    @Override
    public String getFTPDropDown() {
        return this.ftpDropDown;
    }

    @Override
    public boolean isFTPOnly() {
        return this.ftpOnly;
    }

    @Override
    public boolean isGraftOnly() {
        return this.graftFtp;
    }

    @Override
    public int getDebugStatsExcludeUpdates() {
        return this.debugStatsExcludeUpdates;
    }

    @Override
    public int getDebugStatsMeasureUpdates() {
        return this.debugStatsMeasureUpdates;
    }

    @Override
    public int getDeferScreenUpdates() {
        return this.deferScreenUpdates;
    }

    @Override
    public int getDeferCursorUpdates() {
        return this.deferCursorUpdates;
    }
}

